/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.integration.deployers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.mcann.AnnotationRepository;
import org.jboss.mcann.Element;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.resteasy.integration.deployers.ResteasyDeploymentData;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrapClasses;

public class ResteasyScannerDeployer
extends AbstractRealDeployer {
    private static final Logger LOGGER = Logger.getLogger(ResteasyScannerDeployer.class);
    public static final Set<String> BOOT_CLASSES = new HashSet<String>();

    public ResteasyScannerDeployer() {
        this.addRequiredInput(JBossWebMetaData.class);
        this.addInput(AnnotationRepository.class);
        this.addOutput(JBossWebMetaData.class);
        this.addOutput(ResteasyDeploymentData.class);
        this.setStage(DeploymentStages.PRE_REAL);
    }

    protected void internalDeploy(DeploymentUnit du) throws DeploymentException {
        JBossWebMetaData webdata = (JBossWebMetaData)du.getAttachment(JBossWebMetaData.class);
        boolean applicationClassDeployed = this.deployApplicationClass(du, webdata);
        if (applicationClassDeployed) {
            return;
        }
        this.scan(du, webdata);
    }

    protected boolean scannable(DeploymentUnit du, JBossWebMetaData webdata) throws DeploymentException {
        ClassLoader loader = du.getClassLoader();
        if (webdata.getServlets() != null) {
            for (JBossServletMetaData servlet : webdata.getServlets()) {
                String servletClass = servlet.getServletClass();
                if (!BOOT_CLASSES.contains(servletClass)) continue;
                return false;
            }
        }
        if (webdata.getFilters() != null) {
            for (FilterMetaData filter : webdata.getFilters()) {
                if (!BOOT_CLASSES.contains(filter.getFilterClass())) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean deployApplicationClass(DeploymentUnit du, JBossWebMetaData webdata) throws DeploymentException {
        ClassLoader loader = du.getClassLoader();
        if (webdata.getServlets() == null) {
            return false;
        }
        for (JBossServletMetaData servlet : webdata.getServlets()) {
            String servletClass = servlet.getServletClass();
            if (servletClass == null) continue;
            Class<?> clazz = null;
            try {
                clazz = loader.loadClass(servletClass);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException((Throwable)e);
            }
            if (!Application.class.isAssignableFrom(clazz)) continue;
            servlet.setServletClass(HttpServletDispatcher.class.getName());
            ParamValueMetaData param = new ParamValueMetaData();
            param.setParamName("javax.ws.rs.Application");
            param.setParamValue(servletClass);
            ArrayList<ParamValueMetaData> params = servlet.getInitParam();
            if (params == null) {
                params = new ArrayList<ParamValueMetaData>();
                servlet.setInitParam(params);
            }
            params.add(param);
            return true;
        }
        return false;
    }

    protected void scan(DeploymentUnit du, JBossWebMetaData webdata) throws DeploymentException {
        ResteasyDeploymentData scanningData = new ResteasyDeploymentData();
        if (this.scannable(du, webdata) && !webdata.isMetadataComplete()) {
            scanningData.setScanAll(true);
            scanningData.setScanProviders(true);
            scanningData.setScanResources(true);
        }
        List contextParams = webdata.getContextParams();
        boolean hasResourceParam = false;
        boolean hasProviderParam = false;
        boolean hasJndiParam = false;
        if (contextParams != null) {
            for (ParamValueMetaData param : contextParams) {
                if (param.getParamName().equals("resteasy.scan")) {
                    scanningData.setScanAll(Boolean.valueOf(param.getParamValue()));
                    continue;
                }
                if (param.getParamName().equals("resteasy.scan.providers")) {
                    scanningData.setScanProviders(Boolean.valueOf(param.getParamValue()));
                    continue;
                }
                if (param.getParamName().equals("resteasy.scan.resources")) {
                    scanningData.setScanResources(Boolean.valueOf(param.getParamValue()));
                    continue;
                }
                if (param.getParamName().equals("resteasy.resources")) {
                    hasResourceParam = true;
                    continue;
                }
                if (param.getParamName().equals("resteasy.providers")) {
                    hasProviderParam = true;
                    continue;
                }
                if (!param.getParamName().equals("resteasy.jndi.resources")) continue;
                hasJndiParam = true;
            }
        }
        if (!scanningData.shouldScan()) {
            if (hasResourceParam || hasProviderParam || hasJndiParam) {
                scanningData.createDispatcher();
                du.addAttachment(ResteasyDeploymentData.class, (Object)scanningData);
            }
            return;
        }
        du.addAttachment(ResteasyDeploymentData.class, (Object)scanningData);
        AnnotationRepository env = (AnnotationRepository)du.getAttachment(AnnotationRepository.class);
        if (env == null) {
            LOGGER.debug((Object)"Expecting AnnotationRepository class for scanning WAR for JAX-RS classes");
            return;
        }
        Set resources = null;
        Set providers = null;
        if (scanningData.isScanResources()) {
            resources = env.classIsAnnotatedWith(Path.class);
        }
        if (scanningData.isScanProviders()) {
            providers = env.classIsAnnotatedWith(Provider.class);
        }
        if ((resources == null || resources.isEmpty()) && (providers == null || providers.isEmpty())) {
            return;
        }
        if (resources != null) {
            for (Element e : resources) {
                if (e.getOwner().isInterface()) continue;
                scanningData.getResources().add(e.getOwnerClassName());
            }
        }
        if (providers != null) {
            for (Element e : providers) {
                if (e.getOwner().isInterface()) continue;
                scanningData.getResources().add(e.getOwnerClassName());
            }
        }
    }

    static {
        for (String clazz : ResteasyBootstrapClasses.BOOTSTRAP_CLASSES) {
            BOOT_CLASSES.add(clazz);
        }
    }
}

