/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.singleton.impl.container;

import java.io.Serializable;
import org.jboss.ejb3.container.spi.BeanContext;
import org.jboss.ejb3.container.spi.EJBContainer;
import org.jboss.ejb3.container.spi.lifecycle.EJBLifecycleHandler;
import org.jboss.ejb3.singleton.impl.container.SingletonBeanContext;
import org.jboss.ejb3.singleton.spi.SingletonEJBInstanceManager;

public class SingletonEJBInstanceManagerImpl
implements SingletonEJBInstanceManager {
    protected Class<?> beanClass;
    protected EJBContainer container;
    protected EJBLifecycleHandler beanInstanceLifecycleHandler;
    protected BeanContext singletonBeanContext;

    public SingletonEJBInstanceManagerImpl(Class<?> beanClass, EJBContainer container, EJBLifecycleHandler lifecycleHandler) {
        this.beanClass = beanClass;
        this.container = container;
        this.beanInstanceLifecycleHandler = lifecycleHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable create() {
        if (this.singletonBeanContext == null) {
            boolean newInstanceCreated = false;
            SingletonEJBInstanceManagerImpl singletonEJBInstanceManagerImpl = this;
            synchronized (singletonEJBInstanceManagerImpl) {
                if (this.singletonBeanContext == null) {
                    Object beanInstance = this.createBeanInstance();
                    this.singletonBeanContext = this.createBeanContext(beanInstance);
                    newInstanceCreated = true;
                }
            }
            if (newInstanceCreated && this.beanInstanceLifecycleHandler != null) {
                try {
                    this.beanInstanceLifecycleHandler.postConstruct(this.singletonBeanContext);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not invoke PostConstruct on the newly created bean instance", e);
                }
            }
        }
        return this.singletonBeanContext.getSessionId();
    }

    public BeanContext get() {
        if (this.singletonBeanContext == null) {
            this.create();
        }
        return this.singletonBeanContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        SingletonEJBInstanceManagerImpl singletonEJBInstanceManagerImpl = this;
        synchronized (singletonEJBInstanceManagerImpl) {
            if (this.singletonBeanContext == null) {
                return;
            }
        }
        try {
            this.beanInstanceLifecycleHandler.preDestroy(this.singletonBeanContext);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not preDestroy the singleton bean instance", e);
        }
        singletonEJBInstanceManagerImpl = this;
        synchronized (singletonEJBInstanceManagerImpl) {
            this.singletonBeanContext = null;
        }
    }

    public EJBContainer getEJBContainer() {
        return this.container;
    }

    public void destroy(Serializable sessionId) throws IllegalArgumentException, IllegalStateException {
        throw new IllegalStateException("destroy(sessionId) cannot be called on a singleton bean's instance manager");
    }

    public boolean isSessionAware() {
        return false;
    }

    protected BeanContext createBeanContext(Object beanInstance) {
        return new SingletonBeanContext(beanInstance, this.container);
    }

    protected Object createBeanInstance() {
        try {
            return this.beanClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Could not create an instance of the bean classs: " + this.beanClass, ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Could not create an instance of the bean class: " + this.beanClass, iae);
        }
    }
}

