/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspCollector;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Buffer;
import org.jgroups.util.Util;

public class RequestCorrelator {
    protected Object transport = null;
    protected final ConcurrentMap<Long, RspCollector> requests = new ConcurrentHashMap<Long, RspCollector>();
    protected RequestHandler request_handler = null;
    protected RpcDispatcher.Marshaller2 marshaller = null;
    protected short id = ClassConfigurator.getProtocolId(this.getClass());
    protected Address local_addr = null;
    protected boolean started = false;
    private final MyProbeHandler probe_handler = new MyProbeHandler(this.requests);
    protected static final Log log = LogFactory.getLog(RequestCorrelator.class);

    @Deprecated
    public RequestCorrelator(String name, Object transport, RequestHandler handler) {
        this.transport = transport;
        this.request_handler = handler;
        this.start();
    }

    @Deprecated
    public RequestCorrelator(String name, Object transport, RequestHandler handler, Address local_addr) {
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(short id, Object transport, RequestHandler handler, Address local_addr) {
        this.id = id;
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    @Deprecated
    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection) {
        this.transport = transport;
        this.request_handler = handler;
        this.start();
    }

    @Deprecated
    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection, boolean concurrent_processing) {
        this.transport = transport;
        this.request_handler = handler;
        this.start();
    }

    @Deprecated
    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection, Address local_addr) {
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    @Deprecated
    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection, Address local_addr, boolean concurrent_processing) {
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    @Deprecated
    public RequestCorrelator(String name, Object transport, RequestHandler handler, Address local_addr, boolean concurrent_processing) {
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    public void setDeadlockDetection(boolean flag) {
    }

    public void setRequestHandler(RequestHandler handler) {
        this.request_handler = handler;
        this.start();
    }

    public void setConcurrentProcessing(boolean concurrent_processing) {
    }

    @Deprecated
    public void sendRequest(long id, Message msg, RspCollector coll) throws Exception {
        this.sendRequest(id, null, msg, coll);
    }

    public RpcDispatcher.Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(RpcDispatcher.Marshaller marshaller) {
        this.marshaller = marshaller == null ? null : (marshaller instanceof RpcDispatcher.Marshaller2 ? (RpcDispatcher.Marshaller2)marshaller : new RpcDispatcher.MarshallerAdapter(marshaller));
    }

    public void sendRequest(long id, List<Address> dest_mbrs, Message msg, RspCollector coll) throws Exception {
        this.sendRequest(id, dest_mbrs, msg, coll, false);
    }

    public void sendRequest(long id, Collection<Address> dest_mbrs, Message msg, RspCollector coll, boolean use_anycasting) throws Exception {
        if (this.transport == null) {
            if (log.isWarnEnabled()) {
                log.warn("transport is not available !");
            }
            return;
        }
        MultiDestinationHeader hdr = new MultiDestinationHeader(0, id, coll != null, this.id, dest_mbrs);
        msg.putHeader(this.id, hdr);
        if (coll != null) {
            this.addEntry(hdr.id, coll);
        }
        if (this.transport instanceof Protocol) {
            if (use_anycasting) {
                for (Address mbr : dest_mbrs) {
                    Message copy = msg.copy(true);
                    copy.setDest(mbr);
                    ((Protocol)this.transport).down(new Event(1, copy));
                }
            } else {
                ((Protocol)this.transport).down(new Event(1, msg));
            }
        } else if (this.transport instanceof Transport) {
            if (use_anycasting) {
                for (Address mbr : dest_mbrs) {
                    Message copy = msg.copy(true);
                    copy.setDest(mbr);
                    ((Transport)this.transport).send(copy);
                }
            } else {
                ((Transport)this.transport).send(msg);
            }
        } else {
            throw new IllegalStateException("transport has to be either a Transport or a Protocol, however it is a " + this.transport.getClass());
        }
    }

    public void sendUnicastRequest(long id, Address target, Message msg, RspCollector coll) throws Exception {
        if (this.transport == null) {
            if (log.isWarnEnabled()) {
                log.warn("transport is not available !");
            }
            return;
        }
        SingleDestinationHeader hdr = new SingleDestinationHeader(0, id, coll != null, this.id);
        msg.putHeader(this.id, hdr);
        if (coll != null) {
            this.addEntry(hdr.id, coll);
        }
        if (this.transport instanceof Protocol) {
            ((Protocol)this.transport).down(new Event(1, msg));
        } else if (this.transport instanceof Transport) {
            ((Transport)this.transport).send(msg);
        } else {
            throw new IllegalStateException("transport has to be either a Transport or a Protocol, however it is a " + this.transport.getClass());
        }
    }

    public void done(long id) {
        this.removeEntry(id);
    }

    public boolean receive(Event evt) {
        switch (evt.getType()) {
            case 9: {
                this.receiveSuspect((Address)evt.getArg());
                break;
            }
            case 6: {
                this.receiveView((View)evt.getArg());
                break;
            }
            case 8: {
                this.setLocalAddress((Address)evt.getArg());
                break;
            }
            case 1: {
                if (!this.receiveMessage((Message)evt.getArg())) break;
                return true;
            }
        }
        return false;
    }

    public final void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public void registerProbeHandler(TP transport) {
        if (transport != null) {
            transport.registerProbeHandler(this.probe_handler);
        }
    }

    public void unregisterProbeHandler(TP transport) {
        if (transport != null) {
            transport.unregisterProbeHandler(this.probe_handler);
        }
    }

    public void receiveSuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("suspect=" + mbr);
        }
        for (RspCollector coll : this.requests.values()) {
            if (coll == null) continue;
            coll.suspect(mbr);
        }
    }

    public void receiveView(View new_view) {
        for (RspCollector coll : this.requests.values()) {
            if (coll == null) continue;
            coll.viewChange(new_view);
        }
    }

    public boolean receiveMessage(Message msg) {
        Header hdr = (Header)msg.getHeader(this.id);
        if (hdr == null) {
            return false;
        }
        if (hdr.corrId != this.id) {
            if (log.isTraceEnabled()) {
                log.trace(new StringBuilder("id of request correlator header (").append(hdr.corrId).append(") is different from ours (").append(this.id).append("). Msg not accepted, passed up"));
            }
            return false;
        }
        if (hdr instanceof MultiDestinationHeader) {
            Collection<? extends Address> dests = ((MultiDestinationHeader)hdr).dest_mbrs;
            if (dests != null && this.local_addr != null && !dests.contains(this.local_addr)) {
                if (log.isTraceEnabled()) {
                    log.trace(new StringBuilder("discarded request from ").append(msg.getSrc()).append(" as we are not part of destination list (local_addr=").append(this.local_addr).append(", hdr=").append(hdr).append(')'));
                }
                return true;
            }
        } else if (!(hdr instanceof SingleDestinationHeader)) {
            log.error("header is not known: " + hdr.getClass());
            return true;
        }
        switch (hdr.type) {
            case 0: {
                if (this.request_handler == null) {
                    if (log.isWarnEnabled()) {
                        log.warn("there is no request handler installed to deliver request !");
                    }
                    return true;
                }
                this.handleRequest(msg, hdr);
                break;
            }
            case 1: {
                Object retval;
                RspCollector coll = (RspCollector)this.requests.get(hdr.id);
                if (coll == null) break;
                Address sender = msg.getSrc();
                byte[] buf = msg.getBuffer();
                int offset = msg.getOffset();
                int length = msg.getLength();
                try {
                    retval = this.marshaller != null ? this.marshaller.objectFromByteBuffer(buf, offset, length) : Util.objectFromByteBuffer(buf, offset, length);
                }
                catch (Exception e) {
                    log.error("failed unmarshalling buffer into return value", e);
                    retval = e;
                }
                coll.receiveResponse(retval, sender);
                break;
            }
            default: {
                msg.getHeader(this.id);
                if (!log.isErrorEnabled()) break;
                log.error("header's type is neither REQ nor RSP !");
            }
        }
        return true;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public void setLocalAddress(Address local_addr) {
        this.local_addr = local_addr;
    }

    private void addEntry(long id, RspCollector coll) {
        this.requests.putIfAbsent(id, coll);
    }

    private void removeEntry(long id) {
        this.requests.remove(id);
    }

    protected void handleRequest(Message req, Header hdr) {
        block24: {
            byte[] rsp_buf;
            Object retval;
            if (log.isTraceEnabled()) {
                log.trace(new StringBuilder("calling (").append(this.request_handler != null ? this.request_handler.getClass().getName() : "null").append(") with request ").append(hdr.id));
            }
            try {
                retval = this.request_handler.handle(req);
            }
            catch (Throwable t) {
                if (log.isErrorEnabled()) {
                    log.error("error invoking method", t);
                }
                retval = t;
            }
            if (!hdr.rsp_expected) {
                return;
            }
            if (this.transport == null) {
                if (log.isErrorEnabled()) {
                    log.error("failure sending response; no transport available");
                }
                return;
            }
            try {
                rsp_buf = this.marshaller != null ? (Object)this.marshaller.objectToBuffer(retval) : Util.objectToByteBuffer(retval);
            }
            catch (Throwable t) {
                try {
                    rsp_buf = this.marshaller != null ? (Object)this.marshaller.objectToBuffer(t) : Util.objectToByteBuffer(t);
                }
                catch (Throwable tt) {
                    if (log.isErrorEnabled()) {
                        log.error("failed sending rsp: return value (" + retval + ") is not serializable");
                    }
                    return;
                }
            }
            Message rsp = req.makeReply();
            rsp.setFlag((byte)1);
            rsp.setFlag((byte)4);
            if (req.isFlagSet((byte)8)) {
                rsp.setFlag((byte)8);
            }
            if (rsp_buf instanceof Buffer) {
                rsp.setBuffer((Buffer)rsp_buf);
            } else if (rsp_buf instanceof byte[]) {
                rsp.setBuffer(rsp_buf);
            }
            SingleDestinationHeader rsp_hdr = new SingleDestinationHeader(1, hdr.id, false, this.id);
            rsp.putHeader(this.id, rsp_hdr);
            if (log.isTraceEnabled()) {
                log.trace(new StringBuilder("sending rsp for ").append(rsp_hdr.id).append(" to ").append(rsp.getDest()));
            }
            try {
                if (this.transport instanceof Protocol) {
                    ((Protocol)this.transport).down(new Event(1, rsp));
                } else if (this.transport instanceof Transport) {
                    ((Transport)this.transport).send(rsp);
                } else if (log.isErrorEnabled()) {
                    log.error("transport object has to be either a Transport or a Protocol, however it is a " + this.transport.getClass());
                }
            }
            catch (Throwable e) {
                if (!log.isErrorEnabled()) break block24;
                log.error("failed sending the response", e);
            }
        }
    }

    private static class MyProbeHandler
    implements TP.ProbeHandler {
        private final ConcurrentMap<Long, RspCollector> requests;

        public MyProbeHandler(ConcurrentMap<Long, RspCollector> requests) {
            this.requests = requests;
        }

        @Override
        public Map<String, String> handleProbe(String ... keys) {
            if (this.requests == null) {
                return null;
            }
            HashMap<String, String> retval = new HashMap<String, String>();
            for (String key : keys) {
                if (!key.equals("requests")) continue;
                StringBuilder sb = new StringBuilder();
                for (Map.Entry entry : this.requests.entrySet()) {
                    sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
                }
                retval.put("requests", sb.toString());
                break;
            }
            return retval;
        }

        @Override
        public String[] supportedKeys() {
            return new String[]{"requests"};
        }
    }

    public static final class MultiDestinationHeader
    extends Header {
        public Collection<? extends Address> dest_mbrs;

        public MultiDestinationHeader() {
        }

        public MultiDestinationHeader(byte type, long id, boolean rsp_expected, short corr_id, Collection<Address> dest_mbrs) {
            super(type, id, rsp_expected, corr_id);
            this.dest_mbrs = dest_mbrs;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.dest_mbrs);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.dest_mbrs = (List)in.readObject();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            super.writeTo(out);
            Util.writeAddresses(this.dest_mbrs, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            super.readFrom(in);
            this.dest_mbrs = Util.readAddresses(in, LinkedList.class);
        }

        @Override
        public int size() {
            return (int)((long)super.size() + Util.size(this.dest_mbrs));
        }

        @Override
        public String toString() {
            String str = super.toString();
            if (this.dest_mbrs != null) {
                str = str + ", dest_mbrs=" + this.dest_mbrs;
            }
            return str;
        }
    }

    public static final class SingleDestinationHeader
    extends Header {
        public SingleDestinationHeader() {
        }

        public SingleDestinationHeader(byte type, long id, boolean rsp_expected, short corr_id) {
            super(type, id, rsp_expected, corr_id);
        }
    }

    public static abstract class Header
    extends org.jgroups.Header {
        public static final byte REQ = 0;
        public static final byte RSP = 1;
        public byte type;
        public long id;
        public boolean rsp_expected;
        public short corrId;

        public Header() {
        }

        public Header(byte type, long id, boolean rsp_expected, short corr_id) {
            this.type = type;
            this.id = id;
            this.rsp_expected = rsp_expected;
            this.corrId = corr_id;
        }

        @Override
        public String toString() {
            StringBuilder ret = new StringBuilder();
            ret.append("id=" + this.corrId + ", type=");
            ret.append(this.type == 0 ? "REQ" : (this.type == 1 ? "RSP" : "<unknown>"));
            ret.append(", id=" + this.id);
            ret.append(", rsp_expected=" + this.rsp_expected);
            return ret.toString();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.id);
            out.writeBoolean(this.rsp_expected);
            out.writeShort(this.corrId);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.id = in.readLong();
            this.rsp_expected = in.readBoolean();
            this.corrId = in.readShort();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.id);
            out.writeBoolean(this.rsp_expected);
            out.writeShort(this.corrId);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.id = in.readLong();
            this.rsp_expected = in.readBoolean();
            this.corrId = in.readShort();
        }

        @Override
        public int size() {
            return 12;
        }
    }
}

