/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@MBean(description="Failure detection based on simple heartbeat protocol")
@DeprecatedProperty(names={"shun"})
public class FD_ALL
extends Protocol {
    @Property(description="Interval in which a HEARTBEAT is sent to the cluster")
    long interval = 3000L;
    @Property(description="Timeout after which a node P is suspected if neither a heartbeat nor data were received from P")
    long timeout = 5000L;
    @Property(description="Treat messages received from members as heartbeats. Note that this means we're updating a value in a hashmap every time a message is passing up the stack through FD_ALL, which is costly. Default is false")
    boolean msg_counts_as_heartbeat = false;
    @ManagedAttribute(description="Number of heartbeats sent")
    protected int num_heartbeats_sent;
    @ManagedAttribute(description="Number of heartbeats received")
    protected int num_heartbeats_received = 0;
    @ManagedAttribute(description="Number of suspected events received")
    protected int num_suspect_events = 0;
    private final Map<Address, Long> timestamps = new ConcurrentHashMap<Address, Long>();
    private Address local_addr = null;
    private final List<Address> members = Collections.synchronizedList(new ArrayList());
    private TimeScheduler timer = null;
    private ScheduledFuture<?> heartbeat_sender_future = null;
    private ScheduledFuture<?> timeout_checker_future = null;
    private final BoundedList<Address> suspect_history = new BoundedList(20);
    private final Lock lock = new ReentrantLock();

    @ManagedAttribute(description="Member address")
    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute(description="Lists members of a cluster")
    public String getMembers() {
        return this.members.toString();
    }

    public int getHeartbeatsSent() {
        return this.num_heartbeats_sent;
    }

    public int getHeartbeatsReceived() {
        return this.num_heartbeats_received;
    }

    public int getSuspectEventsSent() {
        return this.num_suspect_events;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    @Deprecated
    public static boolean isShun() {
        return false;
    }

    @Deprecated
    public void setShun(boolean flag) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(description="Are heartbeat tasks running")
    public boolean isRunning() {
        this.lock.lock();
        try {
            boolean bl = this.isTimeoutCheckerRunning() && this.isHeartbeatSenderRunning();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @ManagedOperation(description="Prints suspect history")
    public String printSuspectHistory() {
        StringBuilder sb = new StringBuilder();
        for (Address tmp : this.suspect_history) {
            sb.append(new Date()).append(": ").append(tmp).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Prints timestamps")
    public String printTimestamps() {
        return this.printTimeStamps();
    }

    @Override
    public void resetStats() {
        this.num_suspect_events = 0;
        this.num_heartbeats_received = 0;
        this.num_heartbeats_sent = 0;
        this.suspect_history.clear();
    }

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer not set");
        }
    }

    @Override
    public void stop() {
        this.stopHeartbeatSender();
        this.stopTimeoutChecker();
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header hdr = (Header)msg.getHeader(this.id);
                if (this.msg_counts_as_heartbeat) {
                    this.update(msg.getSrc());
                }
                if (hdr == null) break;
                switch (hdr.type) {
                    case 0: {
                        Address sender = msg.getSrc();
                        if (sender.equals(this.local_addr)) break;
                        this.update(sender);
                        ++this.num_heartbeats_received;
                        break;
                    }
                    case 1: {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("[SUSPECT] suspect hdr is " + hdr);
                        }
                        this.down_prot.down(new Event(9, hdr.suspected_mbr));
                        this.up_prot.up(new Event(9, hdr.suspected_mbr));
                    }
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.down_prot.down(evt);
                View v = (View)evt.getArg();
                this.handleViewChange(v);
                return null;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTimeoutChecker() {
        this.lock.lock();
        try {
            if (!this.isTimeoutCheckerRunning()) {
                this.timeout_checker_future = this.timer.scheduleWithFixedDelay(new TimeoutChecker(), this.interval, this.interval, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTimeoutChecker() {
        this.lock.lock();
        try {
            if (this.timeout_checker_future != null) {
                this.timeout_checker_future.cancel(true);
                this.timeout_checker_future = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startHeartbeatSender() {
        this.lock.lock();
        try {
            if (!this.isHeartbeatSenderRunning()) {
                this.heartbeat_sender_future = this.timer.scheduleWithFixedDelay(new HeartbeatSender(), this.interval, this.interval, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopHeartbeatSender() {
        this.lock.lock();
        try {
            if (this.heartbeat_sender_future != null) {
                this.heartbeat_sender_future.cancel(true);
                this.heartbeat_sender_future = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isTimeoutCheckerRunning() {
        return this.timeout_checker_future != null && !this.timeout_checker_future.isDone();
    }

    private boolean isHeartbeatSenderRunning() {
        return this.heartbeat_sender_future != null && !this.heartbeat_sender_future.isDone();
    }

    private void update(Address sender) {
        if (sender != null && !sender.equals(this.local_addr)) {
            this.timestamps.put(sender, System.currentTimeMillis());
        }
    }

    private void handleViewChange(View v) {
        Vector<Address> mbrs = v.getMembers();
        boolean has_at_least_two = mbrs.size() > 1;
        this.members.clear();
        this.members.addAll(mbrs);
        Set<Address> keys = this.timestamps.keySet();
        keys.retainAll(mbrs);
        for (Address member : mbrs) {
            this.update(member);
        }
        if (has_at_least_two) {
            this.startHeartbeatSender();
            this.startTimeoutChecker();
        } else {
            this.stopHeartbeatSender();
            this.stopTimeoutChecker();
        }
    }

    private String printTimeStamps() {
        StringBuilder sb = new StringBuilder();
        long current_time = System.currentTimeMillis();
        for (Map.Entry<Address, Long> entry : this.timestamps.entrySet()) {
            sb.append(entry.getKey()).append(": ");
            sb.append(current_time - entry.getValue()).append(" ms old\n");
        }
        return sb.toString();
    }

    void suspect(Address mbr) {
        Message suspect_msg = new Message();
        suspect_msg.setFlag((byte)1);
        Header hdr = new Header(1, mbr);
        suspect_msg.putHeader(this.id, hdr);
        this.down_prot.down(new Event(1, suspect_msg));
        ++this.num_suspect_events;
        this.suspect_history.add(mbr);
    }

    class TimeoutChecker
    implements Runnable {
        TimeoutChecker() {
        }

        @Override
        public void run() {
            if (FD_ALL.this.log.isTraceEnabled()) {
                FD_ALL.this.log.trace("checking for expired senders, table is:\n" + FD_ALL.this.printTimeStamps());
            }
            long current_time = System.currentTimeMillis();
            Iterator it = FD_ALL.this.timestamps.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Address key = (Address)entry.getKey();
                Long val = (Long)entry.getValue();
                if (val == null) {
                    it.remove();
                    continue;
                }
                long diff = current_time - val;
                if (diff <= FD_ALL.this.timeout) continue;
                if (FD_ALL.this.log.isTraceEnabled()) {
                    FD_ALL.this.log.trace("haven't received a heartbeat from " + key + " for " + diff + " ms, suspecting it");
                }
                FD_ALL.this.suspect(key);
            }
        }
    }

    class HeartbeatSender
    implements Runnable {
        HeartbeatSender() {
        }

        @Override
        public void run() {
            Message heartbeat = new Message();
            heartbeat.setFlag((byte)1);
            Header hdr = new Header(0);
            heartbeat.putHeader(FD_ALL.this.id, hdr);
            FD_ALL.this.down_prot.down(new Event(1, heartbeat));
            if (FD_ALL.this.log.isTraceEnabled()) {
                FD_ALL.this.log.trace(FD_ALL.this.local_addr + " sent heartbeat to cluster");
            }
            ++FD_ALL.this.num_heartbeats_sent;
        }
    }

    public static class Header
    extends org.jgroups.Header {
        public static final byte HEARTBEAT = 0;
        public static final byte SUSPECT = 1;
        byte type = 0;
        Address suspected_mbr = null;

        public Header() {
        }

        public Header(byte type) {
            this.type = type;
        }

        public Header(byte type, Address suspect) {
            this(type);
            this.suspected_mbr = suspect;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 0: {
                    return "heartbeat";
                }
                case 1: {
                    return "SUSPECT (suspected_mbr=" + this.suspected_mbr + ")";
                }
            }
            return "unknown type (" + this.type + ")";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeObject(this.suspected_mbr);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.suspected_mbr = (Address)in.readObject();
        }

        @Override
        public int size() {
            int retval = 1;
            return retval += Util.size(this.suspected_mbr);
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            Util.writeAddress(this.suspected_mbr, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.suspected_mbr = Util.readAddress(in);
        }
    }
}

