/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.util.Promise;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@Experimental
public class FILE_PING
extends Discovery {
    protected static final String SUFFIX = ".node";
    @Property(description="The absolute path of the shared file")
    protected String location = File.separator + "tmp" + File.separator + "jgroups";
    protected File root_dir = null;
    protected FilenameFilter filter;

    @Override
    public void init() throws Exception {
        super.init();
        this.root_dir = new File(this.location);
        if (this.root_dir.exists()) {
            if (!this.root_dir.isDirectory()) {
                throw new IllegalArgumentException("location " + this.root_dir.getPath() + " is not a directory");
            }
        } else {
            this.root_dir.mkdirs();
        }
        if (!this.root_dir.exists()) {
            throw new IllegalArgumentException("location " + this.root_dir.getPath() + " could not be accessed");
        }
        this.filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(FILE_PING.SUFFIX);
            }
        };
    }

    @Override
    public void sendGetMembersRequest(String cluster_name, Promise promise, boolean return_views_only) throws Exception {
        List<PingData> existing_mbrs = this.readAll(cluster_name);
        PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
        List<PhysicalAddress> physical_addrs = Arrays.asList(physical_addr);
        PingData data = new PingData(this.local_addr, null, false, UUID.get(this.local_addr), physical_addrs);
        if (existing_mbrs.isEmpty()) {
            if (promise != null) {
                promise.setResult(null);
            }
        } else {
            for (PingData tmp : existing_mbrs) {
                Collection<PhysicalAddress> dests;
                Collection<PhysicalAddress> collection = dests = tmp != null ? tmp.getPhysicalAddrs() : null;
                if (dests == null) continue;
                for (final PhysicalAddress dest : dests) {
                    if (dest == null || dest.equals(physical_addr)) continue;
                    PingHeader hdr = new PingHeader(1, data, cluster_name);
                    hdr.return_view_only = return_views_only;
                    final Message msg = new Message(dest);
                    msg.setFlag((byte)1);
                    msg.putHeader(this.id, hdr);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("[FIND_INITIAL_MBRS] sending PING request to " + msg.getDest());
                    }
                    this.timer.execute(new Runnable(){

                        @Override
                        public void run() {
                            block2: {
                                try {
                                    FILE_PING.this.down_prot.down(new Event(1, msg));
                                }
                                catch (Exception ex) {
                                    if (!FILE_PING.this.log.isErrorEnabled()) break block2;
                                    FILE_PING.this.log.error("failed sending discovery request to " + dest, ex);
                                }
                            }
                        }
                    });
                }
            }
        }
        this.writeToFile(data, cluster_name);
    }

    protected List<PingData> readAll(String clustername) {
        File[] files;
        ArrayList<PingData> retval = new ArrayList<PingData>();
        File dir = new File(this.root_dir, clustername);
        if (!dir.exists()) {
            dir.mkdir();
        }
        if ((files = dir.listFiles(this.filter)) != null) {
            for (File file : files) {
                retval.add(FILE_PING.readFile(file));
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    protected static PingData readFile(File file) {
        PingData pingData;
        PingData retval = null;
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(file));
            PingData tmp = new PingData();
            tmp.readFrom(in);
            pingData = tmp;
        }
        catch (Exception exception) {
            Util.close(in);
            catch (Throwable throwable) {
                Util.close(in);
                throw throwable;
            }
        }
        Util.close(in);
        return pingData;
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void writeToFile(PingData data, String clustername) {
        DataOutputStream out = null;
        File dir = new File(this.root_dir, clustername);
        if (!dir.exists()) {
            dir.mkdir();
        }
        File file = new File(dir, this.local_addr.toString() + SUFFIX);
        file.deleteOnExit();
        try {
            out = new DataOutputStream(new FileOutputStream(file));
            data.writeTo(out);
        }
        catch (Exception e) {
            Util.close(out);
            catch (Throwable throwable) {
                Util.close(out);
                throw throwable;
            }
        }
        Util.close(out);
    }
}

