/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.Experimental;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

@Experimental
public class MERGEFAST
extends Protocol {
    Address local_addr = null;
    View view;
    boolean is_coord = false;

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg;
                Address dest;
                if (!this.is_coord || this.view == null || (dest = (msg = (Message)evt.getArg()).getDest()) != null && !dest.isMulticastAddress()) break;
                msg.putHeader(this.id, new MergefastHeader(this.view));
                break;
            }
            case 6: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                if (!this.is_coord) break;
                Message msg = (Message)evt.getArg();
                MergefastHeader hdr = (MergefastHeader)msg.getHeader(this.id);
                this.up_prot.up(evt);
                if (hdr != null && this.view != null && !Util.sameViewId(this.view.getViewId(), hdr.view.getViewId())) {
                    HashMap<Address, View> views = new HashMap<Address, View>();
                    views.put(this.local_addr, this.view);
                    views.put(msg.getSrc(), hdr.view);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("detected different views (" + Util.printViews(views.values()) + "), sending up MERGE event");
                    }
                    this.up_prot.up(new Event(14, views));
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    protected void handleViewChange(View v) {
        Vector<Address> mbrs = v.getMembers();
        this.view = v;
        this.is_coord = mbrs != null && !mbrs.isEmpty() && this.local_addr.equals(mbrs.firstElement());
    }

    public static class MergefastHeader
    extends Header {
        private View view = null;

        public MergefastHeader() {
        }

        public MergefastHeader(View view) {
            this.view = view;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.view);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.view = (View)in.readObject();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            Util.writeView(this.view, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.view = Util.readView(in);
        }

        @Override
        public int size() {
            return Util.size(this.view);
        }
    }
}

