/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;

@MBean(description="Simple flow control protocol")
public class SFC
extends Protocol {
    @Property(description="Max number of bytes to send per receiver until an ack must be received to proceed. Default is 2000000 bytes")
    private long max_credits = 2000000L;
    @Property(description="Max time (in milliseconds) to block. Default is 5000 msec")
    private long max_block_time = 5000L;
    private Long MAX_CREDITS;
    private static final Long ZERO_CREDITS = new Long(0L);
    private long curr_credits_available;
    private final Map<Address, Long> received = new HashMap<Address, Long>(12);
    private final Set<Address> pending_requesters = new HashSet<Address>();
    private final Set<Address> pending_creditors = new HashSet<Address>();
    private final Lock lock = new ReentrantLock();
    private final Lock received_lock = new ReentrantLock();
    private final Condition credits_available = this.lock.newCondition();
    private long last_blocked_request = 0L;
    private final List<Address> members = new LinkedList<Address>();
    private boolean running = true;
    private boolean frag_size_received = false;
    long start;
    long stop;
    long num_blockings = 0L;
    long num_bytes_sent = 0L;
    long num_credit_requests_sent = 0L;
    long num_credit_requests_received = 0L;
    long num_replenishments_received = 0L;
    long num_replenishments_sent = 0L;
    long total_block_time = 0L;
    final BoundedList<Long> blockings = new BoundedList(50);

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_bytes_sent = 0L;
        this.num_credit_requests_sent = 0L;
        this.num_replenishments_received = 0L;
        this.total_block_time = 0L;
        this.num_blockings = 0L;
        this.num_credit_requests_received = 0L;
        this.num_replenishments_sent = 0L;
        this.blockings.clear();
    }

    public long getMaxCredits() {
        return this.max_credits;
    }

    @ManagedAttribute
    public long getCredits() {
        return this.curr_credits_available;
    }

    @ManagedAttribute
    public long getBytesSent() {
        return this.num_bytes_sent;
    }

    @ManagedAttribute
    public long getBlockings() {
        return this.num_blockings;
    }

    @ManagedAttribute
    public long getCreditRequestsSent() {
        return this.num_credit_requests_sent;
    }

    @ManagedAttribute
    public long getCreditRequestsReceived() {
        return this.num_credit_requests_received;
    }

    @ManagedAttribute
    public long getReplenishmentsReceived() {
        return this.num_replenishments_received;
    }

    @ManagedAttribute
    public long getReplenishmentsSent() {
        return this.num_replenishments_sent;
    }

    @ManagedAttribute
    public long getTotalBlockingTime() {
        return this.total_block_time;
    }

    @ManagedAttribute
    public double getAverageBlockingTime() {
        return this.num_blockings == 0L ? 0.0 : (double)(this.total_block_time / this.num_blockings);
    }

    @ManagedOperation
    public String printBlockingTimes() {
        return this.blockings.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public String printReceived() {
        this.received_lock.lock();
        try {
            String string = this.received.toString();
            return string;
        }
        finally {
            this.received_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public String printPendingCreditors() {
        this.lock.lock();
        try {
            String string = this.pending_creditors.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public String printPendingRequesters() {
        this.received_lock.lock();
        try {
            String string = this.pending_requesters.toString();
            return string;
        }
        finally {
            this.received_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public void unblock() {
        this.lock.lock();
        try {
            this.curr_credits_available = this.max_credits;
            this.credits_available.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object down(Event evt) {
        block22: {
            switch (evt.getType()) {
                case 1: {
                    msg = (Message)evt.getArg();
                    dest = msg.getDest();
                    if (dest != null && !dest.isMulticastAddress()) {
                        return this.down_prot.down(evt);
                    }
                    send_credit_request = false;
                    this.lock.lock();
                    ** try [egrp 0[TRYBLOCK] [5 : 89->419)] { 
lbl10:
                    // 4 sources

                    while (true) {
                        ** GOTO lbl-1000
                        break;
                    }
lbl12:
                    // 1 sources

                    finally {
                        this.lock.unlock();
                    }
                }
                case 6: {
                    this.handleViewChange((View)evt.getArg());
                    return this.down_prot.down(evt);
                }
                case 9: {
                    this.handleSuspect((Address)evt.getArg());
                    return this.down_prot.down(evt);
                }
                case 56: {
                    map = (Map)evt.getArg();
                    this.handleConfigEvent(map);
                    return this.down_prot.down(evt);
                }
            }
            return this.down_prot.down(evt);
lbl-1000:
            // 3 sources

            {
                while (this.curr_credits_available <= 0L && this.running) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("blocking (current credits=" + this.curr_credits_available + ")");
                    }
                    try {
                        block23: {
                            ++this.num_blockings;
                            rc = this.credits_available.await(this.max_block_time, TimeUnit.MILLISECONDS);
                            if (!rc && (this.curr_credits_available > 0L || !this.running)) break block23;
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("returned from await but credits still unavailable (credits=" + this.curr_credits_available + ")");
                            }
                            if ((now = System.currentTimeMillis()) - this.last_blocked_request < this.max_block_time) ** GOTO lbl10
                            this.last_blocked_request = now;
                            this.lock.unlock();
                            try {
                                this.sendCreditRequest(true);
                                ** GOTO lbl10
                            }
                            finally {
                                this.lock.lock();
                                ** continue;
                            }
                        }
                        this.last_blocked_request = 0L;
                    }
                    catch (InterruptedException e) {}
                }
                len = msg.getLength();
                this.num_bytes_sent += (long)len;
                this.curr_credits_available -= (long)len;
                if (this.curr_credits_available > 0L) break block22;
                this.pending_creditors.clear();
                var6_10 = this.members;
                synchronized (var6_10) {
                    this.pending_creditors.addAll(this.members);
                }
                send_credit_request = true;
            }
        }
        if (send_credit_request == false) return this.down_prot.down(evt);
        if (this.log.isTraceEnabled()) {
            this.log.trace("sending credit request to group");
        }
        this.start = System.nanoTime();
        ret = this.down_prot.down(evt);
        this.sendCreditRequest(false);
        return ret;
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header hdr = (Header)msg.getHeader(this.id);
                Address sender = msg.getSrc();
                if (hdr != null) {
                    switch (hdr.type) {
                        case 1: {
                            this.handleCreditRequest(sender, false);
                            break;
                        }
                        case 3: {
                            this.handleCreditRequest(sender, true);
                            break;
                        }
                        case 2: {
                            this.handleCreditResponse(sender);
                            break;
                        }
                        default: {
                            if (!this.log.isErrorEnabled()) break;
                            this.log.error("unknown header type " + hdr.type);
                        }
                    }
                    return null;
                }
                Address dest = msg.getDest();
                if (dest != null && !dest.isMulticastAddress()) break;
                this.handleMessage(msg, sender);
                break;
            }
            case 6: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 9: {
                this.handleSuspect((Address)evt.getArg());
                break;
            }
            case 56: {
                Map map = (Map)evt.getArg();
                this.handleConfigEvent(map);
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void init() throws Exception {
        this.MAX_CREDITS = new Long(this.max_credits);
        this.curr_credits_available = this.max_credits;
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (!this.frag_size_received) {
            this.log.warn("No fragmentation protocol was found. When flow control (e.g. FC or SFC) is used, we recommend a fragmentation protocol, due to http://jira.jboss.com/jira/browse/JGRP-590");
        }
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        this.running = false;
        this.lock.lock();
        try {
            this.credits_available.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void handleConfigEvent(Map<String, Object> map) {
        Integer frag_size;
        if (map != null && (frag_size = (Integer)map.get("frag_size")) != null) {
            if ((long)frag_size.intValue() > this.max_credits) {
                this.log.warn("The fragmentation size of the fragmentation protocol is " + frag_size + ", which is greater than the max credits. While this is not incorrect, " + "it may lead to long blockings. Frag size should be less than max_credits " + "(http://jira.jboss.com/jira/browse/JGRP-590)");
            }
            this.frag_size_received = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(Message msg, Address sender) {
        int len = msg.getLength();
        boolean send_credit_response = false;
        this.received_lock.lock();
        try {
            Long new_val;
            Long credits = this.received.get(sender);
            if (credits == null) {
                new_val = this.MAX_CREDITS;
                this.received.put(sender, new_val);
            } else {
                new_val = credits + (long)len;
                this.received.put(sender, new_val);
            }
            if (!this.pending_requesters.isEmpty() && this.pending_requesters.contains(sender) && new_val >= this.max_credits) {
                this.pending_requesters.remove(sender);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("removed " + sender + " from credit requesters; sending credits");
                }
                this.received.put(sender, ZERO_CREDITS);
                send_credit_response = true;
            }
        }
        finally {
            this.received_lock.unlock();
        }
        if (send_credit_response) {
            this.sendCreditResponse(sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCreditRequest(Address sender, boolean urgent) {
        boolean send_credit_response = false;
        this.received_lock.lock();
        try {
            ++this.num_credit_requests_received;
            Long bytes = this.received.get(sender);
            if (this.log.isTraceEnabled()) {
                this.log.trace("received credit request from " + sender + " (total received: " + bytes + " bytes");
            }
            if (bytes == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("received credit request from " + sender + ", but sender is not in received hashmap;" + " adding it");
                }
                send_credit_response = true;
            } else if (bytes < this.max_credits && !urgent) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("adding " + sender + " to pending credit requesters");
                }
                this.pending_requesters.add(sender);
            } else {
                send_credit_response = true;
            }
            if (send_credit_response) {
                this.received.put(sender, ZERO_CREDITS);
            }
        }
        finally {
            this.received_lock.unlock();
        }
        if (send_credit_response) {
            this.sendCreditResponse(sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCreditResponse(Address sender) {
        this.lock.lock();
        try {
            ++this.num_replenishments_received;
            if (this.pending_creditors.remove(sender) && this.pending_creditors.isEmpty()) {
                this.curr_credits_available = this.max_credits;
                this.stop = System.nanoTime();
                long diff = (this.stop - this.start) / 1000000L;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("replenished credits to " + this.curr_credits_available + " (total blocking time=" + diff + " ms)");
                }
                this.blockings.add(new Long(diff));
                this.total_block_time += diff;
                this.credits_available.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewChange(View view) {
        Vector<Address> mbrs;
        Vector<Address> vector = mbrs = view != null ? view.getMembers() : null;
        if (mbrs != null) {
            List<Address> list = this.members;
            synchronized (list) {
                this.members.clear();
                this.members.addAll(mbrs);
            }
        }
        this.lock.lock();
        try {
            if (this.pending_creditors.retainAll(this.members) && this.pending_creditors.isEmpty()) {
                this.curr_credits_available = this.max_credits;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("replenished credits to " + this.curr_credits_available);
                }
                this.credits_available.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.received_lock.lock();
        try {
            this.received.keySet().retainAll(this.members);
            for (Address mbr : this.members) {
                if (this.received.containsKey(mbr)) continue;
                this.received.put(mbr, this.MAX_CREDITS);
            }
            this.pending_requesters.retainAll(this.members);
        }
        finally {
            this.received_lock.unlock();
        }
    }

    private void handleSuspect(Address suspected_mbr) {
        this.handleCreditResponse(suspected_mbr);
    }

    private void sendCreditRequest(boolean urgent) {
        Message credit_req = new Message();
        byte type = urgent ? (byte)3 : 1;
        credit_req.putHeader(this.id, new Header(type));
        ++this.num_credit_requests_sent;
        this.down_prot.down(new Event(1, credit_req));
    }

    private void sendCreditResponse(Address dest) {
        Message credit_rsp = new Message(dest);
        credit_rsp.setFlag((byte)1);
        Header hdr = new Header(2);
        credit_rsp.putHeader(this.id, hdr);
        if (this.log.isTraceEnabled()) {
            this.log.trace("sending credit response to " + dest);
        }
        ++this.num_replenishments_sent;
        this.down_prot.down(new Event(1, credit_rsp));
    }

    public static class Header
    extends org.jgroups.Header {
        public static final byte CREDIT_REQUEST = 1;
        public static final byte REPLENISH = 2;
        public static final byte URGENT_CREDIT_REQUEST = 3;
        byte type = 1;

        public Header() {
        }

        public Header(byte type) {
            this.type = type;
        }

        @Override
        public int size() {
            return 1;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 2: {
                    return "REPLENISH";
                }
                case 1: {
                    return "CREDIT_REQUEST";
                }
                case 3: {
                    return "URGENT_CREDIT_REQUEST";
                }
            }
            return "<invalid type>";
        }
    }
}

