/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Membership;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.logging.Log;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.MergeData;
import org.jgroups.util.Digest;
import org.jgroups.util.MergeId;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.ResponseCollector;
import org.jgroups.util.Util;

public class Merger {
    private final GMS gms;
    private final Log log;
    private final MergeTask merge_task = new MergeTask();
    private final ResponseCollector<MergeData> merge_rsps = new ResponseCollector();
    private final ResponseCollector<Digest> digest_collector = new ResponseCollector();
    private final Lock merge_lock = new ReentrantLock();
    private MergeId merge_id = null;
    private Future<?> merge_canceller_future = null;
    private final Lock merge_canceller_lock = new ReentrantLock();

    public Merger(GMS gms, Log log) {
        this.gms = gms;
        this.log = log;
    }

    public void merge(Map<Address, View> views) {
        if (this.isMergeInProgress()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.gms.local_addr + ": merge is already running (merge_id=" + this.merge_id + ")");
            }
            return;
        }
        Collection<Address> coords = Util.determineMergeCoords(views);
        Collection<Address> merge_participants = Util.determineMergeParticipants(views);
        Membership tmp = new Membership(coords);
        tmp.sort();
        Address merge_leader = tmp.elementAt(0);
        if (this.log.isDebugEnabled()) {
            this.log.debug("determining merge leader from " + merge_participants);
        }
        if (merge_leader.equals(this.gms.local_addr)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("I (" + this.gms.local_addr + ") will be the leader. Starting the merge task for " + merge_participants);
            }
            this.merge_task.start(views);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("I (" + this.gms.local_addr + ") am not the merge leader, " + "waiting for merge leader (" + merge_leader + ") to initiate merge");
        }
    }

    public void handleMergeRequest(Address sender, MergeId merge_id, Collection<? extends Address> mbrs) {
        View view;
        boolean bl;
        boolean success;
        boolean bl2 = success = this.matchMergeId(merge_id) || this.setMergeId(null, merge_id);
        if (!success) {
            if (this.log.isWarnEnabled()) {
                this.log.warn(this.gms.local_addr + ": merge is already in progress");
            }
            this.sendMergeRejectedResponse(sender, merge_id);
            return;
        }
        this.gms.getViewHandler().suspend(merge_id);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.gms.local_addr + ": got merge request from " + sender + ", merge_id=" + merge_id + ", mbrs=" + mbrs);
        }
        LinkedList<Address> members = new LinkedList<Address>();
        if (mbrs != null) {
            for (Address address : mbrs) {
                if (members.contains(address)) continue;
                members.add(address);
            }
        }
        if (!(bl = this.gms.startFlush(view = new View(this.gms.view_id.copy(), new Vector<Address>(members))))) {
            this.sendMergeRejectedResponse(sender, merge_id);
            if (this.log.isWarnEnabled()) {
                this.log.warn(this.gms.local_addr + ": flush failed; sending merge rejected message to " + sender + ", merge_id=" + merge_id);
            }
            this.cancelMerge(merge_id);
            return;
        }
        Digest digest = this.fetchDigestsFromAllMembersInSubPartition(members);
        if (digest.size() == 0) {
            this.log.error("failed fetching digests from subpartition members; dropping merge response");
            return;
        }
        this.sendMergeResponse(sender, view, digest, merge_id);
    }

    public void handleMergeResponse(MergeData data, MergeId merge_id) {
        if (!this.matchMergeId(merge_id)) {
            if (this.log.isErrorEnabled()) {
                this.log.error(this.gms.local_addr + ": this.merge_id (" + this.merge_id + ") is different from merge_id (" + merge_id + ')');
            }
            return;
        }
        this.merge_rsps.add(data.getSender(), data);
    }

    public void handleMergeView(MergeData data, MergeId merge_id) {
        if (!this.matchMergeId(merge_id)) {
            if (this.log.isErrorEnabled()) {
                this.log.error("merge_ids don't match (or are null); merge view discarded");
            }
            return;
        }
        Vector<Address> newViewMembers = new Vector<Address>(data.view.getMembers());
        newViewMembers.removeAll(this.gms.members.getMembers());
        this.gms.castViewChangeWithDest(data.view, data.digest, null, newViewMembers);
        if (this.gms.flushProtocolInStack) {
            Message ack = new Message(data.getSender(), null, null);
            ack.setFlag((byte)1);
            GMS.GmsHeader ack_hdr = new GMS.GmsHeader(12);
            ack.putHeader(this.gms.getId(), ack_hdr);
            this.gms.getDownProtocol().down(new Event(1, ack));
        }
        this.cancelMerge(merge_id);
    }

    public void handleMergeCancelled(MergeId merge_id) {
        try {
            this.gms.stopFlush();
        }
        catch (Throwable t) {
            this.log.error("stop flush failed", t);
        }
        if (this.matchMergeId(merge_id)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.gms.local_addr + ": merge " + merge_id + " is cancelled");
            }
            this.cancelMerge(merge_id);
        }
    }

    public void handleDigestResponse(Address sender, Digest digest) {
        this.digest_collector.add(sender, digest);
    }

    private void sendMergeResponse(Address sender, View view, Digest digest, MergeId merge_id) {
        Message msg = new Message(sender, null, null);
        msg.setFlag((byte)1);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.merge_id = merge_id;
        hdr.view = view;
        hdr.my_digest = digest;
        msg.putHeader(this.gms.getId(), hdr);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.gms.local_addr + ": sending merge response=" + hdr);
        }
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    private void sendMergeView(Collection<Address> coords, MergeData combined_merge_data, MergeId merge_id) {
        if (coords == null || combined_merge_data == null) {
            return;
        }
        View view = combined_merge_data.view;
        Digest digest = combined_merge_data.digest;
        if (view == null || digest == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("view or digest is null, cannot send consolidated merge view/digest");
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.gms.local_addr + ": sending merge view " + view.getVid() + " to coordinators " + coords);
        }
        this.gms.merge_ack_collector.reset(coords);
        int size = this.gms.merge_ack_collector.size();
        long timeout = this.gms.view_ack_collection_timeout;
        long start = System.currentTimeMillis();
        for (Address coord : coords) {
            Message msg = new Message(coord, null, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(8);
            hdr.view = view;
            hdr.my_digest = digest;
            hdr.merge_id = merge_id;
            msg.putHeader(this.gms.getId(), hdr);
            this.gms.getDownProtocol().down(new Event(1, msg));
        }
        if (this.gms.flushProtocolInStack) {
            try {
                this.gms.merge_ack_collector.waitForAllAcks(timeout);
                long stop = System.currentTimeMillis();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("received all ACKs (" + size + ") for merge view " + view + " in " + (stop - start) + "ms");
                }
            }
            catch (TimeoutException e) {
                this.log.warn(this.gms.local_addr + ": failed to collect all ACKs for merge (" + size + ") for view " + view + " after " + timeout + "ms, missing ACKs from " + this.gms.merge_ack_collector.printMissing());
            }
        }
    }

    protected void sendMergeRejectedResponse(Address sender, MergeId merge_id) {
        Message msg = new Message(sender, null, null);
        msg.setFlag((byte)1);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.merge_rejected = true;
        hdr.merge_id = merge_id;
        msg.putHeader(this.gms.getId(), hdr);
        if (this.log.isDebugEnabled()) {
            this.log.debug("merge response=" + hdr);
        }
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    private void sendMergeCancelledMessage(Collection<Address> coords, MergeId merge_id) {
        if (coords == null || merge_id == null) {
            return;
        }
        for (Address coord : coords) {
            Message msg = new Message(coord, null, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(9);
            hdr.merge_id = merge_id;
            msg.putHeader(this.gms.getId(), hdr);
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.gms.local_addr + ": sending cancel merge to " + coord);
            }
            this.gms.getDownProtocol().down(new Event(1, msg));
        }
    }

    private Digest fetchDigestsFromAllMembersInSubPartition(List<Address> current_mbrs) {
        if (current_mbrs == null) {
            return null;
        }
        GMS.GmsHeader hdr = new GMS.GmsHeader(13);
        Message get_digest_req = new Message();
        get_digest_req.setFlag((byte)1);
        get_digest_req.putHeader(this.gms.getId(), hdr);
        long max_wait_time = this.gms.merge_timeout > 0L ? this.gms.merge_timeout / 2L : 2000L;
        this.digest_collector.reset(current_mbrs);
        Digest digest = (Digest)this.gms.getDownProtocol().down(Event.GET_DIGEST_EVT);
        this.digest_collector.add(this.gms.local_addr, digest);
        this.gms.getDownProtocol().down(new Event(1, get_digest_req));
        this.digest_collector.waitForAllResponses(max_wait_time);
        if (this.log.isDebugEnabled()) {
            if (this.digest_collector.hasAllResponses()) {
                this.log.debug(this.gms.local_addr + ": fetched all digests for " + current_mbrs);
            } else {
                this.log.debug(this.gms.local_addr + ": fetched incomplete digests (after timeout of " + max_wait_time + ") ms for " + current_mbrs);
            }
        }
        HashMap<Address, Digest> responses = new HashMap<Address, Digest>(this.digest_collector.getResults());
        MutableDigest retval = new MutableDigest(responses.size());
        for (Digest dig : responses.values()) {
            if (dig == null) continue;
            retval.add(dig);
        }
        return retval;
    }

    void fixDigests() {
        Digest digest = this.fetchDigestsFromAllMembersInSubPartition(this.gms.view.getMembers());
        Message msg = new Message();
        GMS.GmsHeader hdr = new GMS.GmsHeader(15);
        hdr.my_digest = digest;
        msg.putHeader(this.gms.getId(), hdr);
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    void stop() {
        this.merge_task.stop();
    }

    void cancelMerge(MergeId id) {
        if (this.setMergeId(id, null)) {
            this.merge_task.stop();
            this.merge_rsps.reset();
            this.gms.getViewHandler().resume(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setMergeId(MergeId expected, MergeId new_value) {
        this.merge_lock.lock();
        try {
            boolean match = Util.match(this.merge_id, expected);
            if (match) {
                this.merge_id = new_value;
                this.stopMergeCanceller();
                if (this.merge_id != null) {
                    this.startMergeCanceller();
                }
            }
            boolean bl = match;
            return bl;
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergeId getMergeId() {
        this.merge_lock.lock();
        try {
            MergeId mergeId = this.merge_id;
            return mergeId;
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMergeInProgress() {
        this.merge_lock.lock();
        try {
            boolean bl = this.merge_id != null;
            return bl;
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchMergeId(MergeId id) {
        this.merge_lock.lock();
        try {
            boolean bl = Util.match(this.merge_id, id);
            return bl;
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMergeCanceller() {
        this.merge_canceller_lock.lock();
        try {
            if (this.merge_canceller_future == null || this.merge_canceller_future.isDone()) {
                MergeCanceller task = new MergeCanceller(this.merge_id);
                this.merge_canceller_future = this.gms.timer.schedule(task, (long)((double)this.gms.merge_timeout * 1.5), TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.merge_canceller_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMergeCanceller() {
        this.merge_canceller_lock.lock();
        try {
            if (this.merge_canceller_future != null) {
                this.merge_canceller_future.cancel(true);
                this.merge_canceller_future = null;
            }
        }
        finally {
            this.merge_canceller_lock.unlock();
        }
    }

    private class MergeCanceller
    implements Runnable {
        private final MergeId my_merge_id;

        MergeCanceller(MergeId my_merge_id) {
            this.my_merge_id = my_merge_id;
        }

        @Override
        public void run() {
            Merger.this.cancelMerge(this.my_merge_id);
        }
    }

    class MergeTask
    implements Runnable {
        private Thread thread = null;
        private final ConcurrentMap<Address, Collection<Address>> coords = new ConcurrentHashMap<Address, Collection<Address>>();

        MergeTask() {
        }

        public synchronized void start(Map<Address, View> views) {
            if (this.thread == null || this.thread.isAlive()) {
                this.coords.clear();
                Collection<Address> coordinators = Util.determineMergeCoords(views);
                for (Address coord : coordinators) {
                    View view = views.get(coord);
                    if (view == null) continue;
                    this.coords.put(coord, new ArrayList<Address>(view.getMembers()));
                }
                Collection<Address> merge_participants = Util.determineMergeParticipants(views);
                merge_participants.removeAll(coordinators);
                for (Address merge_participant : merge_participants) {
                    this.coords.putIfAbsent(merge_participant, Arrays.asList(merge_participant));
                }
                this.thread = Merger.this.gms.getThreadFactory().newThread(this, "MergeTask");
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }

        public synchronized void stop() {
            Thread tmp = this.thread;
            if (this.thread != null && this.thread.isAlive()) {
                tmp.interrupt();
            }
            this.thread = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MergeId new_merge_id = MergeId.create(((Merger)Merger.this).gms.local_addr);
            ArrayList coordsCopy = null;
            try {
                boolean success = Merger.this.setMergeId(null, new_merge_id);
                if (!success) {
                    Merger.this.log.warn("failed to set my own merge_id (" + Merger.this.merge_id + ") to " + new_merge_id);
                    return;
                }
                coordsCopy = new ArrayList(this.coords.keySet());
                success = this.getMergeDataFromSubgroupCoordinators(this.coords, new_merge_id, ((Merger)Merger.this).gms.merge_timeout);
                if (!success) {
                    throw new Exception("merge leader did not get data from all partition coordinators " + this.coords.keySet());
                }
                this.removeRejectedMergeRequests(this.coords.keySet());
                if (Merger.this.merge_rsps.size() == 0) {
                    throw new Exception("did not get any merge responses from partition coordinators");
                }
                if (!this.coords.keySet().contains(((Merger)Merger.this).gms.local_addr)) {
                    throw new Exception("merge leader rejected merge request");
                }
                Vector<MergeData> merge_data = new Vector<MergeData>(Merger.this.merge_rsps.getResults().values());
                MergeData combined_merge_data = this.consolidateMergeData(merge_data);
                if (combined_merge_data == null) {
                    throw new Exception("could not consolidate merge");
                }
                Merger.this.sendMergeView(this.coords.keySet(), combined_merge_data, new_merge_id);
            }
            catch (Throwable ex) {
                if (Merger.this.log.isWarnEnabled()) {
                    Merger.this.log.warn(((Merger)Merger.this).gms.local_addr + ": " + ex.getLocalizedMessage() + ", merge is cancelled");
                }
                Merger.this.sendMergeCancelledMessage(coordsCopy, new_merge_id);
            }
            finally {
                Merger.this.gms.getViewHandler().resume(new_merge_id);
                Merger.this.stopMergeCanceller();
                Merger.this.gms.stopFlush();
                if (Merger.this.log.isDebugEnabled()) {
                    Merger.this.log.debug(((Merger)Merger.this).gms.local_addr + ": merge leader completed merge task");
                }
                this.thread = null;
            }
        }

        private boolean getMergeDataFromSubgroupCoordinators(Map<Address, Collection<Address>> coords, MergeId new_merge_id, long timeout) {
            long start = System.currentTimeMillis();
            Merger.this.merge_rsps.reset(coords.keySet());
            if (Merger.this.log.isDebugEnabled()) {
                Merger.this.log.debug(((Merger)Merger.this).gms.local_addr + ": sending MERGE_REQ to " + coords.keySet());
            }
            for (Map.Entry<Address, Collection<Address>> entry : coords.entrySet()) {
                Address coord = entry.getKey();
                Collection<Address> mbrs = entry.getValue();
                Message msg = new Message(coord, null, null);
                msg.setFlag((byte)1);
                GMS.GmsHeader hdr = new GMS.GmsHeader(6, mbrs);
                hdr.mbr = ((Merger)Merger.this).gms.local_addr;
                hdr.merge_id = new_merge_id;
                msg.putHeader(Merger.this.gms.getId(), hdr);
                Merger.this.gms.getDownProtocol().down(new Event(1, msg));
            }
            Merger.this.merge_rsps.waitForAllResponses(timeout);
            boolean gotAllResponses = Merger.this.merge_rsps.hasAllResponses();
            long stop = System.currentTimeMillis();
            if (Merger.this.log.isDebugEnabled()) {
                Merger.this.log.debug(((Merger)Merger.this).gms.local_addr + ": collected " + Merger.this.merge_rsps.size() + " merge response(s) in " + (stop - start) + " ms");
            }
            return gotAllResponses;
        }

        private void removeRejectedMergeRequests(Collection<Address> coords) {
            for (Map.Entry entry : Merger.this.merge_rsps.getResults().entrySet()) {
                Address member = entry.getKey();
                MergeData data = (MergeData)entry.getValue();
                if (!data.merge_rejected) continue;
                if (data.getSender() != null) {
                    coords.remove(data.getSender());
                }
                Merger.this.merge_rsps.remove(member);
            }
        }

        private MergeData consolidateMergeData(Vector<MergeData> merge_rsps) {
            Address new_coord;
            long logical_time = 0L;
            Membership new_mbrs = new Membership();
            Vector<View> subgroups = new Vector<View>(11);
            for (MergeData tmp_data : merge_rsps) {
                View tmp_view = tmp_data.getView();
                if (tmp_view == null) continue;
                ViewId tmp_vid = tmp_view.getVid();
                if (tmp_vid != null) {
                    logical_time = Math.max(logical_time, tmp_vid.getId());
                }
                new_mbrs.add(tmp_view.getMembers());
                subgroups.addElement((View)tmp_view.clone());
            }
            new_mbrs.sort();
            Address address = new_coord = new_mbrs.size() > 0 ? new_mbrs.elementAt(0) : null;
            if (new_coord == null) {
                if (Merger.this.log.isErrorEnabled()) {
                    Merger.this.log.error("new_coord == null");
                }
                return null;
            }
            ViewId new_vid = new ViewId(new_coord, logical_time + 1L);
            MergeView new_view = new MergeView(new_vid, new_mbrs.getMembers(), subgroups);
            Digest new_digest = this.consolidateDigests(merge_rsps, new_mbrs.size());
            if (new_digest == null) {
                if (Merger.this.log.isErrorEnabled()) {
                    Merger.this.log.error("Merge leader " + ((Merger)Merger.this).gms.local_addr + ": could not consolidate digest for merge");
                }
                return null;
            }
            if (Merger.this.log.isDebugEnabled()) {
                Merger.this.log.debug("Merge leader " + ((Merger)Merger.this).gms.local_addr + ": consolidated view=" + new_view + "\nconsolidated digest=" + new_digest);
            }
            return new MergeData(((Merger)Merger.this).gms.local_addr, new_view, new_digest);
        }

        private Digest consolidateDigests(Vector<MergeData> merge_rsps, int num_mbrs) {
            MutableDigest retval = new MutableDigest(num_mbrs);
            for (MergeData data : merge_rsps) {
                Digest tmp_digest = data.getDigest();
                if (tmp_digest == null) {
                    if (!Merger.this.log.isErrorEnabled()) continue;
                    Merger.this.log.error("tmp_digest == null; skipping");
                    continue;
                }
                retval.merge(tmp_digest);
            }
            return retval.copy();
        }
    }
}

