/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.deployers;

import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.security.plugins.JaasSecurityManagerServiceMBean;
import org.jboss.web.deployers.AbstractWarDeployer;
import org.jboss.web.deployers.AbstractWarDeployment;
import org.jboss.web.tomcat.service.deployers.DeployerConfig;
import org.jboss.web.tomcat.service.deployers.TomcatDeployerMBean;
import org.jboss.xb.binding.UnmarshallerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatDeployer
extends AbstractWarDeployer
implements TomcatDeployerMBean {
    public static final ObjectName TOMCAT_SERVICE_NAME = ObjectNameFactory.create((String)"jboss.web:service=WebServer");
    public static final String NAME = "TomcatDeployer";
    private String contextClassName = "org.apache.catalina.core.StandardContext";
    private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
    private Properties authenticators = null;
    private String catalinaDomain = "Catalina";
    private boolean deleteWorkDirOnContextDestroy = true;
    private Set<String> dynamicClassloaders;
    private String httpHeaderForSSOAuth = null;
    private String sessionCookieForSSOAuth = null;
    private String serverConfigFile = "server.xml";
    private String subjectAttributeName = null;
    private boolean allowSelfPrivilegedWebApps = false;
    private JaasSecurityManagerServiceMBean secMgrService;
    private String deploymentClass = null;
    private ClassLoader serviceClassLoader = null;
    private String securityManagement;
    private String securityContextClassName;
    private boolean runtimeLifecycleCoupled = false;
    private String policyRegistrationName;
    private String tldJars = null;

    public String getName() {
        return NAME;
    }

    @Deprecated
    public boolean getOverrideDistributableManager() {
        return false;
    }

    @Deprecated
    public void setOverrideDistributableManager(boolean override) {
        if (override) {
            this.log.info((Object)"Property overrideDistributableManager is deprecated, ignoring setter invocation");
        }
    }

    public ClassLoader getServiceClassLoader() {
        return this.serviceClassLoader;
    }

    public void setServiceClassLoader(ClassLoader serviceClassLoader) {
        this.serviceClassLoader = serviceClassLoader;
    }

    @Override
    public String getDomain() {
        return this.catalinaDomain;
    }

    public Properties getAuthenticators() {
        return this.authenticators;
    }

    public void setAuthenticators(Properties prop) {
        this.authenticators = prop;
        this.log.debug((Object)("Passed set of authenticators=" + prop));
    }

    public Set<String> getDynamicClassloaders() {
        return this.dynamicClassloaders;
    }

    public void setDynamicClassloaders(Set<String> dynamicClassloaders) {
        this.dynamicClassloaders = dynamicClassloaders;
    }

    public String getTldJars() {
        return this.tldJars;
    }

    public void setTldJars(String tldJars) {
        this.tldJars = tldJars;
    }

    @Override
    public void setDomain(String catalinaDomain) {
        this.catalinaDomain = catalinaDomain;
    }

    @Override
    public void setContextMBeanCode(String className) {
        this.contextClassName = className;
    }

    @Override
    public String getContextMBeanCode() {
        return this.contextClassName;
    }

    @Override
    public boolean getDeleteWorkDirOnContextDestroy() {
        return this.deleteWorkDirOnContextDestroy;
    }

    @Override
    public void setDeleteWorkDirOnContextDestroy(boolean deleteFlag) {
        this.deleteWorkDirOnContextDestroy = deleteFlag;
    }

    @Override
    public String getHttpHeaderForSSOAuth() {
        return this.httpHeaderForSSOAuth;
    }

    @Override
    public void setHttpHeaderForSSOAuth(String httpHeader) {
        this.httpHeaderForSSOAuth = httpHeader;
    }

    @Override
    public String getSessionCookieForSSOAuth() {
        return this.sessionCookieForSSOAuth;
    }

    @Override
    public void setSessionCookieForSSOAuth(String sessionC) {
        this.sessionCookieForSSOAuth = sessionC;
    }

    @Override
    public String getConfigFile() {
        return this.serverConfigFile;
    }

    @Override
    public void setConfigFile(String configFile) {
        this.serverConfigFile = configFile;
    }

    @Override
    public String getSubjectAttributeName() {
        return this.subjectAttributeName;
    }

    @Override
    public void setSubjectAttributeName(String name) {
        this.subjectAttributeName = name;
    }

    @Override
    public boolean isAllowSelfPrivilegedWebApps() {
        return this.allowSelfPrivilegedWebApps;
    }

    @Override
    public void setAllowSelfPrivilegedWebApps(boolean allowSelfPrivilegedWebApps) {
        this.allowSelfPrivilegedWebApps = allowSelfPrivilegedWebApps;
    }

    @Override
    public void setSecurityManagerService(JaasSecurityManagerServiceMBean mgr) {
        this.secMgrService = mgr;
    }

    public void setPolicyRegistrationName(String policyRegistration) {
        this.policyRegistrationName = policyRegistration;
    }

    public void setSecurityManagementName(String securityManagement) {
        this.securityManagement = securityManagement;
    }

    public void setSecurityContextClassName(String securityContextClassName) {
        this.securityContextClassName = securityContextClassName;
    }

    public String getDeploymentClass() {
        return this.deploymentClass;
    }

    public void setDeploymentClass(String deploymentClass) {
        this.deploymentClass = deploymentClass;
    }

    public boolean isRuntimeLifecycleCoupled() {
        return this.runtimeLifecycleCoupled;
    }

    public void setRuntimeLifecycleCoupled(boolean coupled) {
        this.runtimeLifecycleCoupled = coupled;
    }

    public AbstractWarDeployment getDeployment(DeploymentUnit unit, JBossWebMetaData metaData) throws Exception {
        String className = this.deploymentClass == null ? "org.jboss.web.tomcat.service.deployers.TomcatDeployment" : this.deploymentClass;
        AbstractWarDeployment deployment = (AbstractWarDeployment)this.getClass().getClassLoader().loadClass(className).newInstance();
        DeployerConfig config = new DeployerConfig();
        config.setDefaultSecurityDomain(this.defaultSecurityDomain);
        config.setSubjectAttributeName(this.subjectAttributeName);
        config.setServiceClassLoader(this.getServiceClassLoader() == null ? this.getClass().getClassLoader() : this.getServiceClassLoader());
        config.setJava2ClassLoadingCompliance(this.java2ClassLoadingCompliance);
        config.setUnpackWars(this.unpackWars);
        config.setLenientEjbLink(this.lenientEjbLink);
        config.setCatalinaDomain(this.catalinaDomain);
        config.setContextClassName(this.contextClassName);
        config.setServiceName(null);
        config.setSubjectAttributeName(this.subjectAttributeName);
        config.setAllowSelfPrivilegedWebApps(this.allowSelfPrivilegedWebApps);
        config.setSecurityManagerService(this.secMgrService);
        config.setDeleteWorkDirs(this.deleteWorkDirOnContextDestroy);
        config.setDynamicClassloaders(this.dynamicClassloaders);
        config.setSecurityContextClassName(this.securityContextClassName);
        deployment.setSecurityManagementName(this.securityManagement);
        deployment.setPolicyRegistrationName(this.policyRegistrationName);
        ArrayList<String> depends = metaData.getDepends();
        if (depends == null) {
            depends = new ArrayList<String>();
        }
        depends.add(TOMCAT_SERVICE_NAME.getCanonicalName());
        metaData.setDepends(depends);
        deployment.setServer(super.getServer());
        deployment.init((Object)config);
        return deployment;
    }

    public void create() throws Exception {
    }

    public void destroy() throws Exception {
    }
}

