/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.core.management;

import org.hornetq.api.core.management.Operation;
import org.hornetq.api.core.management.Parameter;

public interface HornetQServerControl {
    public String getBackupConnectorName();

    public String getVersion();

    public int getConnectionCount();

    public boolean isStarted();

    public String[] getInterceptorClassNames();

    public boolean isClustered();

    public int getScheduledThreadPoolMaxSize();

    public int getThreadPoolMaxSize();

    public long getSecurityInvalidationInterval();

    public boolean isSecurityEnabled();

    public String getBindingsDirectory();

    public String getJournalDirectory();

    public String getJournalType();

    public boolean isJournalSyncTransactional();

    public boolean isJournalSyncNonTransactional();

    public int getJournalFileSize();

    public int getJournalMinFiles();

    public int getJournalMaxIO();

    public int getJournalBufferSize();

    public int getJournalBufferTimeout();

    public int getJournalCompactMinFiles();

    public int getJournalCompactPercentage();

    public boolean isPersistenceEnabled();

    public boolean isCreateBindingsDir();

    public boolean isCreateJournalDir();

    public boolean isMessageCounterEnabled();

    public int getMessageCounterMaxDayCount();

    public void setMessageCounterMaxDayCount(int var1) throws Exception;

    public long getMessageCounterSamplePeriod();

    public void setMessageCounterSamplePeriod(long var1) throws Exception;

    public boolean isBackup();

    public boolean isSharedStore();

    public String getPagingDirectory();

    public boolean isPersistDeliveryCountBeforeDelivery();

    public long getConnectionTTLOverride();

    public String getManagementAddress();

    public String getManagementNotificationAddress();

    public int getIDCacheSize();

    public boolean isPersistIDCache();

    public String getLargeMessagesDirectory();

    public boolean isWildcardRoutingEnabled();

    public long getTransactionTimeout();

    public long getTransactionTimeoutScanPeriod();

    public long getMessageExpiryScanPeriod();

    public long getMessageExpiryThreadPriority();

    public boolean isAsyncConnectionExecutionEnabled();

    public Object[] getConnectors() throws Exception;

    public String getConnectorsAsJSON() throws Exception;

    public String[] getAddressNames();

    public String[] getQueueNames();

    @Operation(desc="Create a queue with the specified address", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2) throws Exception;

    @Operation(desc="Create a queue", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="filter", desc="Filter of the queue") String var3, @Parameter(name="durable", desc="Is the queue durable?") boolean var4) throws Exception;

    @Operation(desc="Create a queue with the specified address, name and durability", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="durable", desc="Is the queue durable?") boolean var3) throws Exception;

    @Operation(desc="Deploy a queue", impact=1)
    public void deployQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="filter", desc="Filter of the queue") String var3) throws Exception;

    @Operation(desc="Deploy a queue", impact=1)
    public void deployQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="filter", desc="Filter of the queue") String var3, @Parameter(name="durable", desc="Is the queue durable?") boolean var4) throws Exception;

    @Operation(desc="Destroy a queue", impact=1)
    public void destroyQueue(@Parameter(name="name", desc="Name of the queue to destroy") String var1) throws Exception;

    @Operation(desc="Enable message counters", impact=1)
    public void enableMessageCounters() throws Exception;

    @Operation(desc="Disable message counters", impact=1)
    public void disableMessageCounters() throws Exception;

    @Operation(desc="Reset all message counters", impact=1)
    public void resetAllMessageCounters() throws Exception;

    @Operation(desc="Reset all message counters history", impact=1)
    public void resetAllMessageCounterHistories() throws Exception;

    @Operation(desc="List all the prepared transaction, sorted by date, oldest first")
    public String[] listPreparedTransactions() throws Exception;

    public String[] listHeuristicCommittedTransactions() throws Exception;

    public String[] listHeuristicRolledBackTransactions() throws Exception;

    @Operation(desc="Commit a prepared transaction")
    public boolean commitPreparedTransaction(@Parameter(desc="the Base64 representation of a transaction", name="transactionAsBase64") String var1) throws Exception;

    @Operation(desc="Rollback a prepared transaction")
    public boolean rollbackPreparedTransaction(@Parameter(desc="the Base64 representation of a transaction", name="transactionAsBase64") String var1) throws Exception;

    @Operation(desc="List the client addresses", impact=0)
    public String[] listRemoteAddresses() throws Exception;

    @Operation(desc="List the client addresses which match the given IP Address", impact=0)
    public String[] listRemoteAddresses(@Parameter(desc="an IP address", name="ipAddress") String var1) throws Exception;

    @Operation(desc="Closes all the connections for the given IP Address", impact=0)
    public boolean closeConnectionsForAddress(@Parameter(desc="an IP address", name="ipAddress") String var1) throws Exception;

    @Operation(desc="List all the connection IDs", impact=0)
    public String[] listConnectionIDs() throws Exception;

    @Operation(desc="List the sessions for the given connectionID", impact=0)
    public String[] listSessions(@Parameter(desc="a connection ID", name="connectionID") String var1) throws Exception;

    public void sendQueueInfoToQueue(String var1, String var2) throws Exception;

    @Operation(desc="Add security settings for addresses matching the addressMatch", impact=1)
    public void addSecuritySettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="a comma-separated list of roles allowed to send messages", name="send") String var2, @Parameter(desc="a comma-separated list of roles allowed to consume messages", name="consume") String var3, @Parameter(desc="a comma-separated list of roles allowed to create durable queues", name="createDurableQueueRoles") String var4, @Parameter(desc="a comma-separated list of roles allowed to delete durable queues", name="deleteDurableQueueRoles") String var5, @Parameter(desc="a comma-separated list of roles allowed to create non durable queues", name="createNonDurableQueueRoles") String var6, @Parameter(desc="a comma-separated list of roles allowed to delete non durable queues", name="deleteNonDurableQueueRoles") String var7, @Parameter(desc="a comma-separated list of roles allowed to send management messages messages", name="manage") String var8) throws Exception;

    @Operation(desc="Remove security settings for an address", impact=1)
    public void removeSecuritySettings(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    @Operation(desc="get roles for a specific address match", impact=0)
    public Object[] getRoles(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    @Operation(desc="get roles (as a JSON string) for a specific address match", impact=0)
    public String getRolesAsJSON(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    @Operation(desc="Add address settings for addresses matching the addressMatch", impact=1)
    public void addAddressSettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="the dead letter address setting", name="DLA") String var2, @Parameter(desc="the expiry address setting", name="expiryAddress") String var3, @Parameter(desc="are any queues created for this address a last value queue", name="lastValueQueue") boolean var4, @Parameter(desc="the delivery attempts", name="deliveryAttempts") int var5, @Parameter(desc="the max size in bytes", name="maxSizeBytes") long var6, @Parameter(desc="the page size in bytes", name="pageSizeBytes") int var8, @Parameter(desc="the redelivery delay", name="redeliveryDelay") long var9, @Parameter(desc="the redistribution delay", name="redistributionDelay") long var11, @Parameter(desc="do we send to the DLA when there is no where to route the message", name="sendToDLAOnNoRoute") boolean var13, @Parameter(desc="the ploicy to use when the address is full", name="addressFullMessagePolicy") String var14) throws Exception;

    public void removeAddressSettings(String var1) throws Exception;

    @Operation(desc="returns the address settings as a JSON string for an address match", impact=0)
    public String getAddressSettingsAsJSON(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;
}

