/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.io.Serializable;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.loadbalance.ConnectionLoadBalancingPolicy;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.FailoverManager;
import org.hornetq.core.client.impl.FailoverManagerImpl;
import org.hornetq.core.cluster.DiscoveryEntry;
import org.hornetq.core.cluster.DiscoveryGroup;
import org.hornetq.core.cluster.DiscoveryListener;
import org.hornetq.core.cluster.impl.DiscoveryGroupImpl;
import org.hornetq.core.logging.Logger;
import org.hornetq.utils.HornetQThreadFactory;
import org.hornetq.utils.UUIDGenerator;

public class ClientSessionFactoryImpl
implements ClientSessionFactoryInternal,
DiscoveryListener,
Serializable {
    private static final long serialVersionUID = 2512460695662741413L;
    private static final Logger log = Logger.getLogger(ClientSessionFactoryImpl.class);
    private final Map<Pair<TransportConfiguration, TransportConfiguration>, FailoverManager> failoverManagerMap = new LinkedHashMap<Pair<TransportConfiguration, TransportConfiguration>, FailoverManager>();
    private volatile boolean receivedBroadcast = false;
    private ExecutorService threadPool;
    private ScheduledExecutorService scheduledThreadPool;
    private DiscoveryGroup discoveryGroup;
    private ConnectionLoadBalancingPolicy loadBalancingPolicy;
    private FailoverManager[] failoverManagerArray;
    private boolean readOnly;
    private boolean cacheLargeMessagesClient = false;
    private List<Pair<TransportConfiguration, TransportConfiguration>> staticConnectors;
    private String localBindAddress;
    private String discoveryAddress;
    private int discoveryPort;
    private long discoveryRefreshTimeout;
    private long discoveryInitialWaitTimeout;
    private long clientFailureCheckPeriod;
    private long connectionTTL;
    private long callTimeout;
    private int minLargeMessageSize;
    private int consumerWindowSize;
    private int consumerMaxRate;
    private int confirmationWindowSize;
    private int producerWindowSize;
    private int producerMaxRate;
    private boolean blockOnAcknowledge;
    private boolean blockOnDurableSend;
    private boolean blockOnNonDurableSend;
    private boolean autoGroup;
    private boolean preAcknowledge;
    private String connectionLoadBalancingPolicyClassName;
    private int ackBatchSize;
    private boolean useGlobalPools;
    private int scheduledThreadPoolMaxSize;
    private int threadPoolMaxSize;
    private long retryInterval;
    private double retryIntervalMultiplier;
    private long maxRetryInterval;
    private int reconnectAttempts;
    private boolean failoverOnInitialConnection;
    private int initialMessagePacketSize;
    private volatile boolean closed;
    private boolean failoverOnServerShutdown;
    private final List<Interceptor> interceptors = new CopyOnWriteArrayList<Interceptor>();
    private static ExecutorService globalThreadPool;
    private static ScheduledExecutorService globalScheduledThreadPool;
    private String groupID;

    private static synchronized ExecutorService getGlobalThreadPool() {
        if (globalThreadPool == null) {
            HornetQThreadFactory factory = new HornetQThreadFactory("HornetQ-client-global-threads", true, ClientSessionFactoryImpl.getThisClassLoader());
            globalThreadPool = Executors.newCachedThreadPool(factory);
        }
        return globalThreadPool;
    }

    private static synchronized ScheduledExecutorService getGlobalScheduledThreadPool() {
        if (globalScheduledThreadPool == null) {
            HornetQThreadFactory factory = new HornetQThreadFactory("HornetQ-client-global-scheduled-threads", true, ClientSessionFactoryImpl.getThisClassLoader());
            globalScheduledThreadPool = Executors.newScheduledThreadPool(5, factory);
        }
        return globalScheduledThreadPool;
    }

    private void setThreadPools() {
        if (this.useGlobalPools) {
            this.threadPool = ClientSessionFactoryImpl.getGlobalThreadPool();
            this.scheduledThreadPool = ClientSessionFactoryImpl.getGlobalScheduledThreadPool();
        } else {
            HornetQThreadFactory factory = new HornetQThreadFactory("HornetQ-client-factory-threads-" + System.identityHashCode(this), true, ClientSessionFactoryImpl.getThisClassLoader());
            this.threadPool = this.threadPoolMaxSize == -1 ? Executors.newCachedThreadPool(factory) : Executors.newFixedThreadPool(this.threadPoolMaxSize, factory);
            factory = new HornetQThreadFactory("HornetQ-client-factory-pinger-threads-" + System.identityHashCode(this), true, ClientSessionFactoryImpl.getThisClassLoader());
            this.scheduledThreadPool = Executors.newScheduledThreadPool(this.scheduledThreadPoolMaxSize, factory);
        }
    }

    private synchronized void initialise() throws Exception {
        if (!this.readOnly) {
            this.setThreadPools();
            this.instantiateLoadBalancingPolicy();
            if (this.discoveryAddress != null) {
                InetAddress groupAddress = InetAddress.getByName(this.discoveryAddress);
                InetAddress lbAddress = this.localBindAddress != null ? InetAddress.getByName(this.localBindAddress) : null;
                this.discoveryGroup = new DiscoveryGroupImpl(UUIDGenerator.getInstance().generateStringUUID(), this.discoveryAddress, lbAddress, groupAddress, this.discoveryPort, this.discoveryRefreshTimeout);
                this.discoveryGroup.registerListener(this);
                this.discoveryGroup.start();
            } else if (this.staticConnectors != null) {
                for (Pair<TransportConfiguration, TransportConfiguration> pair : this.staticConnectors) {
                    FailoverManagerImpl cm = new FailoverManagerImpl(this, (TransportConfiguration)pair.a, (TransportConfiguration)pair.b, this.failoverOnServerShutdown, this.callTimeout, this.clientFailureCheckPeriod, this.connectionTTL, this.retryInterval, this.retryIntervalMultiplier, this.maxRetryInterval, this.reconnectAttempts, this.failoverOnInitialConnection, this.threadPool, this.scheduledThreadPool, this.interceptors);
                    this.failoverManagerMap.put(pair, cm);
                }
                this.updatefailoverManagerArray();
            } else {
                throw new IllegalStateException("Before using a session factory you must either set discovery address and port or provide some static transport configuration");
            }
            this.readOnly = true;
        }
    }

    public ClientSessionFactoryImpl(ClientSessionFactory other) {
        this.localBindAddress = other.getLocalBindAddress();
        this.discoveryAddress = other.getDiscoveryAddress();
        this.discoveryPort = other.getDiscoveryPort();
        this.staticConnectors = other.getStaticConnectors();
        this.discoveryRefreshTimeout = other.getDiscoveryRefreshTimeout();
        this.clientFailureCheckPeriod = other.getClientFailureCheckPeriod();
        this.connectionTTL = other.getConnectionTTL();
        this.callTimeout = other.getCallTimeout();
        this.minLargeMessageSize = other.getMinLargeMessageSize();
        this.consumerWindowSize = other.getConsumerWindowSize();
        this.consumerMaxRate = other.getConsumerMaxRate();
        this.confirmationWindowSize = other.getConfirmationWindowSize();
        this.producerWindowSize = other.getProducerWindowSize();
        this.producerMaxRate = other.getProducerMaxRate();
        this.blockOnAcknowledge = other.isBlockOnAcknowledge();
        this.blockOnDurableSend = other.isBlockOnDurableSend();
        this.blockOnNonDurableSend = other.isBlockOnNonDurableSend();
        this.autoGroup = other.isAutoGroup();
        this.preAcknowledge = other.isPreAcknowledge();
        this.ackBatchSize = other.getAckBatchSize();
        this.connectionLoadBalancingPolicyClassName = other.getConnectionLoadBalancingPolicyClassName();
        this.discoveryInitialWaitTimeout = other.getDiscoveryInitialWaitTimeout();
        this.useGlobalPools = other.isUseGlobalPools();
        this.scheduledThreadPoolMaxSize = other.getScheduledThreadPoolMaxSize();
        this.threadPoolMaxSize = other.getThreadPoolMaxSize();
        this.retryInterval = other.getRetryInterval();
        this.retryIntervalMultiplier = other.getRetryIntervalMultiplier();
        this.maxRetryInterval = other.getMaxRetryInterval();
        this.reconnectAttempts = other.getReconnectAttempts();
        this.failoverOnInitialConnection = other.isFailoverOnInitialConnection();
        this.failoverOnServerShutdown = other.isFailoverOnServerShutdown();
        this.cacheLargeMessagesClient = other.isCacheLargeMessagesClient();
        this.initialMessagePacketSize = other.getInitialMessagePacketSize();
        this.groupID = other.getGroupID();
    }

    public ClientSessionFactoryImpl() {
        this.discoveryRefreshTimeout = 10000L;
        this.clientFailureCheckPeriod = 30000L;
        this.connectionTTL = 60000L;
        this.callTimeout = 30000L;
        this.minLargeMessageSize = 102400;
        this.consumerWindowSize = 0x100000;
        this.consumerMaxRate = -1;
        this.confirmationWindowSize = -1;
        this.producerWindowSize = 65536;
        this.producerMaxRate = -1;
        this.blockOnAcknowledge = false;
        this.blockOnDurableSend = true;
        this.blockOnNonDurableSend = false;
        this.autoGroup = false;
        this.preAcknowledge = false;
        this.ackBatchSize = 0x100000;
        this.connectionLoadBalancingPolicyClassName = HornetQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME;
        this.discoveryInitialWaitTimeout = 2000L;
        this.useGlobalPools = true;
        this.scheduledThreadPoolMaxSize = 5;
        this.threadPoolMaxSize = -1;
        this.retryInterval = 2000L;
        this.retryIntervalMultiplier = 1.0;
        this.maxRetryInterval = 2000L;
        this.reconnectAttempts = 0;
        this.failoverOnInitialConnection = false;
        this.failoverOnServerShutdown = false;
        this.cacheLargeMessagesClient = false;
        this.initialMessagePacketSize = 1500;
    }

    public ClientSessionFactoryImpl(String discoveryAddress, int discoveryPort) {
        this();
        this.discoveryAddress = discoveryAddress;
        this.discoveryPort = discoveryPort;
    }

    public ClientSessionFactoryImpl(String localBindAddress, String discoveryAddress, int discoveryPort) {
        this();
        this.localBindAddress = localBindAddress;
        this.discoveryAddress = discoveryAddress;
        this.discoveryPort = discoveryPort;
    }

    public ClientSessionFactoryImpl(List<Pair<TransportConfiguration, TransportConfiguration>> staticConnectors) {
        this();
        this.staticConnectors = staticConnectors;
    }

    public ClientSessionFactoryImpl(TransportConfiguration connectorConfig, TransportConfiguration backupConnectorConfig) {
        this();
        this.staticConnectors = new ArrayList<Pair<TransportConfiguration, TransportConfiguration>>();
        this.staticConnectors.add(new Pair<TransportConfiguration, TransportConfiguration>(connectorConfig, backupConnectorConfig));
    }

    public ClientSessionFactoryImpl(TransportConfiguration connectorConfig) {
        this(connectorConfig, null);
    }

    @Override
    public synchronized boolean isCacheLargeMessagesClient() {
        return this.cacheLargeMessagesClient;
    }

    @Override
    public synchronized void setCacheLargeMessagesClient(boolean cached) {
        this.cacheLargeMessagesClient = cached;
    }

    @Override
    public synchronized List<Pair<TransportConfiguration, TransportConfiguration>> getStaticConnectors() {
        return this.staticConnectors;
    }

    @Override
    public synchronized void setStaticConnectors(List<Pair<TransportConfiguration, TransportConfiguration>> staticConnectors) {
        this.checkWrite();
        this.staticConnectors = staticConnectors;
    }

    @Override
    public synchronized long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    @Override
    public synchronized void setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.checkWrite();
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
    }

    @Override
    public synchronized long getConnectionTTL() {
        return this.connectionTTL;
    }

    @Override
    public synchronized void setConnectionTTL(long connectionTTL) {
        this.checkWrite();
        this.connectionTTL = connectionTTL;
    }

    @Override
    public synchronized long getCallTimeout() {
        return this.callTimeout;
    }

    @Override
    public synchronized void setCallTimeout(long callTimeout) {
        this.checkWrite();
        this.callTimeout = callTimeout;
    }

    @Override
    public synchronized int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    @Override
    public synchronized void setMinLargeMessageSize(int minLargeMessageSize) {
        this.checkWrite();
        this.minLargeMessageSize = minLargeMessageSize;
    }

    @Override
    public synchronized int getConsumerWindowSize() {
        return this.consumerWindowSize;
    }

    @Override
    public synchronized void setConsumerWindowSize(int consumerWindowSize) {
        this.checkWrite();
        this.consumerWindowSize = consumerWindowSize;
    }

    @Override
    public synchronized int getConsumerMaxRate() {
        return this.consumerMaxRate;
    }

    @Override
    public synchronized void setConsumerMaxRate(int consumerMaxRate) {
        this.checkWrite();
        this.consumerMaxRate = consumerMaxRate;
    }

    @Override
    public synchronized int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    @Override
    public synchronized void setConfirmationWindowSize(int confirmationWindowSize) {
        this.checkWrite();
        this.confirmationWindowSize = confirmationWindowSize;
    }

    @Override
    public synchronized int getProducerWindowSize() {
        return this.producerWindowSize;
    }

    @Override
    public synchronized void setProducerWindowSize(int producerWindowSize) {
        this.checkWrite();
        this.producerWindowSize = producerWindowSize;
    }

    @Override
    public synchronized int getProducerMaxRate() {
        return this.producerMaxRate;
    }

    @Override
    public synchronized void setProducerMaxRate(int producerMaxRate) {
        this.checkWrite();
        this.producerMaxRate = producerMaxRate;
    }

    @Override
    public synchronized boolean isBlockOnAcknowledge() {
        return this.blockOnAcknowledge;
    }

    @Override
    public synchronized void setBlockOnAcknowledge(boolean blockOnAcknowledge) {
        this.checkWrite();
        this.blockOnAcknowledge = blockOnAcknowledge;
    }

    @Override
    public synchronized boolean isBlockOnDurableSend() {
        return this.blockOnDurableSend;
    }

    @Override
    public synchronized void setBlockOnDurableSend(boolean blockOnDurableSend) {
        this.checkWrite();
        this.blockOnDurableSend = blockOnDurableSend;
    }

    @Override
    public synchronized boolean isBlockOnNonDurableSend() {
        return this.blockOnNonDurableSend;
    }

    @Override
    public synchronized void setBlockOnNonDurableSend(boolean blockOnNonDurableSend) {
        this.checkWrite();
        this.blockOnNonDurableSend = blockOnNonDurableSend;
    }

    @Override
    public synchronized boolean isAutoGroup() {
        return this.autoGroup;
    }

    @Override
    public synchronized void setAutoGroup(boolean autoGroup) {
        this.checkWrite();
        this.autoGroup = autoGroup;
    }

    @Override
    public synchronized boolean isPreAcknowledge() {
        return this.preAcknowledge;
    }

    @Override
    public synchronized void setPreAcknowledge(boolean preAcknowledge) {
        this.checkWrite();
        this.preAcknowledge = preAcknowledge;
    }

    @Override
    public synchronized int getAckBatchSize() {
        return this.ackBatchSize;
    }

    @Override
    public synchronized void setAckBatchSize(int ackBatchSize) {
        this.checkWrite();
        this.ackBatchSize = ackBatchSize;
    }

    @Override
    public synchronized long getDiscoveryInitialWaitTimeout() {
        return this.discoveryInitialWaitTimeout;
    }

    @Override
    public synchronized void setDiscoveryInitialWaitTimeout(long initialWaitTimeout) {
        this.checkWrite();
        this.discoveryInitialWaitTimeout = initialWaitTimeout;
    }

    @Override
    public synchronized boolean isUseGlobalPools() {
        return this.useGlobalPools;
    }

    @Override
    public synchronized void setUseGlobalPools(boolean useGlobalPools) {
        this.checkWrite();
        this.useGlobalPools = useGlobalPools;
    }

    @Override
    public synchronized int getScheduledThreadPoolMaxSize() {
        return this.scheduledThreadPoolMaxSize;
    }

    @Override
    public synchronized void setScheduledThreadPoolMaxSize(int scheduledThreadPoolMaxSize) {
        this.checkWrite();
        this.scheduledThreadPoolMaxSize = scheduledThreadPoolMaxSize;
    }

    @Override
    public synchronized int getThreadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    @Override
    public synchronized void setThreadPoolMaxSize(int threadPoolMaxSize) {
        this.checkWrite();
        this.threadPoolMaxSize = threadPoolMaxSize;
    }

    @Override
    public synchronized long getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public synchronized void setRetryInterval(long retryInterval) {
        this.checkWrite();
        this.retryInterval = retryInterval;
    }

    @Override
    public synchronized long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    @Override
    public synchronized void setMaxRetryInterval(long retryInterval) {
        this.checkWrite();
        this.maxRetryInterval = retryInterval;
    }

    @Override
    public synchronized double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    @Override
    public synchronized void setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.checkWrite();
        this.retryIntervalMultiplier = retryIntervalMultiplier;
    }

    @Override
    public synchronized int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    @Override
    public synchronized void setReconnectAttempts(int reconnectAttempts) {
        this.checkWrite();
        this.reconnectAttempts = reconnectAttempts;
    }

    @Override
    public synchronized boolean isFailoverOnInitialConnection() {
        return this.failoverOnInitialConnection;
    }

    @Override
    public synchronized void setFailoverOnInitialConnection(boolean failover) {
        this.checkWrite();
        this.failoverOnInitialConnection = failover;
    }

    @Override
    public synchronized boolean isFailoverOnServerShutdown() {
        return this.failoverOnServerShutdown;
    }

    @Override
    public synchronized void setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.checkWrite();
        this.failoverOnServerShutdown = failoverOnServerShutdown;
    }

    @Override
    public synchronized String getConnectionLoadBalancingPolicyClassName() {
        return this.connectionLoadBalancingPolicyClassName;
    }

    @Override
    public synchronized void setConnectionLoadBalancingPolicyClassName(String loadBalancingPolicyClassName) {
        this.checkWrite();
        this.connectionLoadBalancingPolicyClassName = loadBalancingPolicyClassName;
    }

    @Override
    public synchronized String getLocalBindAddress() {
        return this.localBindAddress;
    }

    @Override
    public synchronized void setLocalBindAddress(String localBindAddress) {
        this.checkWrite();
        this.localBindAddress = localBindAddress;
    }

    @Override
    public synchronized String getDiscoveryAddress() {
        return this.discoveryAddress;
    }

    @Override
    public synchronized void setDiscoveryAddress(String discoveryAddress) {
        this.checkWrite();
        this.discoveryAddress = discoveryAddress;
    }

    @Override
    public synchronized int getDiscoveryPort() {
        return this.discoveryPort;
    }

    @Override
    public synchronized void setDiscoveryPort(int discoveryPort) {
        this.checkWrite();
        this.discoveryPort = discoveryPort;
    }

    @Override
    public synchronized long getDiscoveryRefreshTimeout() {
        return this.discoveryRefreshTimeout;
    }

    @Override
    public void addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    @Override
    public boolean removeInterceptor(Interceptor interceptor) {
        return this.interceptors.remove(interceptor);
    }

    @Override
    public synchronized void setDiscoveryRefreshTimeout(long discoveryRefreshTimeout) {
        this.checkWrite();
        this.discoveryRefreshTimeout = discoveryRefreshTimeout;
    }

    @Override
    public synchronized int getInitialMessagePacketSize() {
        return this.initialMessagePacketSize;
    }

    @Override
    public synchronized void setInitialMessagePacketSize(int size) {
        this.checkWrite();
        this.initialMessagePacketSize = size;
    }

    @Override
    public ClientSession createSession(String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int ackBatchSize) throws HornetQException {
        return this.createSessionInternal(username, password, xa, autoCommitSends, autoCommitAcks, preAcknowledge, ackBatchSize);
    }

    @Override
    public ClientSession createSession(boolean autoCommitSends, boolean autoCommitAcks, int ackBatchSize) throws HornetQException {
        return this.createSessionInternal(null, null, false, autoCommitSends, autoCommitAcks, this.preAcknowledge, ackBatchSize);
    }

    @Override
    public ClientSession createXASession() throws HornetQException {
        return this.createSessionInternal(null, null, true, false, false, this.preAcknowledge, this.ackBatchSize);
    }

    @Override
    public ClientSession createTransactedSession() throws HornetQException {
        return this.createSessionInternal(null, null, false, false, false, this.preAcknowledge, this.ackBatchSize);
    }

    @Override
    public ClientSession createSession() throws HornetQException {
        return this.createSessionInternal(null, null, false, true, true, this.preAcknowledge, this.ackBatchSize);
    }

    @Override
    public ClientSession createSession(boolean autoCommitSends, boolean autoCommitAcks) throws HornetQException {
        return this.createSessionInternal(null, null, false, autoCommitSends, autoCommitAcks, this.preAcknowledge, this.ackBatchSize);
    }

    @Override
    public ClientSession createSession(boolean xa, boolean autoCommitSends, boolean autoCommitAcks) throws HornetQException {
        return this.createSessionInternal(null, null, xa, autoCommitSends, autoCommitAcks, this.preAcknowledge, this.ackBatchSize);
    }

    @Override
    public ClientSession createSession(boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge) throws HornetQException {
        return this.createSessionInternal(null, null, xa, autoCommitSends, autoCommitAcks, preAcknowledge, this.ackBatchSize);
    }

    @Override
    public int numSessions() {
        int num = 0;
        for (FailoverManager failoverManager : this.failoverManagerMap.values()) {
            num += failoverManager.numSessions();
        }
        return num;
    }

    @Override
    public int numConnections() {
        int num = 0;
        for (FailoverManager failoverManager : this.failoverManagerMap.values()) {
            num += failoverManager.numConnections();
        }
        return num;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.discoveryGroup != null) {
            try {
                this.discoveryGroup.stop();
            }
            catch (Exception e) {
                log.error("Failed to stop discovery group", e);
            }
        }
        for (FailoverManager failoverManager : this.failoverManagerMap.values()) {
            failoverManager.causeExit();
        }
        this.failoverManagerMap.clear();
        if (!this.useGlobalPools) {
            if (this.threadPool != null) {
                this.threadPool.shutdown();
                try {
                    if (!this.threadPool.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                        log.warn("Timed out waiting for pool to terminate");
                    }
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            if (this.scheduledThreadPool != null) {
                this.scheduledThreadPool.shutdown();
                try {
                    if (!this.scheduledThreadPool.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                        log.warn("Timed out waiting for scheduled pool to terminate");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.closed = true;
    }

    @Override
    public ClientSessionFactory copy() {
        return new ClientSessionFactoryImpl(this);
    }

    @Override
    public void setGroupID(String groupID) {
        this.groupID = groupID;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public synchronized void connectorsChanged() {
        this.receivedBroadcast = true;
        Map<String, DiscoveryEntry> newConnectors = this.discoveryGroup.getDiscoveryEntryMap();
        HashSet<Pair<TransportConfiguration, TransportConfiguration>> connectorSet = new HashSet<Pair<TransportConfiguration, TransportConfiguration>>();
        for (DiscoveryEntry discoveryEntry : newConnectors.values()) {
            connectorSet.add(discoveryEntry.getConnectorPair());
        }
        Iterator<Map.Entry<Pair<TransportConfiguration, TransportConfiguration>, FailoverManager>> iter = this.failoverManagerMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Pair<TransportConfiguration, TransportConfiguration>, FailoverManager> entry = iter.next();
            if (connectorSet.contains(entry.getKey())) continue;
            iter.remove();
        }
        for (Pair pair : connectorSet) {
            if (this.failoverManagerMap.containsKey(pair)) continue;
            FailoverManagerImpl failoverManager = new FailoverManagerImpl(this, (TransportConfiguration)pair.a, (TransportConfiguration)pair.b, this.failoverOnServerShutdown, this.callTimeout, this.clientFailureCheckPeriod, this.connectionTTL, this.retryInterval, this.retryIntervalMultiplier, this.maxRetryInterval, this.reconnectAttempts, this.failoverOnInitialConnection, this.threadPool, this.scheduledThreadPool, this.interceptors);
            this.failoverManagerMap.put(pair, failoverManager);
        }
        this.updatefailoverManagerArray();
    }

    public FailoverManager[] getFailoverManagers() {
        return this.failoverManagerArray;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private void checkWrite() {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set attribute on SessionFactory after it has been used");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientSession createSessionInternal(String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int ackBatchSize) throws HornetQException {
        boolean ok;
        if (this.closed) {
            throw new IllegalStateException("Cannot create session, factory is closed (maybe it has been garbage collected)");
        }
        try {
            this.initialise();
        }
        catch (Exception e) {
            throw new HornetQException(0, "Failed to initialise session factory", e);
        }
        if (this.discoveryGroup != null && !this.receivedBroadcast && !(ok = this.discoveryGroup.waitForBroadcast(this.discoveryInitialWaitTimeout))) {
            throw new HornetQException(3, "Timed out waiting to receive initial broadcast from discovery group");
        }
        ClientSessionFactoryImpl clientSessionFactoryImpl = this;
        synchronized (clientSessionFactoryImpl) {
            int pos = this.loadBalancingPolicy.select(this.failoverManagerArray.length);
            FailoverManager failoverManager = this.failoverManagerArray[pos];
            ClientSession session = failoverManager.createSession(username, password, xa, autoCommitSends, autoCommitAcks, preAcknowledge, ackBatchSize, this.cacheLargeMessagesClient, this.minLargeMessageSize, this.blockOnAcknowledge, this.autoGroup, this.confirmationWindowSize, this.producerWindowSize, this.consumerWindowSize, this.producerMaxRate, this.consumerMaxRate, this.blockOnNonDurableSend, this.blockOnDurableSend, this.initialMessagePacketSize, this.groupID);
            return session;
        }
    }

    private void instantiateLoadBalancingPolicy() {
        if (this.connectionLoadBalancingPolicyClassName == null) {
            throw new IllegalStateException("Please specify a load balancing policy class name on the session factory");
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = loader.loadClass(ClientSessionFactoryImpl.this.connectionLoadBalancingPolicyClassName);
                    ClientSessionFactoryImpl.this.loadBalancingPolicy = (ConnectionLoadBalancingPolicy)clazz.newInstance();
                    return null;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to instantiate load balancing policy \"" + ClientSessionFactoryImpl.this.connectionLoadBalancingPolicyClassName + "\"", e);
                }
            }
        });
    }

    private static ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClientSessionFactoryImpl.class.getClassLoader();
            }
        });
    }

    private synchronized void updatefailoverManagerArray() {
        this.failoverManagerArray = new FailoverManager[this.failoverManagerMap.size()];
        this.failoverManagerMap.values().toArray(this.failoverManagerArray);
    }
}

