/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.client.impl.FailoverManager;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.RemotingConnectionImpl;
import org.hornetq.core.protocol.core.impl.wireformat.Ping;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.spi.core.remoting.Connector;
import org.hornetq.spi.core.remoting.ConnectorFactory;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.OrderedExecutorFactory;

public class FailoverManagerImpl
implements FailoverManager,
ConnectionLifeCycleListener {
    private static final long serialVersionUID = 2512460695662741413L;
    private static final Logger log = Logger.getLogger(FailoverManagerImpl.class);
    private static Map<TransportConfiguration, Set<CoreRemotingConnection>> debugConns;
    private static boolean debug;
    private final TransportConfiguration connectorConfig;
    private ConnectorFactory connectorFactory;
    private Map<String, Object> transportParams;
    private ConnectorFactory backupConnectorFactory;
    private Map<String, Object> backupTransportParams;
    private final long callTimeout;
    private final long clientFailureCheckPeriod;
    private final long connectionTTL;
    private final Set<ClientSessionInternal> sessions = new HashSet<ClientSessionInternal>();
    private final Object exitLock = new Object();
    private final Object createSessionLock = new Object();
    private boolean inCreateSession;
    private final Object failoverLock = new Object();
    private final ExecutorFactory orderedExecutorFactory;
    private final ExecutorService threadPool;
    private final ScheduledExecutorService scheduledThreadPool;
    private final Executor closeExecutor;
    private CoreRemotingConnection connection;
    private final long retryInterval;
    private final double retryIntervalMultiplier;
    private final long maxRetryInterval;
    private final int reconnectAttempts;
    private final boolean failoverOnServerShutdown;
    private final Set<SessionFailureListener> listeners = new ConcurrentHashSet<SessionFailureListener>();
    private Connector connector;
    private Future<?> pingerFuture;
    private PingRunnable pingRunnable;
    private volatile boolean exitLoop;
    private final List<Interceptor> interceptors;
    private volatile boolean stopPingingAfterOne;
    private final boolean failoverOnInitialConnection;

    public static void enableDebug() {
        debug = true;
        debugConns = new ConcurrentHashMap<TransportConfiguration, Set<CoreRemotingConnection>>();
    }

    public static void disableDebug() {
        debug = false;
        debugConns.clear();
        debugConns = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAddDebug(CoreRemotingConnection conn) {
        Map<TransportConfiguration, Set<CoreRemotingConnection>> map = debugConns;
        synchronized (map) {
            Set<CoreRemotingConnection> conns = debugConns.get(this.connectorConfig);
            if (conns == null) {
                conns = new HashSet<CoreRemotingConnection>();
                debugConns.put(this.connectorConfig, conns);
            }
            conns.add(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void failAllConnectionsForConnector(TransportConfiguration config) {
        Set<CoreRemotingConnection> conns;
        Map<TransportConfiguration, Set<CoreRemotingConnection>> map = debugConns;
        synchronized (map) {
            conns = debugConns.get(config);
            if (conns != null) {
                conns = new HashSet<CoreRemotingConnection>((Collection)debugConns.get(config));
            }
        }
        if (conns != null) {
            for (CoreRemotingConnection conn : conns) {
                conn.fail(new HornetQException(0, "simulated connection failure"));
            }
        }
    }

    public FailoverManagerImpl(ClientSessionFactory sessionFactory, TransportConfiguration connectorConfig, TransportConfiguration backupConfig, boolean failoverOnServerShutdown, long callTimeout, long clientFailureCheckPeriod, long connectionTTL, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, boolean failoverOnInitialConnection, ExecutorService threadPool, ScheduledExecutorService scheduledThreadPool, List<Interceptor> interceptors) {
        this.connectorConfig = connectorConfig;
        this.failoverOnServerShutdown = failoverOnServerShutdown;
        this.connectorFactory = this.instantiateConnectorFactory(connectorConfig.getFactoryClassName());
        this.transportParams = connectorConfig.getParams();
        this.checkTransportKeys(this.connectorFactory, this.transportParams);
        if (backupConfig != null) {
            this.backupConnectorFactory = this.instantiateConnectorFactory(backupConfig.getFactoryClassName());
            this.backupTransportParams = backupConfig.getParams();
            this.checkTransportKeys(this.backupConnectorFactory, this.backupTransportParams);
        } else {
            this.backupConnectorFactory = null;
            this.backupTransportParams = null;
        }
        this.callTimeout = callTimeout;
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        this.connectionTTL = connectionTTL;
        this.retryInterval = retryInterval;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        this.maxRetryInterval = maxRetryInterval;
        this.reconnectAttempts = reconnectAttempts;
        this.failoverOnInitialConnection = failoverOnInitialConnection;
        this.scheduledThreadPool = scheduledThreadPool;
        this.threadPool = threadPool;
        this.orderedExecutorFactory = new OrderedExecutorFactory(threadPool);
        this.closeExecutor = this.orderedExecutorFactory.getExecutor();
        this.interceptors = interceptors;
    }

    @Override
    public void connectionCreated(Connection connection, ProtocolType protocol) {
    }

    @Override
    public void connectionDestroyed(Object connectionID) {
        this.handleConnectionFailure(connectionID, new HornetQException(2, "Channel disconnected"));
    }

    @Override
    public void connectionException(Object connectionID, HornetQException me) {
        this.handleConnectionFailure(connectionID, me);
    }

    /*
     * Exception decompiling
     */
    @Override
    public ClientSession createSession(String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int ackBatchSize, boolean cacheLargeMessageClient, int minLargeMessageSize, boolean blockOnAcknowledge, boolean autoGroup, int confWindowSize, int producerWindowSize, int consumerWindowSize, int producerMaxRate, int consumerMaxRate, boolean blockOnNonDurableSend, boolean blockOnDurableSend, int initialMessagePacketSize, String groupID) throws HornetQException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 38[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(ClientSessionInternal session) {
        Object object = this.createSessionLock;
        synchronized (object) {
            Object object2 = this.failoverLock;
            synchronized (object2) {
                this.sessions.remove(session);
                this.checkCloseConnection();
            }
        }
    }

    @Override
    public synchronized int numConnections() {
        return this.connection != null ? 1 : 0;
    }

    @Override
    public int numSessions() {
        return this.sessions.size();
    }

    @Override
    public void addFailureListener(SessionFailureListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeFailureListener(SessionFailureListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void causeExit() {
        this.exitLoop = true;
    }

    public void stopPingingAfterOne() {
        this.stopPingingAfterOne = true;
    }

    private void handleConnectionFailure(Object connectionID, HornetQException me) {
        this.failoverOrReconnect(connectionID, me);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failoverOrReconnect(Object connectionID, HornetQException me) {
        HashSet<ClientSessionInternal> sessionsToClose = null;
        Object object = this.failoverLock;
        synchronized (object) {
            boolean attemptReconnect;
            boolean attemptFailover;
            if (this.connection == null || this.connection.getID() != connectionID) {
                return;
            }
            this.callFailureListeners(me, false);
            boolean serverShutdown = me.getCode() == 4;
            boolean bl = attemptFailover = this.backupConnectorFactory != null && (this.failoverOnServerShutdown || !serverShutdown);
            if (attemptFailover) {
                attemptReconnect = false;
            } else {
                boolean bl2 = attemptReconnect = this.reconnectAttempts != 0;
            }
            if (attemptFailover || attemptReconnect) {
                boolean needToInterrupt;
                this.lockChannel1();
                Object object2 = this.exitLock;
                synchronized (object2) {
                    needToInterrupt = this.inCreateSession;
                }
                this.unlockChannel1();
                if (needToInterrupt) {
                    this.forceReturnChannel1();
                    object2 = this.exitLock;
                    synchronized (object2) {
                        while (this.inCreateSession) {
                            try {
                                this.exitLock.wait(5000L);
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                }
                CoreRemotingConnection oldConnection = this.connection;
                this.connection = null;
                try {
                    this.connector.close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                this.cancelScheduledTasks();
                this.connector = null;
                if (attemptFailover) {
                    this.connectorFactory = this.backupConnectorFactory;
                    this.transportParams = this.backupTransportParams;
                    this.backupConnectorFactory = null;
                    this.backupTransportParams = null;
                    this.reconnectSessions(oldConnection, this.reconnectAttempts == -1 ? -1 : this.reconnectAttempts + 1);
                } else {
                    this.reconnectSessions(oldConnection, this.reconnectAttempts);
                }
                oldConnection.destroy();
            } else {
                this.connection.destroy();
                this.connection = null;
            }
            this.callFailureListeners(me, true);
            if (this.connection == null) {
                sessionsToClose = new HashSet<ClientSessionInternal>(this.sessions);
            }
        }
        if (sessionsToClose != null) {
            for (ClientSessionInternal session : sessionsToClose) {
                try {
                    session.cleanUp();
                }
                catch (Exception e) {
                    log.error("Failed to cleanup session");
                }
            }
        }
    }

    private void callFailureListeners(HornetQException me, boolean afterReconnect) {
        ArrayList<SessionFailureListener> listenersClone = new ArrayList<SessionFailureListener>(this.listeners);
        for (SessionFailureListener listener : listenersClone) {
            try {
                if (afterReconnect) {
                    listener.connectionFailed(me);
                    continue;
                }
                listener.beforeReconnect(me);
            }
            catch (Throwable t) {
                log.error("Failed to execute failure listener", t);
            }
        }
    }

    private void reconnectSessions(CoreRemotingConnection oldConnection, int reconnectAttempts) {
        CoreRemotingConnection newConnection = this.getConnectionWithRetry(reconnectAttempts);
        if (newConnection == null) {
            log.warn("Failed to connect to server.");
            return;
        }
        List<FailureListener> oldListeners = oldConnection.getFailureListeners();
        ArrayList<FailureListener> newListeners = new ArrayList<FailureListener>(newConnection.getFailureListeners());
        for (FailureListener listener : oldListeners) {
            if (listener instanceof DelegatingFailureListener) continue;
            newListeners.add(listener);
        }
        newConnection.setFailureListeners(newListeners);
        for (ClientSessionInternal session : this.sessions) {
            session.handleFailover(newConnection);
        }
    }

    private CoreRemotingConnection getConnectionWithRetry(int reconnectAttempts) {
        CoreRemotingConnection theConnection;
        block7: {
            long interval = this.retryInterval;
            int count = 0;
            while (true) {
                if (this.exitLoop) {
                    return null;
                }
                theConnection = this.getConnection();
                if (theConnection != null) break block7;
                if (reconnectAttempts == 0) break;
                if (reconnectAttempts != -1 && ++count == reconnectAttempts) {
                    log.warn("Tried " + reconnectAttempts + " times to connect. Now giving up.");
                    return null;
                }
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                long newInterval = (long)((double)interval * this.retryIntervalMultiplier);
                if (newInterval > this.maxRetryInterval) {
                    newInterval = this.maxRetryInterval;
                }
                interval = newInterval;
            }
            return null;
        }
        if (debug) {
            this.checkAddDebug(theConnection);
        }
        return theConnection;
    }

    private void cancelScheduledTasks() {
        if (this.pingerFuture != null) {
            this.pingRunnable.cancel();
            this.pingerFuture.cancel(false);
            this.pingRunnable = null;
            this.pingerFuture = null;
        }
    }

    private void checkCloseConnection() {
        if (this.connection != null && this.sessions.size() == 0) {
            this.cancelScheduledTasks();
            try {
                this.connection.destroy();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            this.connection = null;
            try {
                if (this.connector != null) {
                    this.connector.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connector = null;
        }
    }

    @Override
    public CoreRemotingConnection getConnection() {
        if (this.connection == null) {
            Connection tc;
            block15: {
                tc = null;
                try {
                    DelegatingBufferHandler handler = new DelegatingBufferHandler();
                    this.connector = this.connectorFactory.createConnector(this.transportParams, handler, this, this.closeExecutor, this.threadPool, this.scheduledThreadPool);
                    if (this.connector == null) break block15;
                    this.connector.start();
                    tc = this.connector.createConnection();
                    if (tc != null) break block15;
                    try {
                        this.connector.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.connector = null;
                }
                catch (Exception e) {
                    log.warn("connector.create or connectorFactory.createConnector should never throw an exception, implementation is badly behaved, but we'll deal with it anyway.", e);
                    if (tc != null) {
                        try {
                            tc.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (this.connector != null) {
                        try {
                            this.connector.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    tc = null;
                    this.connector = null;
                }
            }
            if (tc == null) {
                return this.connection;
            }
            this.connection = new RemotingConnectionImpl(tc, this.callTimeout, this.interceptors);
            this.connection.addFailureListener(new DelegatingFailureListener(this.connection.getID()));
            this.connection.getChannel(0L, -1).setHandler(new Channel0Handler(this.connection));
            if (this.clientFailureCheckPeriod != -1L) {
                if (this.pingerFuture == null) {
                    this.pingRunnable = new PingRunnable();
                    this.pingerFuture = this.scheduledThreadPool.scheduleWithFixedDelay(new ActualScheduledPinger(this.pingRunnable), 0L, this.clientFailureCheckPeriod, TimeUnit.MILLISECONDS);
                } else {
                    this.pingRunnable.run();
                }
            }
        }
        return this.connection;
    }

    private ConnectorFactory instantiateConnectorFactory(String connectorFactoryClassName) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = loader.loadClass(connectorFactoryClassName);
            return (ConnectorFactory)clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error instantiating connector factory \"" + connectorFactoryClassName + "\"", e);
        }
    }

    private void lockChannel1() {
        Channel channel1 = this.connection.getChannel(1L, -1);
        channel1.getLock().lock();
    }

    private void unlockChannel1() {
        Channel channel1 = this.connection.getChannel(1L, -1);
        channel1.getLock().unlock();
    }

    private void forceReturnChannel1() {
        Channel channel1 = this.connection.getChannel(1L, -1);
        channel1.returnBlocking();
    }

    private void checkTransportKeys(ConnectorFactory factory, Map<String, Object> params) {
        Set<String> invalid;
        if (params != null && !(invalid = ConfigurationHelper.checkKeys(factory.getAllowableProperties(), params.keySet())).isEmpty()) {
            String msg = ConfigurationHelper.stringSetToCommaListString("The following keys are invalid for configuring a connector: ", invalid);
            throw new IllegalStateException(msg);
        }
    }

    static {
        debug = false;
    }

    private final class PingRunnable
    implements Runnable {
        private boolean cancelled;
        private boolean first;
        private long lastCheck = System.currentTimeMillis();

        private PingRunnable() {
        }

        @Override
        public synchronized void run() {
            if (this.cancelled || FailoverManagerImpl.this.stopPingingAfterOne && !this.first) {
                return;
            }
            this.first = false;
            long now = System.currentTimeMillis();
            if (FailoverManagerImpl.this.clientFailureCheckPeriod != -1L && now >= this.lastCheck + FailoverManagerImpl.this.clientFailureCheckPeriod) {
                if (!FailoverManagerImpl.this.connection.checkDataReceived()) {
                    final HornetQException me = new HornetQException(3, "Did not receive data from server for " + FailoverManagerImpl.this.connection.getTransportConnection());
                    this.cancelled = true;
                    FailoverManagerImpl.this.threadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            FailoverManagerImpl.this.connection.fail(me);
                        }
                    });
                    return;
                }
                this.lastCheck = now;
            }
            Ping ping = new Ping(FailoverManagerImpl.this.connectionTTL);
            Channel channel0 = FailoverManagerImpl.this.connection.getChannel(0L, -1);
            channel0.send(ping);
            FailoverManagerImpl.this.connection.flush();
        }

        public synchronized void cancel() {
            this.cancelled = true;
        }
    }

    private static final class ActualScheduledPinger
    implements Runnable {
        private final WeakReference<PingRunnable> pingRunnable;

        ActualScheduledPinger(PingRunnable runnable) {
            this.pingRunnable = new WeakReference<PingRunnable>(runnable);
        }

        @Override
        public void run() {
            PingRunnable runnable = (PingRunnable)this.pingRunnable.get();
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    private class DelegatingFailureListener
    implements FailureListener {
        private final Object connectionID;

        DelegatingFailureListener(Object connectionID) {
            this.connectionID = connectionID;
        }

        @Override
        public void connectionFailed(HornetQException me) {
            FailoverManagerImpl.this.handleConnectionFailure(this.connectionID, me);
        }
    }

    private class DelegatingBufferHandler
    implements BufferHandler {
        private DelegatingBufferHandler() {
        }

        @Override
        public void bufferReceived(Object connectionID, HornetQBuffer buffer) {
            CoreRemotingConnection theConn = FailoverManagerImpl.this.connection;
            if (theConn != null && connectionID == theConn.getID()) {
                theConn.bufferReceived(connectionID, buffer);
            }
        }
    }

    private class Channel0Handler
    implements ChannelHandler {
        private final CoreRemotingConnection conn;

        private Channel0Handler(CoreRemotingConnection conn) {
            this.conn = conn;
        }

        @Override
        public void handlePacket(Packet packet) {
            byte type = packet.getType();
            if (type == 11) {
                FailoverManagerImpl.this.closeExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Channel0Handler.this.conn.fail(new HornetQException(4, "The connection was disconnected because of server shutdown"));
                    }
                });
            }
        }
    }
}

