/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb.jboss;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import javax.ejb.EJBLocalObject;
import javax.ejb.Local;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.lang.ClassHelper;

public class LocalProcessor
extends AbstractFinderUser
implements Processor<JBossSessionBeanMetaData, Class<?>> {
    public LocalProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    protected void addBusinessInterface(JBossSessionBeanMetaData metaData, Class<?> businessInterface) {
        if (EJBLocalObject.class.isAssignableFrom(businessInterface)) {
            throw new IllegalStateException("EJB 3.0 Core Specification Violation (4.6.6): The session bean\u00e2\u20ac\u2122s business interface " + businessInterface + " must not extend the javax.ejb.EJBLocalObject interface.");
        }
        if (metaData.getBusinessLocals() == null) {
            metaData.setBusinessLocals(new BusinessLocalsMetaData());
        }
        metaData.getBusinessLocals().add(businessInterface.getName());
    }

    public void process(JBossSessionBeanMetaData metaData, Class<?> type) {
        Local local = (Local)this.finder.getAnnotation(type, Local.class);
        if (local == null) {
            return;
        }
        if (type.isInterface()) {
            this.addBusinessInterface(metaData, type);
        } else if (local.value() == null || local.value().length == 0) {
            Class businessInterface = ClassHelper.getDefaultInterface(type);
            this.addBusinessInterface(metaData, businessInterface);
        } else {
            for (Class businessInterface : local.value()) {
                this.addBusinessInterface(metaData, businessInterface);
            }
        }
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(Local.class);
    }
}

