/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.integration.deployer.DeployersUtils;
import org.jboss.weld.integration.deployer.metadata.WeldAwareMetadataDeployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostWebMetadataDeployer
extends WeldAwareMetadataDeployer<JBossWebMetaData> {
    private final ListenerMetaData WBL;
    private final ListenerMetaData JIL;
    private final FilterMetaData CPF;
    private final FilterMappingMetaData CPFM;

    public PostWebMetadataDeployer() {
        super(JBossWebMetaData.class, true);
        this.addInput("WELD_FILES");
        this.addInput("merged." + JBossWebMetaData.class.getName());
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.setOptionalWeldXml(true);
        this.WBL = new ListenerMetaData();
        this.WBL.setListenerClass("org.jboss.weld.servlet.WeldListener");
        this.JIL = new ListenerMetaData();
        this.JIL.setListenerClass("org.jboss.weld.integration.webtier.jsp.JspInitializationListener");
        this.CPF = new FilterMetaData();
        this.CPF.setFilterName("Weld Conversation Propagation Filter");
        this.CPF.setFilterClass("org.jboss.weld.servlet.ConversationPropagationFilter");
        this.CPFM = new FilterMappingMetaData();
        this.CPFM.setFilterName("Weld Conversation Propagation Filter");
        this.CPFM.setUrlPatterns(Arrays.asList("/*"));
    }

    @Override
    protected void internalDeploy(VFSDeploymentUnit unit, JBossWebMetaData deployment, VirtualFile wbXml) throws DeploymentException {
        if (wbXml != null || DeployersUtils.checkForWeldFiles((DeploymentUnit)unit)) {
            ArrayList<ListenerMetaData> listeners = deployment.getListeners();
            if (listeners == null) {
                listeners = new ArrayList<ListenerMetaData>();
                deployment.setListeners(listeners);
            }
            listeners.add(this.WBL);
            listeners.add(this.JIL);
            FiltersMetaData filters = deployment.getFilters();
            if (filters == null) {
                filters = new FiltersMetaData();
                deployment.setFilters(filters);
            }
            filters.add((MappableMetaData)this.CPF);
            ArrayList<FilterMappingMetaData> filterMappings = deployment.getFilterMappings();
            if (filterMappings == null) {
                filterMappings = new ArrayList<FilterMappingMetaData>();
                deployment.setFilterMappings(filterMappings);
            }
            filterMappings.add(this.CPFM);
        }
    }
}

