/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.common.internal;

import org.jboss.osgi.common.internal.LogListenerBridge;
import org.jboss.osgi.common.log.LogServiceTracker;
import org.jboss.osgi.common.log.LoggingService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.LoggerFactory;

public class CommonServicesActivator
implements BundleActivator {
    private LogServiceTracker logServiceTracker;
    private ServiceTracker logReaderTracker;

    public void start(BundleContext context) {
        LoggerFactory.getLogger(CommonServicesActivator.class);
        this.logServiceTracker = new LogServiceTracker(context);
        this.logReaderTracker = new LogReaderServiceServiceTracker(context);
        this.logReaderTracker.open();
        context.registerService(LoggingService.class.getName(), (Object)new LoggingService(){}, null);
    }

    public void stop(BundleContext context) {
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
        }
        if (this.logReaderTracker != null) {
            this.logReaderTracker.close();
        }
    }

    static class LogReaderServiceServiceTracker
    extends ServiceTracker {
        public LogReaderServiceServiceTracker(BundleContext context) {
            super(context, LogReaderService.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            LogReaderService logReader = (LogReaderService)super.addingService(reference);
            logReader.addLogListener((LogListener)new LogListenerBridge());
            return logReader;
        }
    }
}

