/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployer;

import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSStructureDeployer;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;

public class BundleStructureDeployer
extends AbstractVFSStructureDeployer {
    public BundleStructureDeployer() {
        this.setRelativeOrder(500);
    }

    public boolean determineStructure(StructureContext structureContext) throws DeploymentException {
        ContextInfo context = null;
        org.jboss.vfs.VirtualFile root = structureContext.getRoot();
        try {
            Manifest manifest = VFSUtils.getManifest((VirtualFile)AbstractVFS.adapt((Object)root));
            if (root != structureContext.getFile() || manifest == null) {
                return false;
            }
            Attributes attribs = manifest.getMainAttributes();
            String symbolicName = attribs.getValue("Bundle-SymbolicName");
            if (symbolicName == null) {
                return false;
            }
            context = this.createContext(structureContext, "META-INF");
            String classPath = attribs.getValue("Bundle-ClassPath");
            if (classPath == null) {
                this.addClassPath(structureContext, root, true, false, context);
            } else {
                String[] classPathArr;
                for (String path : classPathArr = classPath.split(",")) {
                    if ((path = path.trim()).length() <= 0) continue;
                    int semicolon = path.indexOf(59);
                    if (semicolon > 0) {
                        path = path.substring(0, semicolon);
                    }
                    if (path.equals(".")) {
                        this.addClassPath(structureContext, root, true, false, context);
                        continue;
                    }
                    org.jboss.vfs.VirtualFile child = root.getChild(path);
                    this.addClassPath(structureContext, child, true, false, context);
                }
            }
            return true;
        }
        catch (Exception e) {
            if (context != null) {
                structureContext.removeChild(context);
            }
            throw DeploymentException.rethrowAsDeploymentException((String)("Error determining structure: " + root.getName()), (Throwable)e);
        }
    }
}

