/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.blueprint.internal;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;
import org.apache.aries.blueprint.container.NamespaceHandlerRegistry;
import org.apache.aries.blueprint.namespace.NamespaceHandlerRegistryImpl;
import org.jboss.osgi.blueprint.internal.BlueprintEventDispatcher;
import org.jboss.osgi.deployment.interceptor.AbstractLifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.container.BlueprintListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintInterceptor
extends AbstractLifecycleInterceptor
implements LifecycleInterceptor {
    private Logger log = LoggerFactory.getLogger(BlueprintInterceptor.class);
    private Map<Bundle, BlueprintContainerImpl> containers;
    private BlueprintEventDispatcher eventDispatcher;
    private NamespaceHandlerRegistry handlers;
    private ScheduledExecutorService executors;

    public void start(BundleContext context) {
        this.containers = new HashMap<Bundle, BlueprintContainerImpl>();
        this.handlers = new NamespaceHandlerRegistryImpl(context);
        this.executors = Executors.newScheduledThreadPool(3);
        this.eventDispatcher = new BlueprintEventDispatcher(context, this.executors);
        context.registerService(LifecycleInterceptor.class.getName(), (Object)this, null);
    }

    public void stop(BundleContext context) {
        for (Bundle bundle : this.containers.keySet()) {
            BlueprintContainerImpl blueprintContainer = this.containers.remove(bundle);
            blueprintContainer.destroy();
        }
    }

    public void invoke(int state, InvocationContext context) throws LifecycleInterceptorException {
        BlueprintContainerImpl blueprintContainer;
        Bundle bundle = context.getBundle();
        if (state == 8) {
            ArrayList<String> pathList = new ArrayList<String>();
            String descriptorPaths = (String)bundle.getHeaders().get("Bundle-Blueprint");
            if (descriptorPaths != null) {
                StringTokenizer tokenizer = new StringTokenizer(descriptorPaths, ",");
                while (tokenizer.hasMoreTokens()) {
                    String path = tokenizer.nextToken();
                    pathList.add(path.trim());
                }
            } else {
                Enumeration foundEntries = bundle.findEntries("OSGI-INF/blueprint", "*.xml", false);
                if (foundEntries != null) {
                    while (foundEntries.hasMoreElements()) {
                        String path = foundEntries.nextElement().toString();
                        int index = path.indexOf("OSGI-INF/blueprint");
                        pathList.add(path.substring(index));
                    }
                }
            }
            if (!pathList.isEmpty()) {
                this.log.debug("Create blueprint container");
                BlueprintContainerImpl blueprintContainer2 = new BlueprintContainerImpl(bundle.getBundleContext(), context.getBundle(), (BlueprintListener)this.eventDispatcher, this.handlers, this.executors, pathList);
                this.containers.put(bundle, blueprintContainer2);
                blueprintContainer2.schedule();
            }
        } else if (state == 16 && (blueprintContainer = this.containers.remove(bundle)) != null) {
            this.log.debug("Stop blueprint container");
            blueprintContainer.destroy();
        }
    }
}

