/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.composite;

import com.sun.faces.application.view.FaceletViewHandlingStrategy;
import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.composite.CompositeComponentBeanInfo;
import com.sun.faces.facelets.tag.composite.PropertyHandler;
import com.sun.faces.facelets.tag.composite.PropertyHandlerManager;
import java.beans.BeanDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;

public class InterfaceHandler
extends TagHandlerImpl {
    private static final String[] ATTRIBUTES_DEV = new String[]{"displayName", "expert", "hidden", "preferred", "shortDescription", "name", "componentType"};
    private static final PropertyHandlerManager INTERFACE_HANDLERS = PropertyHandlerManager.getInstance(ATTRIBUTES_DEV);
    public static final String Name = "interface";

    public InterfaceHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        FacesContext context = ctx.getFacesContext();
        if (FaceletViewHandlingStrategy.isBuildingMetadata(context)) {
            this.imbueComponentWithMetadata(ctx, parent);
            this.nextHandler.apply(ctx, parent);
        }
    }

    private void imbueComponentWithMetadata(FaceletContext ctx, UIComponent parent) {
        if (null == parent || null == (parent = parent.getParent()) || !ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        Map attrs = parent.getAttributes();
        CompositeComponentBeanInfo componentBeanInfo = (CompositeComponentBeanInfo)attrs.get("javax.faces.component.BEANINFO_KEY");
        if (componentBeanInfo == null) {
            Resource componentResource;
            componentBeanInfo = new CompositeComponentBeanInfo();
            attrs.put("javax.faces.component.BEANINFO_KEY", componentBeanInfo);
            BeanDescriptor componentDescriptor = new BeanDescriptor(parent.getClass());
            componentBeanInfo.setBeanDescriptor(componentDescriptor);
            for (TagAttribute tagAttribute : this.tag.getAttributes().getAll()) {
                String attributeName = tagAttribute.getLocalName();
                PropertyHandler handler = INTERFACE_HANDLERS.getHandler(ctx, attributeName);
                if (handler == null) continue;
                handler.apply(ctx, attributeName, componentDescriptor, tagAttribute);
            }
            ArrayList targetList = (ArrayList)componentDescriptor.getValue("javax.faces.view.AttachedObjectTargets");
            if (null == targetList) {
                targetList = new ArrayList();
                componentDescriptor.setValue("javax.faces.view.AttachedObjectTargets", targetList);
            }
            if (null == (componentResource = (Resource)attrs.get("javax.faces.application.Resource.ComponentResource"))) {
                throw new NullPointerException("Unable to find Resource for composite component");
            }
        }
    }
}

