/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.lang.annotation.Inherited;
import java.util.HashMap;
import java.util.Map;
import javassist.CtClass;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.javassist.JavassistAnnotatedInfo;
import org.jboss.reflect.spi.AnnotationValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavassistInheritableAnnotationHolder
extends JavassistAnnotatedInfo {
    private static final long serialVersionUID = -714018976926313160L;
    private static final String INHERITED_NAME = Inherited.class.getName();
    protected Map<String, AnnotationValue> allAnnotations;
    protected AnnotationValue[] allAnnotationsArray = NOT_CONFIGURED;
    protected CtClass ctClass;

    public JavassistInheritableAnnotationHolder(CtClass ctClass, AnnotationHelper annotationHelper) {
        super(annotationHelper);
        this.ctClass = ctClass;
    }

    @Override
    public AnnotationValue[] getAnnotations() {
        if (this.allAnnotationsArray == NOT_CONFIGURED) {
            this.setupAnnotations(this.annotationHelper.getAnnotations(this.ctClass));
        }
        return this.allAnnotationsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AnnotationValue[] getAnnotations(Object obj) {
        JavassistInheritableAnnotationHolder javassistInheritableAnnotationHolder = this;
        synchronized (javassistInheritableAnnotationHolder) {
            if (this.allAnnotationsArray == NOT_CONFIGURED) {
                this.allAnnotationsArray = this.annotationHelper.getAnnotations(obj);
                this.setupAnnotations(this.allAnnotationsArray);
            }
        }
        return this.allAnnotationsArray;
    }

    @Override
    public AnnotationValue getAnnotation(String name) {
        this.getAnnotations();
        return this.allAnnotations.get(name);
    }

    @Override
    public boolean isAnnotationPresent(String name) {
        this.getAnnotations();
        return this.allAnnotations.containsKey(name);
    }

    @Override
    public void setupAnnotations(AnnotationValue[] annotations) {
        AnnotationValue[] superAllAnnotations;
        JavassistInheritableAnnotationHolder superHolder = this.getSuperHolder();
        AnnotationValue[] annotationValueArray = superAllAnnotations = superHolder != null ? superHolder.getAnnotations() : null;
        if (annotations != null && annotations.length > 0) {
            int i;
            this.annotationMap = new HashMap();
            this.annotationsArray = annotations;
            for (i = 0; i < annotations.length; ++i) {
                this.annotationMap.put(annotations[i].getAnnotationType().getName(), annotations[i]);
            }
            this.allAnnotations = new HashMap<String, AnnotationValue>();
            if (superHolder != null && superAllAnnotations != null && superAllAnnotations.length != 0) {
                for (i = 0; i < superAllAnnotations.length; ++i) {
                    AnnotationValue av = superAllAnnotations[i];
                    if (!av.getAnnotationType().isAnnotationPresent(INHERITED_NAME)) continue;
                    this.allAnnotations.put(av.getAnnotationType().getName(), av);
                }
            } else {
                this.allAnnotationsArray = this.annotationsArray;
            }
            for (i = 0; i < annotations.length; ++i) {
                this.allAnnotations.put(annotations[i].getAnnotationType().getName(), annotations[i]);
            }
            this.allAnnotationsArray = this.allAnnotations.values().toArray(new AnnotationValue[this.allAnnotations.size()]);
        } else if (superHolder != null) {
            this.allAnnotations = superHolder.getAllAnnotations();
            this.allAnnotationsArray = superAllAnnotations;
        } else {
            this.allAnnotations = new HashMap<String, AnnotationValue>();
        }
    }

    protected Map<String, AnnotationValue> getAllAnnotations() {
        if (this.allAnnotations == null) {
            this.setupAnnotations(this.annotationHelper.getAnnotations(this.ctClass));
        }
        return this.allAnnotations;
    }

    public abstract JavassistInheritableAnnotationHolder getSuperHolder();
}

