/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.metadata.mcf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jboss.logging.Logger;
import org.jboss.managed.api.annotation.ActivationPolicy;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementObjectRef;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ManagementPropertyFactory;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.resource.deployers.management.ConnectionFactoryProperty;
import org.jboss.resource.metadata.mcf.ApplicationManagedSecurityMetaData;
import org.jboss.resource.metadata.mcf.ConnectionPoolMetaData;
import org.jboss.resource.metadata.mcf.DBMSMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionEmptyContentAdapter;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryPropertyMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryTransactionSupportMetaData;
import org.jboss.resource.metadata.mcf.SecurityDomainApplicationManagedMetaData;
import org.jboss.resource.metadata.mcf.SecurityDomainMetaData;
import org.jboss.resource.metadata.mcf.SecurityMetaData;
import org.jboss.system.metadata.ServiceMetaData;

@XmlAccessorType(value=XmlAccessType.FIELD)
@ManagementObject(properties=ManagementProperties.EXPLICIT)
public class ManagedConnectionFactoryDeploymentMetaData
implements Serializable,
ConnectionPoolMetaData {
    private static Logger log = Logger.getLogger(ManagedConnectionFactoryDeploymentMetaData.class);
    private static final long serialVersionUID = -4591557831734316580L;
    @XmlElement(name="jndi-name")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String jndiName;
    @XmlElement(name="rar-name")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String rarName;
    @XmlElement(name="use-java-context")
    private boolean useJavaContext = true;
    @XmlElement(name="connection-definition")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String connectionDefinition;
    @XmlElement(name="jmx-invoker-name")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String jmxInvokerName = "jboss:service=invoker,type=jrmp";
    @XmlElement(name="min-pool-size")
    private int minSize = 0;
    @XmlElement(name="max-pool-size")
    private int maxPoolSize = 10;
    @XmlElement(name="blocking-timeout-millis")
    private long blockingTimeout = 30000L;
    @XmlElement(name="idle-timeout-minutes")
    private int idleTimeout = 30;
    @XmlElement(name="prefill")
    private Boolean prefill = Boolean.FALSE;
    @XmlElement(name="background-validation")
    private boolean backgroundValidation;
    @XmlElement(name="background-validation-millis")
    private long backgroundValidationMillis;
    @XmlElement(name="validate-on-match")
    private boolean validateOnMatch = true;
    @XmlJavaTypeAdapter(value=ManagedConnectionEmptyContentAdapter.class)
    @XmlElement(name="use-strict-min")
    private Boolean useStrictMin = Boolean.FALSE;
    @XmlJavaTypeAdapter(value=ManagedConnectionEmptyContentAdapter.class)
    @XmlElement(name="no-tx-separate-pools")
    private Boolean noTxSeparatePools = Boolean.FALSE;
    @XmlElement(name="statistics-formatter")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String statisticsFormatter = "org.jboss.resource.statistic.pool.JBossDefaultSubPoolStatisticFormatter";
    @XmlElement(name="isSameRM-override-value")
    private Boolean isSameRMOverrideValue = Boolean.FALSE;
    @Deprecated
    @XmlJavaTypeAdapter(value=ManagedConnectionEmptyContentAdapter.class)
    @XmlElement(name="track-connection-by-tx")
    private Boolean trackConnectionByTransaction;
    @XmlJavaTypeAdapter(value=ManagedConnectionEmptyContentAdapter.class)
    @XmlElement(name="interleaving")
    private Boolean interleaving;
    @XmlElement(name="allocation-retry")
    private int allocationRetry = 0;
    @XmlElement(name="allocation-retry-wait-millis")
    private long allocationRetryWaitMillis = 5000L;
    @XmlTransient
    private ManagedConnectionFactoryTransactionSupportMetaData transactionSupportMetaData = ManagedConnectionFactoryTransactionSupportMetaData.NONE;
    @XmlElement(name="config-property")
    private List<ManagedConnectionFactoryPropertyMetaData> managedConnectionFactoryProperties = new ArrayList<ManagedConnectionFactoryPropertyMetaData>();
    @XmlElements(value={@XmlElement(name="security-domain", type=SecurityDomainMetaData.class), @XmlElement(name="security-domain-and-application", type=SecurityDomainApplicationManagedMetaData.class), @XmlElement(name="application-managed-security", type=ApplicationManagedSecurityMetaData.class)})
    private SecurityMetaData securityMetaData;
    @XmlElement(name="depends")
    private List<String> dependsNames = new ArrayList<String>();
    @XmlTransient
    private List<ServiceMetaData> dependsServices = new ArrayList<ServiceMetaData>();
    @XmlElement(name="metadata")
    private DBMSMetaData dbmsMetaData;
    @XmlElement(name="type-mapping")
    String typeMapping;
    @XmlJavaTypeAdapter(value=ManagedConnectionEmptyContentAdapter.class)
    @XmlElement(name="local-transaction")
    private Boolean localTransactions = Boolean.FALSE;

    public ManagedConnectionFactoryDeploymentMetaData() {
        this.interleaving = Boolean.FALSE;
    }

    @ManagementProperty(name="connection-definition", description="The connection factory class name", mandatory=true, includeInTemplate=true)
    public String getConnectionDefinition() {
        return this.connectionDefinition;
    }

    public void setConnectionDefinition(String connectionDefinition) {
        this.connectionDefinition = connectionDefinition;
    }

    @ManagementProperty(name="jndi-name", description="The global JNDI name to bind the factory under", includeInTemplate=true, mandatory=true)
    @ManagementObjectID(type="DataSource")
    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    @ManagementProperty(ignored=true)
    public ManagedConnectionFactoryTransactionSupportMetaData getTransactionSupportMetaData() {
        return this.transactionSupportMetaData;
    }

    public void setTransactionSupportMetaData(ManagedConnectionFactoryTransactionSupportMetaData transactionSupportMetaData) {
        this.transactionSupportMetaData = transactionSupportMetaData;
    }

    @ManagementProperty(name="use-java-context", description="Should the jndi name be bound under the java: context", includeInTemplate=true)
    public boolean isUseJavaContext() {
        return this.useJavaContext;
    }

    public void setUseJavaContext(boolean useJavaContext) {
        this.useJavaContext = useJavaContext;
    }

    @ManagementProperty(name="config-property", description="The connection factory config properties", managed=true, includeInTemplate=true)
    @ManagementPropertyFactory(value=ConnectionFactoryProperty.class)
    public List<ManagedConnectionFactoryPropertyMetaData> getManagedConnectionFactoryProperties() {
        return this.managedConnectionFactoryProperties;
    }

    public void setManagedConnectionFactoryProperties(List<ManagedConnectionFactoryPropertyMetaData> managedConnectionFactoryProperties) {
        this.managedConnectionFactoryProperties = managedConnectionFactoryProperties;
    }

    @ManagementProperty(name="rar-name", description="The resource adapter archive name", mandatory=true, includeInTemplate=true)
    public String getRarName() {
        return this.rarName;
    }

    public void setRarName(String rarName) {
        this.rarName = rarName;
    }

    @ManagementProperty(name="security-domain", description="The security-domain used to validate connections", includeInTemplate=true)
    public SecurityMetaData getSecurityMetaData() {
        return this.securityMetaData;
    }

    public void setSecurityMetaData(SecurityMetaData securityMetaData) {
        this.securityMetaData = securityMetaData;
    }

    @ManagementProperty(name="type-mapping", includeInTemplate=true)
    public String getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(String typeMapping) {
        this.typeMapping = typeMapping;
    }

    @ManagementProperty(name="jmx-invoker-name", description="The name of the JMX invoker", includeInTemplate=true)
    @ManagementObjectRef(type="JMXInvoker")
    public String getJmxInvokerName() {
        return this.jmxInvokerName;
    }

    public void setJmxInvokerName(String jmxInvokerName) {
        this.jmxInvokerName = jmxInvokerName;
    }

    @ManagementProperty(name="depends", ignored=true)
    public List<String> getDependsNames() {
        return this.dependsNames;
    }

    public void setDependsNames(List<String> dependsNames) {
        this.dependsNames = dependsNames;
    }

    @ManagementProperty(name="services", ignored=true)
    public List<ServiceMetaData> getDependsServices() {
        return this.dependsServices;
    }

    public void setDependsServices(List<ServiceMetaData> dependsServices) {
        this.dependsServices = dependsServices;
    }

    @Override
    @ManagementProperty(name="min-pool-size", description="The min size of the pool", includeInTemplate=true)
    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    @Override
    public int getMinSize() {
        return this.minSize;
    }

    @Override
    @ManagementProperty(name="max-pool-size", description="The max size of the pool", includeInTemplate=true)
    public void setMaxSize(int maxSize) {
        this.maxPoolSize = maxSize;
    }

    @Override
    public int getMaxSize() {
        if (this.maxPoolSize >= this.minSize) {
            return this.maxPoolSize;
        }
        return this.minSize;
    }

    @Override
    @ManagementProperty(name="blocking-timeout-millis", description="The time to wait for a connection to become available before giving up", includeInTemplate=true)
    public void setBlockingTimeoutMilliSeconds(long blockTimeout) {
        this.blockingTimeout = blockTimeout;
    }

    @Override
    public long getBlockingTimeoutMilliSeconds() {
        return this.blockingTimeout;
    }

    @Override
    @ManagementProperty(name="idle-timeout-minutes", description="The idle timeout in minutes", includeInTemplate=true)
    public void setIdleTimeoutMinutes(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Override
    public int getIdleTimeoutMinutes() {
        return this.idleTimeout;
    }

    @Override
    @ManagementProperty(name="prefill", description="Whether to prefill the pool", includeInTemplate=true)
    public void setPrefill(Boolean prefill) {
        this.prefill = prefill;
    }

    @Override
    public Boolean getPrefill() {
        return this.prefill;
    }

    @ManagementProperty(name="background-validation", description="Whether to use backgroup validation", includeInTemplate=true)
    public boolean isBackgroundValidation() {
        return this.backgroundValidation;
    }

    public void setBackgroundValidation(boolean backgroundValidation) {
        this.backgroundValidation = backgroundValidation;
    }

    @Override
    public void setBackgroundValidationMillis(long interval) {
        this.backgroundValidationMillis = interval;
    }

    @Override
    @ManagementProperty(name="background-validation-millis", includeInTemplate=true)
    public long getBackgroundValidationMillis() {
        return this.backgroundValidationMillis;
    }

    @Override
    public void setValidateOnMatch(boolean validateOnMatch) {
        this.validateOnMatch = validateOnMatch;
    }

    @Override
    @ManagementProperty(name="validate-on-match", includeInTemplate=true)
    public boolean isValidateOnMatch() {
        return this.validateOnMatch;
    }

    @ManagementProperty(name="isSameRM-override-value", includeInTemplate=true)
    public Boolean getIsSameRMOverrideValue() {
        return this.isSameRMOverrideValue;
    }

    public void setIsSameRMOverrideValue(Boolean isSameRMOverrideValue) {
        this.isSameRMOverrideValue = isSameRMOverrideValue;
    }

    @Deprecated
    @ManagementProperty(name="track-connection-by-tx", includeInTemplate=true, use={ViewUse.CONFIGURATION})
    public Boolean getTrackConnectionByTransaction() {
        return this.isInterleaving() == false;
    }

    @Deprecated
    public void setTrackConnectionByTransaction(Boolean trackConnectionByTransaction) {
        if (Boolean.TRUE == this.getLocalTransactions() && !Boolean.TRUE.equals(trackConnectionByTransaction)) {
            log.warn((Object)"In case of local transactions track-connection-by-tx must always be true");
            trackConnectionByTransaction = Boolean.TRUE;
        }
        this.setInterleaving(!Boolean.TRUE.equals(trackConnectionByTransaction));
    }

    public Boolean isInterleaving() {
        return this.interleaving == Boolean.TRUE && !Boolean.TRUE.equals(this.getLocalTransactions());
    }

    @ManagementProperty(name="interleaving", includeInTemplate=true, use={ViewUse.CONFIGURATION}, activationPolicy=ActivationPolicy.DEPLOYMENT_RESTART)
    public Boolean getInterleaving() {
        return this.isInterleaving();
    }

    public void setInterleaving(Boolean interleaving) {
        this.interleaving = interleaving;
    }

    @ManagementProperty(name="allocation-retry", description="The number of times allocation retries should be tried", includeInTemplate=true, use={ViewUse.CONFIGURATION})
    public int getAllocationRetry() {
        return this.allocationRetry;
    }

    public void setAllocationRetry(int ar) {
        this.allocationRetry = ar;
    }

    @ManagementProperty(name="allocation-retry-wait-millis", description="The time to wait between allocation retries", includeInTemplate=true, use={ViewUse.CONFIGURATION})
    public long getAllocationRetryWaitMillis() {
        return this.allocationRetryWaitMillis;
    }

    public void setAllocationRetryWaitMillis(long arwm) {
        this.allocationRetryWaitMillis = arwm;
    }

    @ManagementProperty(name="local-transaction", use={ViewUse.RUNTIME}, readOnly=true)
    public Boolean getLocalTransactions() {
        return this.localTransactions;
    }

    public void setLocalTransactions(Boolean localTransactions) {
        this.localTransactions = localTransactions;
    }

    @ManagementProperty(name="use-strict-min", includeInTemplate=true)
    public Boolean getUseStrictMin() {
        return this.useStrictMin;
    }

    public void setUseStrictMin(Boolean useStrictMin) {
        this.useStrictMin = useStrictMin;
    }

    @ManagementProperty(name="statistics-formatter", includeInTemplate=true)
    public String getStatisticsFormatter() {
        return this.statisticsFormatter;
    }

    public void setStatisticsFormatter(String statisticsFormatter) {
        this.statisticsFormatter = statisticsFormatter;
    }

    @Override
    @ManagementProperty(name="no-tx-separate-pools", includeInTemplate=true)
    public Boolean getNoTxSeparatePools() {
        return this.noTxSeparatePools;
    }

    @Override
    public void setNoTxSeparatePools(Boolean notxpool) {
        this.noTxSeparatePools = notxpool;
    }

    @ManagementProperty(name="metadata", includeInTemplate=true)
    public DBMSMetaData getDBMSMetaData() {
        return this.dbmsMetaData;
    }

    public void setDBMSMetaData(DBMSMetaData dbmsMetaData) {
        this.dbmsMetaData = dbmsMetaData;
    }
}

