/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.auth;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.auth.XMLDocAuthenticator;
import org.apache.juddi.cryptor.Cryptor;
import org.apache.juddi.cryptor.CryptorFactory;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnknownUserException;

public class CryptedXMLDocAuthenticator
extends XMLDocAuthenticator {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$auth$CryptedXMLDocAuthenticator == null ? (class$org$apache$juddi$auth$CryptedXMLDocAuthenticator = CryptedXMLDocAuthenticator.class$("org.apache.juddi.auth.CryptedXMLDocAuthenticator")) : class$org$apache$juddi$auth$CryptedXMLDocAuthenticator));
    static /* synthetic */ Class class$org$apache$juddi$auth$CryptedXMLDocAuthenticator;

    public String authenticate(String userID, String credential) throws RegistryException {
        this.preProcess(userID, credential);
        String encryptedCredential = this.encrypt(credential);
        return this.postProcess(userID, encryptedCredential);
    }

    private String encrypt(String str) throws RegistryException {
        try {
            Cryptor cryptor = CryptorFactory.getCryptor();
            return cryptor.encrypt(str);
        }
        catch (InvalidKeyException e) {
            log.error((Object)"Invalid Key Exception in crypting the password", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            log.error((Object)"Padding Exception in crypting the password", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Algorithm Exception in crypting the password", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            log.error((Object)"Algorithm parameter Exception in crypting the password", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            log.error((Object)"Block size Exception in crypting the password", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
        catch (BadPaddingException e) {
            log.error((Object)"Bad Padding Exception in crypting the password", (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
    }

    private void preProcess(String userID, String credential) throws RegistryException {
        if (userID == null) {
            throw new UnknownUserException("Invalid user ID = " + userID);
        }
        if (credential == null) {
            throw new UnknownUserException("Invalid credentials");
        }
    }

    private String postProcess(String userID, String encryptedCredential) throws RegistryException {
        if (this.userTable.containsKey(userID)) {
            XMLDocAuthenticator.UserInfo userInfo = (XMLDocAuthenticator.UserInfo)this.userTable.get(userID);
            if (userInfo.password == null || !encryptedCredential.equals(userInfo.password)) {
                throw new UnknownUserException("Invalid credentials");
            }
        } else {
            throw new UnknownUserException("Invalid user ID: " + userID);
        }
        return userID;
    }

    public static void main(String[] args) throws Exception {
        CryptedXMLDocAuthenticator auth = new CryptedXMLDocAuthenticator();
        try {
            System.out.print("anou_mana/password: ");
            auth.authenticate("anou_mana", "password");
            System.out.println("successfully authenticated");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        try {
            System.out.print("anou_mana/badpass: ");
            auth.authenticate("anou_mana", "badpass");
            System.out.println("successfully authenticated");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        try {
            System.out.print("bozo/clown: ");
            auth.authenticate("bozo", "clown");
            System.out.println("successfully authenticated");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        try {
            System.out.print("sviens/password: ");
            auth.authenticate("sviens", "password");
            System.out.println("successfully authenticated");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

