/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.annotation;

import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javassist.CtMember;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.aop.util.UnmodifiableEmptyCollections;

public class AnnotationRepository {
    private static final String CLASS_ANNOTATION = "CLASS";
    protected Object lazyCollectionLock = new Object();
    volatile Map annotations = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    volatile Map classAnnotations = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
    volatile Map disabledAnnotations = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;

    public Map getAnnotations() {
        return this.annotations;
    }

    public Map getClassAnnotations() {
        return this.classAnnotations;
    }

    public void addClassAnnotation(String annotation, String value) {
        this.initClassAnnotationsMap();
        this.classAnnotations.put(annotation, value);
    }

    public void addClassAnnotation(Class annotation, Object value) {
        this.initClassAnnotationsMap();
        this.classAnnotations.put(annotation.getName(), value);
    }

    public Object resolveClassAnnotation(Class annotation) {
        Object value = this.classAnnotations.get(annotation.getName());
        boolean reinsert = value instanceof String;
        value = this.extractAnnotation(value, annotation);
        if (reinsert) {
            this.classAnnotations.put(annotation.getName(), value);
        }
        return value;
    }

    public Object resolveAnnotation(Member m, Class annotation) {
        Object value = this.resolveAnnotation(m, annotation.getName());
        boolean reinsert = value instanceof String;
        value = this.extractAnnotation(value, annotation);
        if (reinsert) {
            this.addAnnotation(m, annotation, value);
        }
        return value;
    }

    protected Object extractAnnotation(Object value, Class annotation) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String expr = (String)value;
            try {
                return AnnotationCreator.createAnnotation((String)expr, (Class)annotation);
            }
            catch (Exception e) {
                throw new RuntimeException("Bad annotation expression " + expr, e);
            }
        }
        return value;
    }

    protected Object resolveAnnotation(Member m, String annotation) {
        Map map = (Map)this.annotations.get(m);
        if (map != null) {
            return map.get(annotation);
        }
        return null;
    }

    public void disableAnnotation(Member m, String annotation) {
        ArrayList<String> annotationList = (ArrayList<String>)this.disabledAnnotations.get(m);
        if (annotationList == null) {
            annotationList = new ArrayList<String>();
            this.initDisabledAnnotationsMap();
            this.disabledAnnotations.put(m, annotationList);
        }
        annotationList.add(annotation);
    }

    public void disableAnnotation(String annotation) {
        ArrayList<String> annotationList = (ArrayList<String>)this.disabledAnnotations.get(CLASS_ANNOTATION);
        if (annotationList == null) {
            annotationList = new ArrayList<String>();
            this.initDisabledAnnotationsMap();
            this.disabledAnnotations.put(CLASS_ANNOTATION, annotationList);
        }
        annotationList.add(annotation);
    }

    public void enableAnnotation(String annotation) {
        List annotationList = (List)this.disabledAnnotations.get(CLASS_ANNOTATION);
        if (annotationList != null) {
            annotationList.remove(annotation);
        }
    }

    public boolean isDisabled(Member m, Class annotation) {
        return this.isDisabled(m, annotation.getName());
    }

    public boolean isDisabled(Member m, String annotation) {
        List overrideList = (List)this.disabledAnnotations.get(m);
        if (overrideList != null) {
            for (String override : overrideList) {
                if (!override.equals(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDisabled(Class annotation) {
        return this.isDisabled(annotation.getName());
    }

    public boolean isDisabled(String annotation) {
        List overrideList = (List)this.disabledAnnotations.get(CLASS_ANNOTATION);
        if (overrideList != null) {
            for (String override : overrideList) {
                if (!override.equals(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    public void addAnnotation(Member m, Class annotation, Object value) {
        HashMap<String, Object> map = (HashMap<String, Object>)this.annotations.get(m);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.initAnnotationsMap();
            this.annotations.put(m, map);
        }
        map.put(annotation.getName(), value);
    }

    public void addAnnotation(Member m, String annotation, Object value) {
        HashMap<String, Object> map = (HashMap<String, Object>)this.annotations.get(m);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.initAnnotationsMap();
            this.annotations.put(m, map);
        }
        map.put(annotation, value);
    }

    public boolean hasClassAnnotation(String annotation) {
        return this.classAnnotations.containsKey(annotation);
    }

    public boolean hasClassAnnotation(Class annotation) {
        return this.classAnnotations.containsKey(annotation.getName());
    }

    public boolean hasAnnotation(Member m, Class annotation) {
        return this.resolveAnnotation(m, annotation.getName()) != null;
    }

    public boolean hasAnnotation(Member m, String annotation) {
        return this.resolveAnnotation(m, annotation) != null;
    }

    public boolean hasAnnotation(CtMember m, String annotation) {
        Set set = (Set)this.annotations.get(m);
        if (set != null) {
            return set.contains(annotation);
        }
        return false;
    }

    public void addAnnotation(CtMember m, String annotation) {
        HashSet<String> set = (HashSet<String>)this.annotations.get(m);
        if (set == null) {
            set = new HashSet<String>();
            this.initAnnotationsMap();
            this.annotations.put(m, set);
        }
        set.add(annotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAnnotationsMap() {
        if (this.annotations == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.annotations == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.annotations = new ConcurrentHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initClassAnnotationsMap() {
        if (this.classAnnotations == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.classAnnotations == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.classAnnotations = new ConcurrentHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDisabledAnnotationsMap() {
        if (this.disabledAnnotations == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
            Object object = this.lazyCollectionLock;
            synchronized (object) {
                if (this.disabledAnnotations == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP) {
                    this.disabledAnnotations = new ConcurrentHashMap();
                }
            }
        }
    }
}

