/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.ClientProxyMethodHandler;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.Proxies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProxyProvider {
    private static final Function<Bean<Object>, Object> CREATE_CLIENT_PROXY = new Function<Bean<Object>, Object>(){

        public Object apply(Bean<Object> from) {
            String id = ((ContextualStore)Container.instance().services().get(ContextualStore.class)).putIfAbsent(from);
            if (id == null) {
                throw new DefinitionException(BeanMessage.BEAN_ID_CREATION_FAILED, from);
            }
            return ClientProxyProvider.createClientProxy(from, id);
        }
    };
    private final ConcurrentMap<Bean<Object>, Object> pool = new MapMaker().makeComputingMap(CREATE_CLIENT_PROXY);

    private static <T> T createClientProxy(Bean<T> bean, String id) throws RuntimeException {
        try {
            return Proxies.createProxy(new ClientProxyMethodHandler(bean, id), Proxies.TypeInfo.of(bean.getTypes()).add((Type)((Object)Serializable.class)));
        }
        catch (InstantiationException e) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_FAILED, (Throwable)e, bean);
        }
        catch (IllegalAccessException e) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_BEAN_ACCESS_FAILED, (Throwable)e, bean);
        }
    }

    public <T> T getClientProxy(Bean<T> bean) {
        return (T)this.pool.get(bean);
    }

    public String toString() {
        return "Proxy pool with " + this.pool.size() + " proxies";
    }

    public void clear() {
        this.pool.clear();
    }
}

