/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.Pipe;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.Option;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioXnio;
import org.jboss.xnio.nio.SelectorUtils;

final class NioPipeChannel
implements StreamChannel {
    private final Pipe.SourceChannel sourceChannel;
    private final Pipe.SinkChannel sinkChannel;
    private final NioHandle sourceHandle;
    private final NioHandle sinkHandle;
    private final NioXnio nioXnio;
    private final AtomicLong bytes;
    private final AtomicLong messages;
    private final Closeable mbeanHandle;
    private volatile ChannelListener<? super StreamChannel> readListener = null;
    private volatile ChannelListener<? super StreamChannel> writeListener = null;
    private volatile ChannelListener<? super StreamChannel> closeListener = null;
    private volatile int closeBits = 0;
    private static final AtomicReferenceFieldUpdater<NioPipeChannel, ChannelListener> readListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioPipeChannel.class, ChannelListener.class, "readListener");
    private static final AtomicReferenceFieldUpdater<NioPipeChannel, ChannelListener> writeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioPipeChannel.class, ChannelListener.class, "writeListener");
    private static final AtomicReferenceFieldUpdater<NioPipeChannel, ChannelListener> closeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioPipeChannel.class, ChannelListener.class, "closeListener");
    private static final AtomicIntegerFieldUpdater<NioPipeChannel> closeBitsUpdater = AtomicIntegerFieldUpdater.newUpdater(NioPipeChannel.class, "closeBits");
    private final ChannelListener.Setter<StreamChannel> readSetter = IoUtils.getSetter((Object)this, readListenerUpdater);
    private final ChannelListener.Setter<StreamChannel> writeSetter = IoUtils.getSetter((Object)this, writeListenerUpdater);
    private final ChannelListener.Setter<StreamChannel> closeSetter = IoUtils.getSetter((Object)this, closeListenerUpdater);

    private NioPipeChannel(Pipe.SourceChannel sourceChannel, Pipe.SinkChannel sinkChannel, NioXnio nioXnio, AtomicLong bytes, AtomicLong messages, Closeable mbeanHandle) throws IOException {
        this.sourceChannel = sourceChannel;
        this.sinkChannel = sinkChannel;
        this.nioXnio = nioXnio;
        this.bytes = bytes;
        this.messages = messages;
        this.mbeanHandle = mbeanHandle;
        this.sourceHandle = nioXnio.addReadHandler(sourceChannel, new ReadHandler());
        this.sinkHandle = nioXnio.addWriteHandler(sinkChannel, new WriteHandler());
    }

    static NioPipeChannel create(Pipe.SourceChannel sourceChannel, Pipe.SinkChannel sinkChannel, NioXnio nioXnio, AtomicLong bytes, AtomicLong messages, Closeable mbeanHandle) throws IOException {
        NioPipeChannel channel = new NioPipeChannel(sourceChannel, sinkChannel, nioXnio, bytes, messages, mbeanHandle);
        return channel;
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return target.transferFrom(this.sourceChannel, position, count);
    }

    public ChannelListener.Setter<StreamChannel> getReadSetter() {
        return this.readSetter;
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, this.sinkChannel);
    }

    public ChannelListener.Setter<StreamChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<StreamChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public boolean flush() throws IOException {
        return true;
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long ret = this.sinkChannel.write(srcs, offset, length);
        if (ret > 0L) {
            this.bytes.addAndGet(ret);
            this.messages.incrementAndGet();
        }
        return ret;
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        long ret = this.sinkChannel.write(srcs);
        if (ret > 0L) {
            this.bytes.addAndGet(ret);
            this.messages.incrementAndGet();
        }
        return ret;
    }

    public int write(ByteBuffer src) throws IOException {
        int ret = this.sinkChannel.write(src);
        if (ret > 0) {
            this.bytes.addAndGet(ret);
            this.messages.incrementAndGet();
        }
        return ret;
    }

    public boolean isOpen() {
        return this.sourceChannel.isOpen() && this.sinkChannel.isOpen();
    }

    private static int setBits(NioPipeChannel instance, int bits) {
        int old;
        int updated;
        while ((updated = (old = instance.closeBits) | bits) != old && !closeBitsUpdater.compareAndSet(instance, old, updated)) {
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        IoUtils.safeClose((Closeable)this.sourceChannel);
        try {
            this.sinkChannel.close();
        }
        finally {
            if (NioPipeChannel.setBits(this, 4) < 4) {
                this.nioXnio.removeManaged((Closeable)((Object)this));
                IoUtils.invokeChannelListener((Channel)((Object)this), this.closeListener);
                IoUtils.safeClose((Closeable)this.mbeanHandle);
            }
        }
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long ret = this.sourceChannel.read(dsts, offset, length);
        return ret;
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        long ret = this.sourceChannel.read(dsts);
        return ret;
    }

    public int read(ByteBuffer dst) throws IOException {
        int ret = this.sourceChannel.read(dst);
        return ret;
    }

    public void suspendReads() {
        try {
            this.sourceHandle.suspend();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void suspendWrites() {
        try {
            this.sinkHandle.suspend();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void resumeReads() {
        try {
            this.sourceHandle.resume(1);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void resumeWrites() {
        try {
            this.sinkHandle.resume(4);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownReads() throws IOException {
        boolean ok = false;
        try {
            this.sourceChannel.close();
            ok = true;
        }
        finally {
            if (NioPipeChannel.setBits(this, 2) == 3) {
                if (ok) {
                    this.close();
                } else {
                    IoUtils.safeClose((Closeable)((Object)this));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdownWrites() throws IOException {
        boolean ok = false;
        try {
            this.sinkChannel.close();
            ok = true;
        }
        finally {
            if (NioPipeChannel.setBits(this, 1) == 3) {
                if (ok) {
                    this.close();
                } else {
                    IoUtils.safeClose((Closeable)((Object)this));
                }
            }
        }
        return true;
    }

    public void awaitReadable() throws IOException {
        SelectorUtils.await(this.nioXnio, this.sourceChannel, 1);
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, this.sourceChannel, 1, time, timeUnit);
    }

    public void awaitWritable() throws IOException {
        SelectorUtils.await(this.nioXnio, this.sinkChannel, 4);
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, this.sinkChannel, 4, time, timeUnit);
    }

    public boolean supportsOption(Option<?> option) {
        return false;
    }

    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        return null;
    }

    public <T> NioPipeChannel setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this;
    }

    public String toString() {
        return String.format("pipe channel (NIO) <%s>", Integer.toString(this.hashCode(), 16));
    }

    private class WriteHandler
    implements Runnable {
        private WriteHandler() {
        }

        @Override
        public void run() {
            IoUtils.invokeChannelListener((Channel)((Object)NioPipeChannel.this), (ChannelListener)NioPipeChannel.this.writeListener);
        }
    }

    private class ReadHandler
    implements Runnable {
        private ReadHandler() {
        }

        @Override
        public void run() {
            IoUtils.invokeChannelListener((Channel)((Object)NioPipeChannel.this), (ChannelListener)NioPipeChannel.this.readListener);
        }
    }
}

