/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.recovery;

import com.arjuna.ats.jta.recovery.XAResourceRecovery;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.server.recovery.HornetQXAResourceWrapper;

public class HornetQXAResourceRecovery
implements XAResourceRecovery {
    private final boolean trace = log.isTraceEnabled();
    private static final Logger log = Logger.getLogger(HornetQXAResourceRecovery.class);
    private boolean hasMore;
    private HornetQXAResourceWrapper res;

    public HornetQXAResourceRecovery() {
        if (this.trace) {
            log.trace((Object)"Constructing HornetQXAResourceRecovery");
        }
    }

    public boolean initialise(String config) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " intialise: " + config));
        }
        ConfigParser parser = new ConfigParser(config);
        String connectorFactoryClassName = parser.getConnectorFactoryClassName();
        Map<String, Object> connectorParams = parser.getConnectorParameters();
        String username = parser.getUsername();
        String password = parser.getPassword();
        this.res = new HornetQXAResourceWrapper(connectorFactoryClassName, connectorParams, username, password);
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " initialised"));
        }
        return true;
    }

    public boolean hasMoreResources() {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " hasMoreResources"));
        }
        this.hasMore = !this.hasMore;
        return this.hasMore;
    }

    public XAResource getXAResource() {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " getXAResource"));
        }
        return this.res;
    }

    public XAResource[] getXAResources() {
        return new XAResource[]{this.res};
    }

    protected void finalize() {
        this.res.close();
    }

    public static class ConfigParser {
        private final String connectorFactoryClassName;
        private final Map<String, Object> connectorParameters;
        private String username;
        private String password;

        public ConfigParser(String config) {
            if (config == null || config.length() == 0) {
                throw new IllegalArgumentException("Must specify provider connector factory class name in config");
            }
            String[] strings = config.split(",");
            if (strings.length < 1) {
                throw new IllegalArgumentException("Must specify provider connector factory class name in config");
            }
            this.connectorFactoryClassName = strings[0].trim();
            if (strings.length >= 2) {
                this.username = strings[1].trim();
                if (this.username.length() == 0) {
                    this.username = null;
                }
                if (strings.length == 2) {
                    throw new IllegalArgumentException("If username is specified, password must be specified too");
                }
                this.password = strings[2].trim();
                if (this.password.length() == 0) {
                    this.password = null;
                }
            }
            this.connectorParameters = new HashMap<String, Object>();
            if (strings.length >= 3) {
                for (int i = 3; i < strings.length; ++i) {
                    String[] str = strings[i].split("=");
                    if (str.length != 2) continue;
                    this.connectorParameters.put(str[0].trim(), str[1].trim());
                }
            }
        }

        public String getConnectorFactoryClassName() {
            return this.connectorFactoryClassName;
        }

        public Map<String, Object> getConnectorParameters() {
            return this.connectorParameters;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

