/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jmx;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXDiscoveryComponent
implements ResourceDiscoveryComponent,
ManualAddFacet {
    private static final Log log = LogFactory.getLog(JMXDiscoveryComponent.class);
    public static final String VMID_CONFIG_PROPERTY = "vmid";
    public static final String COMMAND_LINE_CONFIG_PROPERTY = "commandLine";
    public static final String CONNECTOR_ADDRESS_CONFIG_PROPERTY = "connectorAddress";
    public static final String INSTALL_URI = "installURI";
    public static final String CONNECTION_TYPE = "type";
    public static final String PARENT_TYPE = "PARENT";
    public static final String ADDITIONAL_CLASSPATH_ENTRIES = "additionalClassPathEntries";
    private static final String[] PROCESS_FILTERS;

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        HashSet<DiscoveredResourceDetails> found = new HashSet<DiscoveredResourceDetails>();
        try {
            List processes = context.getSystemInformation().getProcesses("process|basename|match=^java.*");
            for (ProcessInfo process : processes) {
                DiscoveredResourceDetails details = this.discoverProcess(context, process);
                if (details == null) continue;
                boolean isFiltered = false;
                for (String filter : PROCESS_FILTERS) {
                    if (!details.getResourceName().contains(filter)) continue;
                    isFiltered = true;
                    break;
                }
                if (isFiltered) continue;
                found.add(details);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to complete base jmx server discovery.", (Throwable)e);
            }
            log.warn((Object)("Unable to complete base jmx server discovery (enable DEBUG for stack): " + e));
        }
        return found;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext discoveryContext) throws InvalidPluginConfigurationException {
        String resourceKey = pluginConfig.getSimpleValue(CONNECTOR_ADDRESS_CONFIG_PROPERTY, null);
        String connectionType = pluginConfig.getSimpleValue(CONNECTION_TYPE, null);
        String version = null;
        DiscoveredResourceDetails resourceDetails = new DiscoveredResourceDetails(discoveryContext.getResourceType(), resourceKey, "Java VM", version, connectionType + " [" + resourceKey + "]", pluginConfig, null);
        return resourceDetails;
    }

    public List<URL> getAdditionalClasspathUrls(ResourceDiscoveryContext context, DiscoveredResourceDetails details) throws Exception {
        List<File> jars = JMXDiscoveryComponent.getAdditionalJarsFromConfig(details.getPluginConfiguration());
        if (jars == null || jars.size() == 0) {
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>(jars.size());
        for (File jar : jars) {
            urls.add(jar.toURI().toURL());
        }
        return urls;
    }

    protected DiscoveredResourceDetails discoverProcess(ResourceDiscoveryContext context, ProcessInfo process) {
        String portProp = "com.sun.management.jmxremote.port";
        String port = null;
        for (String argument : process.getCommandLine()) {
            String cmdLineArg = "-D" + portProp + "=";
            if (!argument.startsWith(cmdLineArg)) continue;
            port = argument.substring(cmdLineArg.length());
            break;
        }
        if (port == null) {
            port = process.getEnvironmentVariable(portProp);
        }
        DiscoveredResourceDetails details = null;
        if (port != null) {
            String name = "JMX Server";
            for (int i = 1; i < process.getCommandLine().length; ++i) {
                String arg = process.getCommandLine()[i];
                if (!arg.startsWith("-")) {
                    if (arg.length() >= 200) continue;
                    name = arg;
                    break;
                }
                if (!arg.equals("-cp") && !arg.equals("-classpath")) continue;
                ++i;
            }
            name = name + " (" + port + ")";
            Configuration config = context.getDefaultPluginConfiguration();
            config.put((Property)new PropertySimple(CONNECTION_TYPE, (Object)"org.mc4j.ems.connection.support.metadata.J2SE5ConnectionTypeDescriptor"));
            config.put((Property)new PropertySimple(CONNECTOR_ADDRESS_CONFIG_PROPERTY, (Object)("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/jmxrmi")));
            String version = null;
            details = new DiscoveredResourceDetails(context.getResourceType(), port, name, version, "Standalone JVM Process", config, null);
        }
        return details;
    }

    static List<File> getAdditionalJarsFromConfig(Configuration pluginConfiguration) {
        ArrayList<File> jarFiles = new ArrayList<File>();
        PropertySimple prop = pluginConfiguration.getSimple(ADDITIONAL_CLASSPATH_ENTRIES);
        if (prop == null || prop.getStringValue() == null || prop.getStringValue().trim().length() == 0) {
            return jarFiles;
        }
        String[] paths = prop.getStringValue().trim().split(",");
        if (paths == null || paths.length == 0) {
            return jarFiles;
        }
        for (String path : paths) {
            if ((path = path.trim()).length() <= 0) continue;
            if (path.endsWith("*.jar")) {
                File dir = new File(path = path.substring(0, path.length() - 5));
                final class JarFilenameFilter
                implements FilenameFilter {
                    JarFilenameFilter() {
                    }

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar");
                    }
                }
                File[] jars = dir.listFiles(new JarFilenameFilter());
                if (jars == null || jars.length <= 0) continue;
                jarFiles.addAll(Arrays.asList(jars));
                continue;
            }
            File pathFile = new File(path);
            jarFiles.add(pathFile);
        }
        return jarFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String[] processFilters = new String[]{"catalina.startup.Bootstrap", "org.jboss.Main"};
        try {
            String env = System.getProperty("rhq.jmxplugin.process-filters");
            if (env != null) {
                processFilters = env.split(",");
            }
        }
        catch (Throwable t) {
            log.error((Object)("Can't determine process filters, using default. Cause: " + t));
        }
        finally {
            PROCESS_FILTERS = processFilters;
        }
    }
}

