/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.catalina;

import java.util.Arrays;
import java.util.Iterator;
import javax.management.MBeanServer;
import org.apache.catalina.Service;
import org.apache.tomcat.util.IntrospectionUtils;
import org.jboss.modcluster.Engine;
import org.jboss.modcluster.Server;
import org.jboss.modcluster.catalina.CatalinaEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalinaServer
implements Server {
    private final org.apache.catalina.Server server;
    private final MBeanServer mbeanServer;

    public CatalinaServer(org.apache.catalina.Server server, MBeanServer mbeanServer) {
        this.server = server;
        this.mbeanServer = mbeanServer;
    }

    @Override
    public Iterable<Engine> getEngines() {
        final Iterator<Service> services = Arrays.asList(this.server.findServices()).iterator();
        final Iterator<Engine> engines = new Iterator<Engine>(){

            @Override
            public boolean hasNext() {
                return services.hasNext();
            }

            @Override
            public Engine next() {
                return new CatalinaEngine((org.apache.catalina.Engine)((Service)services.next()).getContainer(), CatalinaServer.this);
            }

            @Override
            public void remove() {
                services.remove();
            }
        };
        return new Iterable<Engine>(){

            @Override
            public Iterator<Engine> iterator() {
                return engines;
            }
        };
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    @Override
    public String getDomain() {
        String domain = (String)IntrospectionUtils.getProperty((Object)this.server, (String)"domain");
        return domain != null ? domain : this.mbeanServer.getDefaultDomain();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CatalinaServer)) {
            return false;
        }
        CatalinaServer server = (CatalinaServer)object;
        return this.server == server.server;
    }

    public int hashCode() {
        return this.server.hashCode();
    }

    public String toString() {
        return this.server.getClass().getName();
    }
}

