/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.mcmp.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.SocketFactory;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jboss.logging.Logger;
import org.jboss.modcluster.Strings;
import org.jboss.modcluster.config.MCMPHandlerConfiguration;
import org.jboss.modcluster.mcmp.MCMPConnectionListener;
import org.jboss.modcluster.mcmp.MCMPHandler;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPRequestFactory;
import org.jboss.modcluster.mcmp.MCMPResponseParser;
import org.jboss.modcluster.mcmp.MCMPServer;
import org.jboss.modcluster.mcmp.MCMPServerState;
import org.jboss.modcluster.mcmp.ResetRequestSource;
import org.jboss.modcluster.mcmp.impl.JSSESocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DefaultMCMPHandler
implements MCMPHandler {
    private static final String NEW_LINE = "\r\n";
    protected static final Logger log = Logger.getLogger(DefaultMCMPHandler.class);
    private final MCMPHandlerConfiguration config;
    private final ResetRequestSource resetRequestSource;
    private final MCMPRequestFactory requestFactory;
    private final MCMPResponseParser responseParser;
    private final ReadWriteLock proxiesLock = new ReentrantReadWriteLock();
    private final Lock addRemoveProxiesLock = new ReentrantLock();
    @GuardedBy(value="proxiesLock")
    private final List<Proxy> proxies = new ArrayList<Proxy>();
    @GuardedBy(value="addRemoveProxiesLock")
    private final List<Proxy> addProxies = new ArrayList<Proxy>();
    @GuardedBy(value="addRemoveProxiesLock")
    private final List<Proxy> removeProxies = new ArrayList<Proxy>();
    private final AtomicBoolean established = new AtomicBoolean(false);
    private volatile MCMPConnectionListener connectionListener;
    private volatile boolean init = false;

    public DefaultMCMPHandler(MCMPHandlerConfiguration config, ResetRequestSource source, MCMPRequestFactory requestFactory, MCMPResponseParser responseParser) {
        this.resetRequestSource = source;
        this.config = config;
        this.requestFactory = requestFactory;
        this.responseParser = responseParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(List<InetSocketAddress> initialProxies, MCMPConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
        if (initialProxies != null) {
            Lock lock = this.proxiesLock.writeLock();
            lock.lock();
            try {
                for (InetSocketAddress initialProxy : initialProxies) {
                    this.add(initialProxy);
                }
                this.status(false);
            }
            finally {
                lock.unlock();
            }
        }
        this.init = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.init = false;
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                proxy.closeConnection();
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void addProxy(InetSocketAddress socketAddress) {
        this.add(socketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Proxy add(InetSocketAddress socketAddress) {
        Proxy proxy = new Proxy(socketAddress, this.config);
        this.addRemoveProxiesLock.lock();
        try {
            Lock lock = this.proxiesLock.readLock();
            lock.lock();
            try {
                Iterator<Proxy> i$ = this.proxies.iterator();
                while (true) {
                    if (i$.hasNext()) {
                        Proxy candidate = i$.next();
                        if (!candidate.equals(proxy)) continue;
                        Proxy proxy2 = candidate;
                        return proxy2;
                        continue;
                    }
                    break;
                }
            }
            finally {
                lock.unlock();
            }
            for (Proxy candidate : this.addProxies) {
                if (!candidate.equals(proxy)) continue;
                Proxy proxy3 = candidate;
                return proxy3;
            }
            for (Proxy candidate : this.removeProxies) {
                if (!candidate.equals(proxy)) continue;
                Proxy proxy4 = candidate;
                return proxy4;
            }
            proxy.setState(MCMPServerState.State.ERROR);
            this.addProxies.add(proxy);
        }
        finally {
            this.addRemoveProxiesLock.unlock();
        }
        return proxy;
    }

    @Override
    public void addProxy(InetSocketAddress socketAddress, boolean established) {
        this.add(socketAddress).setEstablished(established);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProxy(InetSocketAddress socketAddress) {
        Proxy proxy = new Proxy(socketAddress, this.config);
        this.addRemoveProxiesLock.lock();
        try {
            this.removeProxies.add(proxy);
        }
        finally {
            this.addRemoveProxiesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<MCMPServerState> getProxyStates() {
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            if (this.proxies.isEmpty()) {
                Set<MCMPServerState> set = Collections.emptySet();
                return set;
            }
            LinkedHashSet<MCMPServerState> result = new LinkedHashSet<MCMPServerState>(this.proxies.size());
            for (Proxy proxy : this.proxies) {
                result.add(proxy);
            }
            LinkedHashSet<MCMPServerState> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProxyHealthOK() {
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                if (proxy.getState() == MCMPServerState.State.OK) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markProxiesInError() {
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                if (proxy.getState() != MCMPServerState.State.OK) continue;
                proxy.setState(MCMPServerState.State.ERROR);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                if (proxy.getState() != MCMPServerState.State.DOWN) continue;
                proxy.setState(MCMPServerState.State.ERROR);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public synchronized void status() {
        if (this.init) {
            this.processPendingDiscoveryEvents();
            this.status(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void status(boolean sendResetRequests) {
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                if (proxy.getState() != MCMPServerState.State.ERROR) continue;
                proxy.setState(MCMPServerState.State.OK);
                String response = this.sendRequest(this.requestFactory.createInfoRequest(), proxy);
                if (proxy.getState() != MCMPServerState.State.OK) continue;
                if (this.established.compareAndSet(false, true)) {
                    this.connectionListener.connectionEstablished(proxy.getLocalAddress());
                }
                if (!sendResetRequests) continue;
                Map<String, Set<ResetRequestSource.VirtualHost>> parsedResponse = this.responseParser.parseInfoResponse(response);
                List<MCMPRequest> requests = this.resetRequestSource.getResetRequests(parsedResponse);
                log.trace(requests);
                this.sendRequests(requests);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<MCMPServerState, String> sendRequest(MCMPRequest request) {
        HashMap<MCMPServerState, String> map = new HashMap<MCMPServerState, String>();
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                map.put(proxy, this.sendRequest(request, proxy));
            }
        }
        finally {
            lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<MCMPServerState, List<String>> sendRequests(List<MCMPRequest> requests) {
        HashMap<MCMPServerState, List<String>> map = new HashMap<MCMPServerState, List<String>>();
        Lock lock = this.proxiesLock.readLock();
        lock.lock();
        try {
            for (Proxy proxy : this.proxies) {
                ArrayList<String> list = new ArrayList<String>(requests.size());
                for (MCMPRequest request : requests) {
                    list.add(this.sendRequest(request, proxy));
                }
                map.put(proxy, list);
            }
        }
        finally {
            lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingDiscoveryEvents() {
        block7: {
            this.addRemoveProxiesLock.lock();
            try {
                if (this.addProxies.isEmpty() && this.removeProxies.isEmpty()) break block7;
                Lock lock = this.proxiesLock.writeLock();
                lock.lock();
                try {
                    this.proxies.addAll(this.addProxies);
                    this.proxies.removeAll(this.removeProxies);
                    this.addProxies.clear();
                    this.removeProxies.clear();
                    for (Proxy proxy : this.proxies) {
                        proxy.closeConnection();
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            finally {
                this.addRemoveProxiesLock.unlock();
            }
        }
    }

    private String sendRequest(Proxy proxy, String command, String body) throws IOException {
        BufferedWriter writer = proxy.getConnectionWriter();
        writer.append(command).append(NEW_LINE);
        writer.append("Content-Length: ").append(String.valueOf(body.length())).append(NEW_LINE);
        writer.append("User-Agent: ClusterListener/1.0").append(NEW_LINE);
        writer.append("Connection: Keep-Alive").append(NEW_LINE);
        writer.write(NEW_LINE);
        writer.write(body);
        writer.write(NEW_LINE);
        ((Writer)writer).flush();
        return proxy.getConnectionReader().readLine();
    }

    private void appendParameter(Appendable appender, String name, String value, boolean more) throws IOException {
        appender.append(URLEncoder.encode(name, "UTF-8")).append('=').append(URLEncoder.encode(value, "UTF-8"));
        if (more) {
            appender.append('&');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String sendRequest(MCMPRequest request, Proxy proxy) {
        if (proxy.getState() != MCMPServerState.State.OK) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)Strings.REQUEST_SEND.getString(request, proxy));
        }
        String command = request.getRequestType().getCommand();
        boolean wildcard = request.isWildcard();
        String jvmRoute = request.getJvmRoute();
        Map<String, String> parameters = request.getParameters();
        StringBuilder bodyBuilder = new StringBuilder();
        try {
            if (jvmRoute != null) {
                this.appendParameter(bodyBuilder, "JVMRoute", jvmRoute, !parameters.isEmpty());
            }
            Iterator<Map.Entry<String, String>> entries = parameters.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<String, String> entry = entries.next();
                this.appendParameter(bodyBuilder, entry.getKey(), entry.getValue(), entries.hasNext());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        StringBuilder headBuilder = new StringBuilder();
        headBuilder.append(command).append(" ");
        String proxyURL = this.config.getProxyURL();
        if (proxyURL != null) {
            headBuilder.append(proxyURL);
        }
        if (headBuilder.charAt(headBuilder.length() - 1) != '/') {
            headBuilder.append('/');
        }
        if (wildcard) {
            headBuilder.append('*');
        }
        headBuilder.append(" HTTP/1.0");
        String head = headBuilder.toString();
        String body = bodyBuilder.toString();
        Proxy proxy2 = proxy;
        synchronized (proxy2) {
            try {
                int bytes;
                String line = null;
                try {
                    line = this.sendRequest(proxy, head, body);
                }
                catch (IOException e2) {
                    // empty catch block
                }
                if (line == null) {
                    proxy.closeConnection();
                    line = this.sendRequest(proxy, head, body);
                }
                BufferedReader reader = proxy.getConnectionReader();
                int status = 500;
                String message = null;
                String errorType = null;
                int contentLength = 0;
                boolean close = false;
                if (line != null) {
                    try {
                        int spaceIndex = line.indexOf(32);
                        String responseStatus = line.substring(spaceIndex + 1, line.indexOf(32, spaceIndex + 1));
                        status = Integer.parseInt(responseStatus);
                        line = reader.readLine();
                        while (line != null && line.length() > 0) {
                            int colon = line.indexOf(58);
                            String headerName = line.substring(0, colon).trim();
                            String headerValue = line.substring(colon + 1).trim();
                            if (!"version".equalsIgnoreCase(headerName)) {
                                if ("type".equalsIgnoreCase(headerName)) {
                                    errorType = headerValue;
                                } else if ("mess".equalsIgnoreCase(headerName)) {
                                    message = headerValue;
                                } else if ("content-length".equalsIgnoreCase(headerName)) {
                                    contentLength = Integer.parseInt(headerValue);
                                } else if ("connection".equalsIgnoreCase(headerName)) {
                                    close = "close".equalsIgnoreCase(headerValue);
                                }
                            }
                            line = reader.readLine();
                        }
                    }
                    catch (Exception e322) {
                        log.info((Object)Strings.ERROR_HEADER_PARSE.getString(command), (Throwable)e322);
                    }
                }
                if (status == 200) {
                    if (request.getRequestType().getEstablishesServer()) {
                        proxy.setEstablished(true);
                    }
                } else if ("SYNTAX".equals(errorType)) {
                    proxy.setState(MCMPServerState.State.DOWN);
                    log.error((Object)Strings.ERROR_REQUEST_SYNTAX.getString(command, proxy, errorType, message));
                } else {
                    proxy.setState(MCMPServerState.State.ERROR);
                    log.error((Object)Strings.ERROR_REQUEST_SEND_OTHER.getString(command, proxy, errorType, message));
                }
                if (close) {
                    contentLength = Integer.MAX_VALUE;
                } else if (contentLength == 0) {
                    String e322 = null;
                    return e322;
                }
                StringBuilder result = new StringBuilder();
                char[] buffer = new char[512];
                while (contentLength > 0 && (bytes = reader.read(buffer, 0, contentLength > buffer.length ? buffer.length : contentLength)) > 0) {
                    result.append(buffer, 0, bytes);
                    contentLength -= bytes;
                }
                if (proxy.getState() == MCMPServerState.State.OK) {
                    proxy.setIoExceptionLogged(false);
                }
                String string = result.toString();
                return string;
            }
            catch (IOException e) {
                proxy.setState(MCMPServerState.State.ERROR);
                if (!proxy.isIoExceptionLogged()) {
                    log.info((Object)Strings.ERROR_REQUEST_SEND_IO.getString(command, proxy), (Throwable)e);
                    proxy.setIoExceptionLogged(true);
                }
                String string2 = null;
                return string2;
            }
            finally {
                if (proxy.getState() != MCMPServerState.State.OK) {
                    proxy.closeConnection();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VirtualHostImpl
    implements ResetRequestSource.VirtualHost,
    Externalizable {
        private final Set<String> aliases = new LinkedHashSet<String>();
        private final Map<String, ResetRequestSource.Status> contexts = new HashMap<String, ResetRequestSource.Status>();

        @Override
        public Set<String> getAliases() {
            return this.aliases;
        }

        @Override
        public Map<String, ResetRequestSource.Status> getContexts() {
            return this.contexts;
        }

        @Override
        public void readExternal(ObjectInput input) throws IOException {
            int aliases = input.readInt();
            for (int i = 0; i < aliases; ++i) {
                this.aliases.add(input.readUTF());
            }
            ResetRequestSource.Status[] stati = ResetRequestSource.Status.values();
            int contexts = input.readInt();
            for (int i = 0; i < contexts; ++i) {
                this.contexts.put(input.readUTF(), stati[input.readInt()]);
            }
        }

        @Override
        public void writeExternal(ObjectOutput output) throws IOException {
            output.writeInt(this.aliases.size());
            for (String string : this.aliases) {
                output.writeUTF(string);
            }
            output.writeInt(this.contexts.size());
            for (Map.Entry entry : this.contexts.entrySet()) {
                output.writeUTF((String)entry.getKey());
                output.writeInt(((ResetRequestSource.Status)((Object)entry.getValue())).ordinal());
            }
        }
    }

    @ThreadSafe
    private static class Proxy
    implements MCMPServerState,
    Serializable {
        private static final long serialVersionUID = 5219680414337319908L;
        private final InetSocketAddress socketAddress;
        private volatile MCMPServerState.State state = MCMPServerState.State.OK;
        private volatile boolean established = false;
        private final transient int socketTimeout;
        private final transient SocketFactory socketFactory;
        private volatile transient boolean ioExceptionLogged = false;
        private volatile transient InetAddress localAddress = null;
        @GuardedBy(value="Proxy.this")
        private volatile transient Socket socket = null;
        @GuardedBy(value="Proxy.this")
        private volatile transient BufferedReader reader = null;
        @GuardedBy(value="Proxy.this")
        private volatile transient BufferedWriter writer = null;

        Proxy(InetSocketAddress socketAddress, MCMPHandlerConfiguration config) {
            this.socketAddress = socketAddress;
            this.socketFactory = config.isSsl() ? new JSSESocketFactory(config) : SocketFactory.getDefault();
            this.socketTimeout = config.getSocketTimeout();
        }

        public MCMPServerState.State getState() {
            return this.state;
        }

        public InetSocketAddress getSocketAddress() {
            return this.socketAddress;
        }

        public boolean isEstablished() {
            return this.established;
        }

        public String toString() {
            return this.socketAddress.toString();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof MCMPServer)) {
                return false;
            }
            MCMPServer proxy = (MCMPServer)object;
            return this.socketAddress.equals(proxy.getSocketAddress());
        }

        public int hashCode() {
            return this.socketAddress.hashCode();
        }

        void setState(MCMPServerState.State state) {
            if (state == null) {
                throw new IllegalArgumentException(Strings.ERROR_ARGUMENT_NULL.getString("state"));
            }
            this.state = state;
        }

        void setEstablished(boolean established) {
            this.established = established;
        }

        private synchronized Socket getConnection() throws IOException {
            if (this.socket == null || this.socket.isClosed()) {
                this.socket = this.socketFactory.createSocket(this.socketAddress.getAddress(), this.socketAddress.getPort());
                this.socket.setSoTimeout(this.socketTimeout);
                this.localAddress = this.socket.getLocalAddress();
            }
            return this.socket;
        }

        synchronized BufferedReader getConnectionReader() throws IOException {
            if (this.reader == null) {
                this.reader = new BufferedReader(new InputStreamReader(this.getConnection().getInputStream()));
            }
            return this.reader;
        }

        synchronized BufferedWriter getConnectionWriter() throws IOException {
            if (this.writer == null) {
                this.writer = new BufferedWriter(new OutputStreamWriter(this.getConnection().getOutputStream()));
            }
            return this.writer;
        }

        InetAddress getLocalAddress() {
            return this.localAddress;
        }

        synchronized void closeConnection() {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.reader = null;
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.writer = null;
            }
            if (this.socket != null) {
                if (!this.socket.isClosed()) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.socket = null;
            }
        }

        boolean isIoExceptionLogged() {
            return this.ioExceptionLogged;
        }

        void setIoExceptionLogged(boolean ioErrorLogged) {
            this.ioExceptionLogged = ioErrorLogged;
        }
    }
}

