/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.jsf;

import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.jboss.weld.exceptions.ForbiddenStateException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.JsfMessage;
import org.jboss.weld.servlet.BeanProvider;
import org.slf4j.cal10n.LocLogger;

public class JsfHelper {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.JSF);

    public static String getConversationIdFromRequest(FacesContext facesContext) {
        String cidName = BeanProvider.conversationIdName(JsfHelper.getServletContext(facesContext));
        String cid = (String)facesContext.getExternalContext().getRequestParameterMap().get(cidName);
        log.trace((Enum)JsfMessage.FOUND_CONVERSATION_FROM_REQUEST, new Object[]{cid});
        return cid;
    }

    public static String getConversationId(FacesContext facesContext) {
        String cid = JsfHelper.getConversationIdFromRequest(facesContext);
        log.debug((Enum)JsfMessage.RESUMING_CONVERSATION, new Object[]{cid});
        return cid;
    }

    public static HttpSession getHttpSession(FacesContext facesContext) {
        Object session = facesContext.getExternalContext().getSession(true);
        if (session instanceof HttpSession) {
            return (HttpSession)session;
        }
        return null;
    }

    public static ServletContext getServletContext(FacesContext facesContext) {
        if (facesContext.getExternalContext().getContext() instanceof ServletContext) {
            return (ServletContext)facesContext.getExternalContext().getContext();
        }
        throw new ForbiddenStateException(JsfMessage.IMPROPER_ENVIRONMENT, new Object[0]);
    }
}

