/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.exceptions.ForbiddenArgumentException;
import org.jboss.weld.exceptions.InvalidOperationException;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.WeldAnnotated;
import org.jboss.weld.introspector.jlr.AbstractWeldAnnotated;
import org.jboss.weld.logging.messages.ResolutionMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.util.Names;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvableWeldClass<T>
extends AbstractWeldAnnotated<T, Class<T>>
implements Resolvable {
    private final Class<T> rawType;
    private final Set<Type> typeClosure;
    private final Type[] actualTypeArguments;

    public static <T> WeldAnnotated<T, Class<T>> of(TypeLiteral<T> typeLiteral, Annotation[] annotations, BeanManagerImpl manager) {
        return new ResolvableWeldClass<T>(typeLiteral.getType(), annotations, manager);
    }

    public static <T> WeldAnnotated<T, Class<T>> of(Type type, Annotation[] annotations, BeanManagerImpl manager) {
        return new ResolvableWeldClass<T>(type, annotations, manager);
    }

    public static <T> WeldAnnotated<T, Class<T>> of(InjectionPoint injectionPoint, BeanManagerImpl manager) {
        if (injectionPoint instanceof WeldInjectionPoint) {
            WeldAnnotated ip = (WeldAnnotated)injectionPoint;
            return ip;
        }
        return new ResolvableWeldClass<T>(injectionPoint.getType(), injectionPoint.getAnnotated().getAnnotations(), manager);
    }

    public static <T> WeldAnnotated<T, Class<T>> of(Member member, Annotation[] annotations, BeanManagerImpl manager) {
        if (member instanceof Field) {
            return new ResolvableWeldClass<T>(((Field)member).getGenericType(), annotations, manager);
        }
        if (member instanceof Method) {
            return new ResolvableWeldClass<T>(((Method)member).getGenericReturnType(), annotations, manager);
        }
        throw new ForbiddenArgumentException(ResolutionMessage.INVALID_MEMBER_TYPE, member);
    }

    private ResolvableWeldClass(Type type, Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, BeanManagerImpl manager) {
        super(annotationMap, declaredAnnotationMap, (TypeStore)manager.getServices().get(TypeStore.class));
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (!(parameterizedType.getRawType() instanceof Class)) {
                throw new ForbiddenArgumentException(ResolutionMessage.CANNOT_EXTRACT_RAW_TYPE, type);
            }
            this.rawType = (Class)parameterizedType.getRawType();
            this.actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
        } else if (type instanceof Class) {
            this.rawType = (Class)type;
            this.actualTypeArguments = new Type[0];
        } else {
            throw new ForbiddenArgumentException(ResolutionMessage.CANNOT_EXTRACT_TYPE_INFORMATION, type);
        }
        this.typeClosure = new HashSet<Type>();
        this.typeClosure.add(type);
    }

    private ResolvableWeldClass(Type type, Annotation[] annotations, BeanManagerImpl manager) {
        this(type, ResolvableWeldClass.buildAnnotationMap(annotations), ResolvableWeldClass.buildAnnotationMap(Reflections.EMPTY_ANNOTATIONS), manager);
    }

    private ResolvableWeldClass(Type type, Set<Annotation> annotations, BeanManagerImpl manager) {
        this(type, ResolvableWeldClass.buildAnnotationMap(annotations), ResolvableWeldClass.buildAnnotationMap(Reflections.EMPTY_ANNOTATIONS), manager);
    }

    public String toString() {
        return Names.toString(this.getJavaClass(), this.getAnnotations(), this.getActualTypeArguments());
    }

    @Override
    public Class<T> getDelegate() {
        return this.rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public String getName() {
        throw new InvalidOperationException();
    }

    @Override
    public Class<T> getJavaClass() {
        return this.rawType;
    }

    @Override
    public boolean isFinal() {
        throw new InvalidOperationException();
    }

    @Override
    public boolean isPublic() {
        throw new InvalidOperationException();
    }

    @Override
    public boolean isPrivate() {
        throw new InvalidOperationException();
    }

    @Override
    public boolean isPackagePrivate() {
        throw new InvalidOperationException();
    }

    @Override
    public Package getPackage() {
        throw new InvalidOperationException();
    }

    @Override
    public boolean isStatic() {
        throw new InvalidOperationException();
    }

    @Override
    public boolean isProxyable() {
        throw new InvalidOperationException();
    }

    @Override
    public Set<Type> getTypeClosure() {
        return this.typeClosure;
    }

    @Override
    public AbstractClassBean<?> getDeclaringBean() {
        return null;
    }

    @Override
    public Type getBaseType() {
        return this.getJavaClass();
    }

    @Override
    public boolean isAssignableTo(Class<?> clazz) {
        return Reflections.isAssignableFrom(clazz, this.getBaseType());
    }
}

