/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.jboss.weld.exceptions.ForbiddenArgumentException;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.util.CleanableMethodHandler;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Proxies {
    private static final String DEFAULT_INTERCEPTOR = "default_interceptor";

    public static <T> T createProxy(MethodHandler methodHandler, TypeInfo typeInfo) throws IllegalAccessException, InstantiationException {
        return SecureReflections.newInstance(Proxies.createProxyClass(methodHandler, typeInfo));
    }

    public static <T> Class<T> createProxyClass(TypeInfo typeInfo) {
        return Proxies.createProxyClass(null, typeInfo);
    }

    public static <T> Class<T> createProxyClass(MethodHandler methodHandler, TypeInfo typeInfo) {
        ProxyFactory proxyFactory = typeInfo.createProxyFactory();
        Proxies.attachMethodHandler(proxyFactory, methodHandler);
        Class clazz = proxyFactory.createClass();
        return clazz;
    }

    public static boolean isTypeProxyable(Type type) {
        Type rawType;
        if (type instanceof Class) {
            return Proxies.isClassProxyable((Class)type);
        }
        if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
            return Proxies.isClassProxyable((Class)rawType);
        }
        return false;
    }

    public static boolean isTypesProxyable(Iterable<? extends Type> types) {
        for (Type type : types) {
            if (Object.class.equals((Object)type) || Proxies.isTypeProxyable(type)) continue;
            return false;
        }
        return true;
    }

    private static boolean isClassProxyable(Class<?> clazz) {
        if (clazz.isInterface()) {
            return true;
        }
        Constructor<?> constructor = null;
        try {
            constructor = SecureReflections.getDeclaredConstructor(clazz, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        if (constructor == null) {
            return false;
        }
        if (Modifier.isPrivate(constructor.getModifiers())) {
            return false;
        }
        if (Reflections.isTypeOrAnyMethodFinal(clazz)) {
            return false;
        }
        if (clazz.isPrimitive()) {
            return false;
        }
        return !Reflections.isArrayType(clazz);
    }

    public static ProxyFactory attachMethodHandler(ProxyFactory proxyFactory, MethodHandler methodHandler) {
        if (methodHandler != null) {
            proxyFactory.setHandler((MethodHandler)new CleanableMethodHandler(methodHandler));
        }
        return proxyFactory;
    }

    public static <T> T attachMethodHandler(T instance, MethodHandler methodHandler) {
        if (instance instanceof ProxyObject) {
            if (methodHandler != null) {
                ((ProxyObject)instance).setHandler((MethodHandler)new CleanableMethodHandler(methodHandler));
            }
            return instance;
        }
        throw new ForbiddenArgumentException(UtilMessage.INSTANCE_NOT_A_PROXY, instance);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeInfo {
        private final Set<Class<?>> interfaces = new LinkedHashSet();
        private final Set<Class<?>> classes = new LinkedHashSet();

        private TypeInfo() {
        }

        public Class<?> getSuperClass() {
            if (this.classes.isEmpty()) {
                return null;
            }
            Iterator<Class<?>> it = this.classes.iterator();
            Class<?> superclass = it.next();
            while (it.hasNext()) {
                Class<?> clazz = it.next();
                if (!superclass.isAssignableFrom(clazz)) continue;
                superclass = clazz;
            }
            return superclass;
        }

        private Class<?>[] getInterfaces() {
            return this.interfaces.toArray(Reflections.EMPTY_CLASSES);
        }

        public ProxyFactory createProxyFactory() {
            ProxyFactory proxyFactory = new ProxyFactory();
            Class<?> superClass = this.getSuperClass();
            if (superClass != null && superClass != Object.class) {
                proxyFactory.setSuperclass(superClass);
            }
            proxyFactory.setInterfaces((Class[])this.getInterfaces());
            return proxyFactory;
        }

        public TypeInfo add(Type type) {
            if (type instanceof Class) {
                Class clazz = (Class)type;
                if (clazz.isInterface()) {
                    this.interfaces.add(clazz);
                } else {
                    this.classes.add(clazz);
                }
            } else if (type instanceof ParameterizedType) {
                this.add(((ParameterizedType)type).getRawType());
            } else {
                throw new ForbiddenArgumentException(UtilMessage.CANNOT_PROXY_NON_CLASS_TYPE, type);
            }
            return this;
        }

        public static TypeInfo of(Set<? extends Type> types) {
            TypeInfo typeInfo = TypeInfo.create();
            for (Type type : types) {
                typeInfo.add(type);
            }
            return typeInfo;
        }

        public static TypeInfo create() {
            return new TypeInfo();
        }
    }
}

