/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.ejb.interceptor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.ejb.spi.InterceptorBindings;
import org.jboss.weld.ejb.spi.helpers.ForwardingEjbServices;
import org.jboss.weld.integration.ejb.JBossEjbServices;
import org.jboss.weld.integration.ejb.interceptor.DelegatingInterceptorInvocationContext;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextualInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jsr299BindingsInterceptor
implements Serializable {
    private static final long serialVersionUID = -1999613731498564948L;
    @Resource(mappedName="java:comp/BeanManager")
    private WeldManager beanManager;
    private InterceptorBindings interceptorBindings;
    private Map<String, SerializableContextualInstance<Interceptor<Object>, Object>> interceptorInstances;

    @PostConstruct
    public void doPostConstruct(InvocationContext invocationContext) throws Exception {
        this.init(invocationContext);
        this.doLifecycleInterception(invocationContext, InterceptionType.POST_CONSTRUCT);
    }

    private void init(InvocationContext invocationContext) {
        this.interceptorInstances = new ConcurrentHashMap<String, SerializableContextualInstance<Interceptor<Object>, Object>>();
        EjbDescriptor ejbDescriptor = (EjbDescriptor)invocationContext.getContextData().get("org.jboss.weld.integration.ejb.SessionBeanInterceptor.ejbName");
        EjbServices ejbServices = (EjbServices)this.beanManager.getServices().get(EjbServices.class);
        if (ejbServices instanceof ForwardingEjbServices) {
            ejbServices = ((ForwardingEjbServices)ejbServices).delegate();
        }
        if (ejbServices instanceof JBossEjbServices) {
            this.interceptorBindings = ((JBossEjbServices)ejbServices).getInterceptorBindings(ejbDescriptor);
        }
        if (this.interceptorBindings != null) {
            for (Interceptor interceptor : this.interceptorBindings.getAllInterceptors()) {
                this.addInterceptorInstance((Interceptor<Object>)interceptor, invocationContext);
            }
        }
    }

    private void addInterceptorInstance(Interceptor<Object> interceptor, InvocationContext invocationContext) {
        CreationalContext creationalContext = (CreationalContext)invocationContext.getContextData().get("org.jboss.weld.integration.ejb.SessionBeanInterceptor.creationalContext");
        Object instance = this.beanManager.getContext(interceptor.getScope()).get(interceptor, creationalContext);
        SerializableContextualInstance serializableContextualInstance = ((ContextualStore)this.beanManager.getServices().get(ContextualStore.class)).getSerializableContextualInstance(interceptor, instance, creationalContext);
        this.interceptorInstances.put(interceptor.getBeanClass().getName(), (SerializableContextualInstance<Interceptor<Object>, Object>)serializableContextualInstance);
    }

    @PreDestroy
    public void doPreDestroy(InvocationContext invocationContext) throws Exception {
        this.doLifecycleInterception(invocationContext, InterceptionType.PRE_DESTROY);
    }

    @AroundInvoke
    public Object doAroundInvoke(InvocationContext invocationContext) throws Exception {
        return this.doMethodInterception(invocationContext, InterceptionType.AROUND_INVOKE);
    }

    private void doLifecycleInterception(InvocationContext invocationContext, InterceptionType interceptionType) throws Exception {
        if (this.interceptorBindings != null) {
            List currentInterceptors = this.interceptorBindings.getLifecycleInterceptors(interceptionType);
            this.delegateInterception(invocationContext, interceptionType, currentInterceptors);
        } else {
            invocationContext.proceed();
        }
    }

    private Object doMethodInterception(InvocationContext invocationContext, InterceptionType interceptionType) throws Exception {
        if (this.interceptorBindings != null) {
            List currentInterceptors = this.interceptorBindings.getMethodInterceptors(interceptionType, invocationContext.getMethod());
            return this.delegateInterception(invocationContext, interceptionType, currentInterceptors);
        }
        return invocationContext.proceed();
    }

    private Object delegateInterception(InvocationContext invocationContext, InterceptionType interceptionType, List<Interceptor<?>> currentInterceptors) throws Exception {
        ArrayList<Object> currentInterceptorInstances = new ArrayList<Object>();
        for (Interceptor<?> interceptor : currentInterceptors) {
            currentInterceptorInstances.add(this.interceptorInstances.get(interceptor.getBeanClass().getName()).getInstance());
        }
        if (currentInterceptorInstances.size() > 0) {
            return new DelegatingInterceptorInvocationContext(invocationContext, currentInterceptors, currentInterceptorInstances, interceptionType).proceed();
        }
        return invocationContext.proceed();
    }
}

