/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing.internal;

import org.jboss.logging.Logger;
import org.jboss.osgi.testing.OSGiBundle;
import org.jboss.osgi.testing.OSGiRuntime;
import org.osgi.framework.BundleException;

public abstract class OSGiBundleImpl
implements OSGiBundle {
    private static final Logger log = Logger.getLogger(OSGiBundleImpl.class);
    private OSGiRuntime runtime;

    OSGiBundleImpl(OSGiRuntime runtime) {
        this.runtime = runtime;
    }

    public OSGiRuntime getRuntime() {
        return this.runtime;
    }

    public void start() throws BundleException {
        log.debug((Object)("Start bundle: " + this));
        this.startInternal();
    }

    protected abstract void startInternal() throws BundleException;

    public void stop() throws BundleException {
        log.debug((Object)("Stop bundle: " + this));
        this.stopInternal();
    }

    protected abstract void stopInternal() throws BundleException;

    public void uninstall() throws BundleException {
        log.debug((Object)("Uninstall bundle: " + this));
        this.uninstallInternal();
    }

    protected abstract void uninstallInternal() throws BundleException;

    public boolean equals(Object obj) {
        if (!(obj instanceof OSGiBundle)) {
            return false;
        }
        OSGiBundle other = (OSGiBundle)obj;
        boolean isEqual = this.getSymbolicName().equals(other.getSymbolicName());
        isEqual = isEqual && this.getVersion().equals((Object)other.getVersion());
        return isEqual;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "[" + this.getSymbolicName() + ":" + this.getVersion() + "]";
    }

    void assertNotUninstalled() {
        if (this.getState() == 1) {
            throw new IllegalStateException("Bundle already uninstalled: " + this.getLocation());
        }
    }
}

