/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.alert;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertCondition;

@Entity
@NamedQueries(value={@NamedQuery(name="AlertConditinLog.findAll", query="SELECT acl FROM AlertConditionLog AS acl"), @NamedQuery(name="AlertConditinLog.findUnmatchedLogByAlertConditionId", query="SELECT acl FROM AlertConditionLog AS acl WHERE acl.condition.id = :alertConditionId AND acl.alert IS NULL"), @NamedQuery(name="AlertConditinLog.findUnmatchedLogsByAlertDefinitionId", query="SELECT acl FROM AlertConditionLog AS acl WHERE acl.condition.alertDefinition.id = :alertDefinitionId AND acl.alert IS NULL"), @NamedQuery(name="AlertConditionLog.deleteByResource", query="DELETE AlertConditionLog acl WHERE acl.id IN ( SELECT iacl.id FROM AlertConditionLog iacl WHERE iacl.condition.alertDefinition.resource.id = :resourceId )"), @NamedQuery(name="AlertConditionLog.deleteByAlertCTime", query="DELETE AlertConditionLog acl WHERE acl.id IN ( SELECT iacl.id FROM AlertConditionLog iacl WHERE iacl.alert.ctime BETWEEN :begin AND :end )"), @NamedQuery(name="AlertConditionLog.deleteByResources", query="DELETE AlertConditionLog acl WHERE acl.condition IN ( SELECT ac FROM AlertCondition ac WHERE ac.alertDefinition IN ( SELECT ad FROM AlertDefinition ad WHERE ad.resource.id IN ( :resourceIds ) ))"), @NamedQuery(name="AlertConditionLog.deleteUnmatchedByAlertDefinitionId", query="DELETE AlertConditionLog acl   WHERE acl.id IN ( SELECT iacl.id                        FROM AlertConditionLog iacl                      WHERE iacl.condition.alertDefinition.id = :alertDefinitionId )     AND acl.alert IS NULL")})
@SequenceGenerator(name="RHQ_ALERT_CONDITION_LOG_ID_SEQ", sequenceName="RHQ_ALERT_CONDITION_LOG_ID_SEQ")
@Table(name="RHQ_ALERT_CONDITION_LOG")
public class AlertConditionLog
implements Serializable {
    public static final String QUERY_FIND_UNMATCHED_LOG_BY_ALERT_CONDITION_ID = "AlertConditinLog.findUnmatchedLogByAlertConditionId";
    public static final String QUERY_FIND_UNMATCHED_LOGS_BY_ALERT_DEFINITION_ID = "AlertConditinLog.findUnmatchedLogsByAlertDefinitionId";
    public static final String QUERY_DELETE_BY_RESOURCE = "AlertConditionLog.deleteByResource";
    public static final String QUERY_DELETE_BY_RESOURCES = "AlertConditionLog.deleteByResources";
    public static final String QUERY_DELETE_BY_ALERT_CTIME = "AlertConditionLog.deleteByAlertCTime";
    public static final String QUERY_DELETE_UNMATCHED_BY_ALERT_DEFINITION_ID = "AlertConditionLog.deleteUnmatchedByAlertDefinitionId";
    public static final String QUERY_NATIVE_TRUNCATE_SQL = "TRUNCATE TABLE RHQ_ALERT_CONDITION_LOG";
    public static final int MAX_LOG_LENGTH = 250;
    private static final long serialVersionUID = 1L;
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RHQ_ALERT_CONDITION_LOG_ID_SEQ")
    @Id
    private int id;
    @Column(name="CTIME", nullable=false)
    private long ctime;
    @Column(name="VALUE")
    private String value;
    @JoinColumn(name="ALERT_ID", referencedColumnName="ID")
    @ManyToOne
    private Alert alert;
    @JoinColumn(name="CONDITION_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    private AlertCondition condition;

    protected AlertConditionLog() {
    }

    public AlertConditionLog(AlertCondition cond, long ctime) {
        this.condition = cond;
        this.ctime = ctime;
    }

    public int getId() {
        return this.id;
    }

    public long getCtime() {
        return this.ctime;
    }

    public void setCtime(long ctime) {
        this.ctime = ctime;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value != null && value.length() >= 250) {
            value = value.substring(0, 250);
        }
        this.value = value;
    }

    public Alert getAlert() {
        return this.alert;
    }

    public void setAlert(Alert alert) {
        this.alert = alert;
    }

    public AlertCondition getCondition() {
        return this.condition;
    }

    public void setCondition(AlertCondition condition) {
        this.condition = condition;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AlertConditionLog)) {
            return false;
        }
        AlertConditionLog that = (AlertConditionLog)obj;
        if (this.id != that.id) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "org.rhq.core.domain.alert.AlertConditionLog[ id=" + this.id + ", " + "value=" + this.value + ", " + this.condition + " ]";
    }
}

