/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.auth;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.QueryHint;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.util.EntitySerializer;
import org.rhq.core.domain.util.serial.ExternalizableStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="Subject.findByIds", query="SELECT s   FROM Subject s  WHERE s.id IN ( :ids )    AND s.fsystem = FALSE    AND s.factive = TRUE"), @NamedQuery(name="Subject.findAll", query="SELECT s   FROM Subject s  WHERE s.fsystem = false"), @NamedQuery(name="Subject.findByName", query="SELECT s   FROM Subject s  WHERE s.name = :name"), @NamedQuery(name="Subject.getSubjectsAssignedToRole", query="SELECT s   FROM Subject s   JOIN s.roles r  WHERE r.id = :id    AND s.fsystem = FALSE    AND s.factive = TRUE"), @NamedQuery(name="Subject.getGlobalPermissions", hints={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.cacheRegion", value="security")}, query="SELECT distinct p FROM Subject AS s, IN (s.roles) r, IN (r.permissions) p WHERE s = :subject"), @NamedQuery(name="Subject.hasGlobalPermission", hints={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.cacheRegion", value="security")}, query="SELECT COUNT(p) FROM Subject AS s, IN (s.roles) r, IN (r.permissions) p WHERE s = :subject AND p = :permission"), @NamedQuery(name="Subject.getPermissionsByGroup", query="SELECT DISTINCT p FROM Role r JOIN r.subjects s JOIN r.permissions p WHERE   (    r in (SELECT r2 from ResourceGroup g JOIN g.roles r2 WHERE g.id = :groupId)     OR r in (SELECT r3 from ResourceGroup g JOIN g.clusterResourceGroup crg JOIN crg.roles r3 WHERE g.id = :groupId AND crg.recursive = true)   )   AND s = :subject"), @NamedQuery(name="Subject.hasGroupPermission", query="SELECT count(r) FROM Role r JOIN r.subjects s JOIN r.permissions p WHERE   (    r in (SELECT r2 from ResourceGroup g JOIN g.roles r2 WHERE g.id = :groupId)     OR r in (SELECT r3 from ResourceGroup g JOIN g.clusterResourceGroup crg JOIN crg.roles r3 WHERE g.id = :groupId AND crg.recursive = true)   )   AND s = :subject   AND p = :permission"), @NamedQuery(name="Subject.getPermissionsByResource", query="SELECT distinct p FROM Resource res, IN (res.implicitGroups) g, IN (g.roles) r, IN (r.subjects) s, IN (r.permissions) p WHERE s = :subject AND res.id = :resourceId"), @NamedQuery(name="Subject.hasResourcePermission", query="SELECT COUNT(res) FROM Resource res, IN (res.implicitGroups) g, IN (g.roles) r, IN (r.subjects) s, IN (r.permissions) p WHERE s = :subject AND res.id = :resourceId AND p = :permission"), @NamedQuery(name="Subject.canViewResource", query="SELECT COUNT(res) FROM Resource res, IN (res.implicitGroups) g, IN (g.roles) r, IN (r.subjects) s WHERE s = :subject AND res.id = :resourceId"), @NamedQuery(name="Subject.canViewGroup", query="SELECT count(g) FROM ResourceGroup g WHERE (g.id IN (SELECT rg.id                   FROM ResourceGroup rg                   JOIN rg.roles r                   JOIN r.subjects s                  WHERE s = :subject)     OR g.id IN (SELECT rg.id                   FROM ResourceGroup rg                   JOIN rg.clusterResourceGroup crg                   JOIN crg.roles r                   JOIN r.subjects s                  WHERE crg.recursive = true AND s = :subject))     AND g.id = :groupId"), @NamedQuery(name="Subject.getResourcesByPermission", query="SELECT distinct res.id FROM Subject s, IN (s.roles) r, IN (r.permissions) p, IN (r.resourceGroups) g, IN (g.implicitResources) res WHERE s = :subject AND p = :permission"), @NamedQuery(name="Subject.findAvailableSubjectsForRoleWithExcludes", query="SELECT DISTINCT s   FROM Subject AS s LEFT JOIN s.roles AS r  WHERE s.id NOT IN       (         SELECT ss.id           FROM Role rr JOIN rr.subjects AS ss           WHERE rr.id = :roleId      )   AND s.id NOT IN ( :excludes )   AND s.fsystem = FALSE   AND s.factive = TRUE"), @NamedQuery(name="Subject.findAvailableSubjectsForRole", query="SELECT DISTINCT s   FROM Subject AS s LEFT JOIN s.roles AS r  WHERE s.id NOT IN        (          SELECT ss.id          FROM Role rr JOIN rr.subjects AS ss          WHERE rr.id = :roleId       )    AND s.fsystem = FALSE    AND s.factive = TRUE"), @NamedQuery(name="Subject.dynamicConfigValues", query="SELECT s.name, s.name FROM Subject AS s WHERE s.fsystem = false")})
@SequenceGenerator(name="RHQ_SUBJECT_ID_SEQ", sequenceName="RHQ_SUBJECT_ID_SEQ")
@Table(name="RHQ_SUBJECT")
public class Subject
implements Externalizable {
    public static final String QUERY_FIND_ALL = "Subject.findAll";
    public static final String QUERY_FIND_BY_IDS = "Subject.findByIds";
    public static final String QUERY_FIND_BY_NAME = "Subject.findByName";
    public static final String QUERY_GET_SUBJECTS_ASSIGNED_TO_ROLE = "Subject.getSubjectsAssignedToRole";
    public static final String QUERY_GET_GLOBAL_PERMISSIONS = "Subject.getGlobalPermissions";
    public static final String QUERY_GET_PERMISSIONS_BY_GROUP_ID = "Subject.getPermissionsByGroup";
    public static final String QUERY_GET_PERMISSIONS_BY_RESOURCE_ID = "Subject.getPermissionsByResource";
    public static final String QUERY_HAS_GLOBAL_PERMISSION = "Subject.hasGlobalPermission";
    public static final String QUERY_HAS_GROUP_PERMISSION = "Subject.hasGroupPermission";
    public static final String QUERY_HAS_RESOURCE_PERMISSION = "Subject.hasResourcePermission";
    public static final String QUERY_CAN_VIEW_RESOURCE = "Subject.canViewResource";
    public static final String QUERY_CAN_VIEW_GROUP = "Subject.canViewGroup";
    public static final String QUERY_GET_RESOURCES_BY_PERMISSION = "Subject.getResourcesByPermission";
    public static final String QUERY_FIND_AVAILABLE_SUBJECTS_FOR_ROLE_WITH_EXCLUDES = "Subject.findAvailableSubjectsForRoleWithExcludes";
    public static final String QUERY_FIND_AVAILABLE_SUBJECTS_FOR_ROLE = "Subject.findAvailableSubjectsForRole";
    public static final String QUERY_DYNAMIC_CONFIG_VALUES = "Subject.dynamicConfigValues";
    private static final long serialVersionUID = 1L;
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RHQ_SUBJECT_ID_SEQ")
    @Id
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="FIRST_NAME")
    private String firstName;
    @Column(name="LAST_NAME")
    private String lastName;
    @Column(name="EMAIL_ADDRESS")
    private String emailAddress;
    @Column(name="SMS_ADDRESS")
    private String smsAddress;
    @Column(name="PHONE_NUMBER")
    private String phoneNumber;
    @Column(name="DEPARTMENT")
    private String department;
    @Column(name="FACTIVE", nullable=false)
    private boolean factive;
    @Column(name="FSYSTEM", nullable=false)
    private boolean fsystem;
    @JoinColumn(name="CONFIGURATION_ID")
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.REMOVE, CascadeType.MERGE})
    private Configuration configuration;
    @JoinTable(name="RHQ_SUBJECT_ROLE_MAP", joinColumns={@JoinColumn(name="SUBJECT_ID")}, inverseJoinColumns={@JoinColumn(name="ROLE_ID")})
    @ManyToMany
    private Set<Role> roles;
    @Transient
    private Integer sessionId = null;

    private void init() {
        this.roles = new HashSet<Role>();
    }

    public Subject() {
        this.init();
    }

    public Subject(@NotNull String name, boolean factive, boolean fsystem) {
        this.init();
        this.name = name;
        this.factive = factive;
        this.fsystem = fsystem;
    }

    public int getId() {
        return this.id;
    }

    public void setSessionId(Integer sessionId) {
        this.sessionId = sessionId;
    }

    public Integer getSessionId() {
        return this.sessionId;
    }

    public void setId(int id) {
        this.id = id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getSmsAddress() {
        return this.smsAddress;
    }

    public void setSmsAddress(String smsAddress) {
        this.smsAddress = smsAddress;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public boolean getFactive() {
        return this.factive;
    }

    public void setFactive(boolean factive) {
        this.factive = factive;
    }

    public boolean getFsystem() {
        return this.fsystem;
    }

    public void setFsystem(boolean fsystem) {
        this.fsystem = fsystem;
    }

    public Configuration getUserConfiguration() {
        return this.configuration;
    }

    public void setUserConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Set<Role> getRoles() {
        if (this.roles == null) {
            this.roles = new HashSet<Role>();
        }
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void addRole(Role role) {
        this.getRoles().add(role);
    }

    public void removeRole(Role role) {
        this.getRoles().remove(role);
    }

    public String toString() {
        return "org.rhq.core.domain.auth.Subject[id=" + this.id + ",name=" + this.name + "]";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Subject)) {
            return false;
        }
        Subject other = (Subject)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableStrategy.Subsystem strategy = ExternalizableStrategy.getStrategy();
        out.writeChar(strategy.id());
        if (ExternalizableStrategy.Subsystem.REMOTEAPI == strategy) {
            this.writeExternalRemote(out);
        } else if (ExternalizableStrategy.Subsystem.REFLECTIVE_SERIALIZATION == strategy) {
            EntitySerializer.writeExternalRemote(this, out);
            out.writeInt(this.sessionId == null ? 0 : this.sessionId);
        } else {
            this.writeExternalAgent(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        char c = in.readChar();
        if (ExternalizableStrategy.Subsystem.REMOTEAPI.id() == c) {
            this.readExternalRemote(in);
        } else if (ExternalizableStrategy.Subsystem.REFLECTIVE_SERIALIZATION.id() == c) {
            EntitySerializer.readExternalRemote(this, in);
            this.sessionId = in.readInt();
        } else {
            this.readExternalAgent(in);
        }
    }

    public void writeExternalAgent(ObjectOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeUTF(this.name);
        out.writeInt(this.sessionId);
    }

    public void readExternalAgent(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.name = in.readUTF();
        this.sessionId = in.readInt();
    }

    public void writeExternalRemote(ObjectOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeUTF(this.name);
        out.writeUTF(null == this.firstName ? "" : this.firstName);
        out.writeUTF(null == this.lastName ? "" : this.lastName);
        out.writeUTF(null == this.emailAddress ? "" : this.emailAddress);
        out.writeUTF(null == this.smsAddress ? "" : this.smsAddress);
        out.writeUTF(null == this.phoneNumber ? "" : this.phoneNumber);
        out.writeUTF(null == this.department ? "" : this.department);
        out.writeBoolean(this.factive);
        out.writeBoolean(this.fsystem);
        out.writeObject(this.configuration);
        out.writeObject(this.roles);
        out.writeInt(this.sessionId == null ? 0 : this.sessionId);
    }

    public void readExternalRemote(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.name = in.readUTF();
        this.firstName = in.readUTF();
        this.lastName = in.readUTF();
        this.emailAddress = in.readUTF();
        this.smsAddress = in.readUTF();
        this.phoneNumber = in.readUTF();
        this.department = in.readUTF();
        this.factive = in.readBoolean();
        this.fsystem = in.readBoolean();
        this.configuration = (Configuration)in.readObject();
        this.roles = (Set)in.readObject();
        this.sessionId = in.readInt();
    }
}

