/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.bundle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.rhq.core.domain.bundle.BundleDeployDefinition;
import org.rhq.core.domain.bundle.BundleDeploymentHistory;
import org.rhq.core.domain.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="BundleDeployment.findByDefinitionIdNoFetch", query="SELECT bd FROM BundleDeployment bd WHERE bd.bundleDeployDefinition.id = :id "), @NamedQuery(name="BundleDeployment.findByResourceIdNoFetch", query="SELECT bd FROM BundleDeployment bd WHERE bd.resource.id = :id ")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_BUNDLE_DEPLOY_ID_SEQ")
@Table(name="RHQ_BUNDLE_DEPLOY")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BundleDeployment
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_BY_DEFINITION_ID_NO_FETCH = "BundleDeployment.findByDefinitionIdNoFetch";
    public static final String QUERY_FIND_BY_RESOURCE_ID_NO_FETCH = "BundleDeployment.findByResourceIdNoFetch";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @JoinColumn(name="BUNDLE_DEPLOY_DEF_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private BundleDeployDefinition bundleDeployDefinition;
    @JoinColumn(name="RESOURCE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Resource resource;
    @Column(name="CTIME")
    private Long ctime = -1L;
    @OneToMany(mappedBy="bundleDeployment", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<BundleDeploymentHistory> histories = new ArrayList<BundleDeploymentHistory>();

    protected BundleDeployment() {
    }

    public BundleDeployment(BundleDeployDefinition bundleDeploymentDef, Resource resource) {
        this.bundleDeployDefinition = bundleDeploymentDef;
        this.resource = resource;
    }

    public BundleDeployDefinition getBundleDeployDefinition() {
        return this.bundleDeployDefinition;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Long getCtime() {
        return this.ctime;
    }

    @PrePersist
    void onPersist() {
        this.ctime = System.currentTimeMillis();
    }

    public void setBundleDeployDefinition(BundleDeployDefinition bundleDeployDefinition) {
        this.bundleDeployDefinition = bundleDeployDefinition;
    }

    public List<BundleDeploymentHistory> getBundleDeploymentHistories() {
        return this.histories;
    }

    public void setBundleDeploymentHistories(List<BundleDeploymentHistory> histories) {
        this.histories = histories;
    }

    public void addBundleDeploymentHistory(BundleDeploymentHistory history) {
        history.setBundleDeployment(this);
        this.histories.add(history);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("BundleDeployment: ");
        str.append(", bdd=[").append(this.bundleDeployDefinition).append("]");
        str.append(", resource=[").append(this.resource).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.bundleDeployDefinition == null ? 0 : this.bundleDeployDefinition.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof BundleDeployment)) {
            return false;
        }
        BundleDeployment other = (BundleDeployment)obj;
        if (this.bundleDeployDefinition == null ? this.bundleDeployDefinition != null : !this.bundleDeployDefinition.equals(other.bundleDeployDefinition)) {
            return false;
        }
        return !(this.resource == null ? this.resource != null : !this.resource.equals(other.resource));
    }
}

