/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.bundle;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.bundle.BundleVersionRepoPK;
import org.rhq.core.domain.content.Repo;

@Entity
@IdClass(value=BundleVersionRepoPK.class)
@NamedQueries(value={@NamedQuery(name="BundleVersionRepo.findByRepoIdNoFetch", query="SELECT bvr FROM BundleVersionRepo bvr WHERE bvr.repo.id = :id "), @NamedQuery(name="BundleVersionRepo.findByBundleVersionIdNoFetch", query="SELECT bvr FROM BundleVersionRepo bvr WHERE bvr.bundleVersion.id = :id ")})
@Table(name="RHQ_BUNDLE_VERSION_REPO")
public class BundleVersionRepo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_BY_REPO_ID_NO_FETCH = "BundleVersionRepo.findByRepoIdNoFetch";
    public static final String QUERY_FIND_BY_BUNDLE_VERSION_ID_NO_FETCH = "BundleVersionRepo.findByBundleVersionIdNoFetch";
    @Id
    private BundleVersion bundleVersion;
    @Id
    private Repo repo;

    protected BundleVersionRepo() {
    }

    public BundleVersionRepo(BundleVersion bundleVersion, Repo repo) {
        this.bundleVersion = bundleVersion;
        this.repo = repo;
    }

    public BundleVersionRepoPK getBundleVersionRepoPK() {
        return new BundleVersionRepoPK(this.bundleVersion, this.repo);
    }

    public void setBundleVersionRepoPK(BundleVersionRepoPK pk) {
        this.bundleVersion = pk.getBundleVersion();
        this.repo = pk.getRepo();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("BVR: ");
        str.append(", bv=[").append(this.bundleVersion).append("]");
        str.append(", repo=[").append(this.repo).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.bundleVersion == null ? 0 : this.bundleVersion.hashCode());
        result = 31 * result + (this.repo == null ? 0 : this.repo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof BundleVersionRepo)) {
            return false;
        }
        BundleVersionRepo other = (BundleVersionRepo)obj;
        if (this.bundleVersion == null ? this.bundleVersion != null : !this.bundleVersion.equals(other.bundleVersion)) {
            return false;
        }
        return !(this.repo == null ? this.repo != null : !this.repo.equals(other.repo));
    }
}

