/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;
import org.rhq.core.domain.content.Advisory;

@Entity
@NamedQueries(value={@NamedQuery(name="AdvisoryBuglist.findBugsByAveId", query="SELECT ab FROM AdvisoryBuglist AS ab WHERE ab.advisory.id = :advId"), @NamedQuery(name="AdvisoryBuglist.deleteByAdvId", query="DELETE AdvisoryBuglist ab WHERE ab.advisory.id = :advId"), @NamedQuery(name="AdvisoryBuglist.findAdvBuginfo", query="SELECT ab FROM AdvisoryBuglist AS ab WHERE ab.advisory.id = :advId AND ab.bugid = :buginfo")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_ADVISORY_BUGLIST_ID_SEQ")
@Table(name="RHQ_ADVISORY_BUGLIST")
public class AdvisoryBuglist
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BUGS_BY_ADV_ID = "AdvisoryBuglist.findBugsByAveId";
    public static final String DELETE_BY_ADV_ID = "AdvisoryBuglist.deleteByAdvId";
    public static final String FIND_ADVISORY_BUGLIST = "AdvisoryBuglist.findAdvBuginfo";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @XmlTransient
    @ManyToOne
    @JoinColumn(name="ADVISORY_ID", referencedColumnName="ID", nullable=false)
    private Advisory advisory;
    @Column(name="BUG_ID", nullable=false)
    private String bugid;
    @Column(name="LAST_MODIFIED", nullable=false)
    private long lastModifiedDate;

    protected AdvisoryBuglist() {
    }

    public AdvisoryBuglist(Advisory adv, String bugid) {
        this.advisory = adv;
        this.bugid = bugid;
    }

    public Advisory getAdvisory() {
        return this.advisory;
    }

    public void setAdvisory(Advisory advisory) {
        this.advisory = advisory;
    }

    public String getBugid() {
        return this.bugid;
    }

    public void setBugid(String bugid) {
        this.bugid = bugid;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    @PrePersist
    void onPersist() {
        this.lastModifiedDate = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("AdvisoryCVE: ");
        str.append(", Advisory=[").append(this.advisory).append("]");
        str.append(", BUGID=[").append(this.bugid).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.advisory == null ? 0 : this.advisory.hashCode());
        result = 31 * result + (this.bugid == null ? 0 : this.bugid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AdvisoryBuglist)) {
            return false;
        }
        AdvisoryBuglist other = (AdvisoryBuglist)obj;
        return !(this.advisory == null ? this.advisory != null : !this.advisory.equals(other.advisory));
    }
}

