/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.content.Advisory;
import org.rhq.core.domain.content.CVE;

@Entity
@NamedQueries(value={@NamedQuery(name="AdvisoryCVE.findCveByAveId", query="SELECT ac FROM AdvisoryCVE AS ac WHERE ac.advisory.id = :advId"), @NamedQuery(name="AdvisoryCVE.deleteByAveId", query="DELETE AdvisoryCVE ac WHERE ac.advisory.id = :advId")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_ADVISORY_CVE_ID_SEQ")
@Table(name="RHQ_ADVISORY_CVE")
public class AdvisoryCVE
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_CVE_BY_ADV_ID = "AdvisoryCVE.findCveByAveId";
    public static final String DELETE_BY_ADV_ID = "AdvisoryCVE.deleteByAveId";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @ManyToOne
    @JoinColumn(name="ADVISORY_ID", referencedColumnName="ID", nullable=false)
    private Advisory advisory;
    @ManyToOne
    @JoinColumn(name="CVE_ID", referencedColumnName="ID", nullable=false)
    private CVE cve;
    @Column(name="LAST_MODIFIED", nullable=true)
    private long lastModifiedDate;

    protected AdvisoryCVE() {
    }

    public AdvisoryCVE(Advisory adv, CVE cve) {
        this.advisory = adv;
        this.cve = cve;
    }

    public int getId() {
        return this.id;
    }

    public Advisory getAdvisory() {
        return this.advisory;
    }

    public void setAdvisory(Advisory advisory) {
        this.advisory = advisory;
    }

    public CVE getCVE() {
        return this.cve;
    }

    public void setPkg(CVE cve) {
        this.cve = cve;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    @PrePersist
    void onPersist() {
        this.setLastModifiedDate(System.currentTimeMillis());
    }

    public String toString() {
        StringBuilder str = new StringBuilder("AdvisoryCVE: ");
        str.append(", Advisory=[").append(this.advisory).append("]");
        str.append(", CVE=[").append(this.cve).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.advisory == null ? 0 : this.advisory.hashCode());
        result = 31 * result + (this.cve == null ? 0 : this.cve.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AdvisoryCVE)) {
            return false;
        }
        AdvisoryCVE other = (AdvisoryCVE)obj;
        if (this.advisory == null ? this.advisory != null : !this.advisory.equals(other.advisory)) {
            return false;
        }
        return !(this.cve == null ? this.cve != null : !this.cve.equals(other.cve));
    }
}

