/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.rhq.core.domain.content.DistributionFile;
import org.rhq.core.domain.content.DistributionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="Distribution.findAll", query="SELECT dt FROM Distribution dt"), @NamedQuery(name="Distribution.findPathByDistType", query="SELECT dt   FROM Distribution dt  WHERE dt.label = :label AND dt.distributionType.name = :typeName "), @NamedQuery(name="Distribution.findByDistLabel", query="SELECT dt FROM Distribution dt WHERE dt.label = :label"), @NamedQuery(name="Distribution.findByDistPath", query="SELECT dt FROM Distribution dt WHERE dt.basePath = :path"), @NamedQuery(name="Distribution.deleteByDistId", query="DELETE Distribution dt WHERE dt.id = :distid")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_DISTRIBUTION_ID_SEQ")
@Table(name="RHQ_DISTRIBUTION")
public class Distribution
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL = "Distribution.findAll";
    public static final String QUERY_FIND_BY_DIST_LABEL = "Distribution.findByDistLabel";
    public static final String QUERY_FIND_BY_DIST_PATH = "Distribution.findByDistPath";
    public static final String QUERY_FIND_PATH_BY_DIST_TYPE = "Distribution.findPathByDistType";
    public static final String QUERY_DELETE_BY_DIST_ID = "Distribution.deleteByDistId";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @JoinColumn(name="DISTRIBUTION_TYPE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(cascade={CascadeType.PERSIST})
    private DistributionType distributionType;
    @Column(name="LABEL", nullable=false)
    private String label;
    @Column(name="BASE_PATH", nullable=false)
    private String basePath;
    @Column(name="LAST_MODIFIED", nullable=false)
    private long lastModifiedDate;
    @OneToMany(mappedBy="distribution", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Set<DistributionFile> distributionFiles;

    public Set<DistributionFile> getDistributionFiles() {
        return this.distributionFiles;
    }

    public void setDistributionFiles(Set<DistributionFile> distributionFiles) {
        this.distributionFiles = distributionFiles;
    }

    public Distribution() {
    }

    public Distribution(String label, String basepathIn, DistributionType distributionType) {
        this.setLabel(label);
        this.setBasePath(basepathIn);
        this.setDistributionType(distributionType);
    }

    public String getLabel() {
        return this.label;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setLabel(String labelIn) {
        this.label = labelIn;
    }

    public void setBasePath(String basepathIn) {
        this.basePath = basepathIn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public DistributionType getDistributionType() {
        return this.distributionType;
    }

    public void setDistributionType(DistributionType distributionType) {
        this.distributionType = distributionType;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String toString() {
        return String.format("Distribution [label=%s, Type=%s, basePath=%s]", this.label, this.distributionType, this.basePath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Distribution)) {
            return false;
        }
        Distribution kstree = (Distribution)o;
        return !(this.getLabel() != null ? !this.getLabel().equals(kstree.getLabel()) : kstree.getLabel() != null);
    }

    @PrePersist
    void onPersist() {
        this.setLastModifiedDate(System.currentTimeMillis());
    }

    @PreUpdate
    void onUpdate() {
        this.setLastModifiedDate(System.currentTimeMillis());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getLabel() == null ? 0 : this.getLabel().hashCode());
        return result;
    }
}

