/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.content.ContentSyncResults;
import org.rhq.core.domain.content.ContentSyncStatus;
import org.rhq.core.domain.content.Repo;

@Entity
@NamedQueries(value={@NamedQuery(name="RepoSyncResults.getInProgressByRepoId", query="SELECT rssr   FROM RepoSyncResults rssr  WHERE rssr.repo.id = :repoId    AND status = 'INPROGRESS'  ORDER BY rssr.startTime DESC "), @NamedQuery(name="RepoSyncResults.getAllByRepoId", query="SELECT rssr   FROM RepoSyncResults rssr  WHERE rssr.repo.id = :repoId ")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_REPO_SYNC_ID_SEQ")
@Table(name="RHQ_REPO_SYNC")
public class RepoSyncResults
implements Serializable,
ContentSyncResults {
    public static final String QUERY_GET_INPROGRESS_BY_REPO_ID = "RepoSyncResults.getInProgressByRepoId";
    public static final String QUERY_GET_ALL_BY_REPO_ID = "RepoSyncResults.getAllByRepoId";
    private static final long serialVersionUID = 1L;
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @JoinColumn(name="REPO_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Repo repo;
    @Column(name="STATUS", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ContentSyncStatus status;
    @Column(name="START_TIME", nullable=false)
    private long startTime = System.currentTimeMillis();
    @Column(name="END_TIME", nullable=true)
    private Long endTime;
    @Column(name="RESULTS", nullable=true)
    private String results;
    @Column(name="PERCENT_COMPLETE", nullable=true)
    private Long percentComplete;

    protected RepoSyncResults() {
        this.status = ContentSyncStatus.INPROGRESS;
    }

    public RepoSyncResults(Repo repoIn) {
        this();
        this.repo = repoIn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Repo getRepo() {
        return this.repo;
    }

    public void setRepo(Repo repoIn) {
        this.repo = repoIn;
    }

    public ContentSyncStatus getStatus() {
        return this.status;
    }

    public void setStatus(ContentSyncStatus status) {
        this.status = status;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public String getResults() {
        return this.results;
    }

    public void setResults(String results) {
        this.results = results;
    }

    public Long getPercentComplete() {
        return this.percentComplete;
    }

    public void setPercentComplete(Long percentComplete) {
        this.percentComplete = percentComplete;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getClass().getSimpleName() + ": ");
        str.append("start-time=[" + new Date(this.startTime));
        str.append("], end-time=[" + (this.endTime != null ? new Date(this.endTime) : "---"));
        str.append("], percentComplete=[" + (Object)((Object)this.status));
        str.append("], status=[" + this.percentComplete);
        str.append("], repo=[" + this.repo);
        str.append("]");
        return str.toString();
    }

    public void appendResults(String msg) {
        StringBuffer existing = new StringBuffer(this.getResults());
        existing.append("\n");
        existing.append(msg);
        this.setResults(existing.toString());
    }
}

