/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.rhq.core.domain.common.Tag;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoTagPK;

@Entity
@IdClass(value=RepoTagPK.class)
@Table(name="RHQ_REPO_TAG_MAP")
public class RepoTag
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @ManyToOne
    @JoinColumn(name="REPO_ID", referencedColumnName="ID", nullable=false, insertable=false, updatable=false)
    private Repo repo;
    @Id
    @ManyToOne
    @JoinColumn(name="TAG_ID", referencedColumnName="ID", nullable=false, insertable=false, updatable=false)
    private Tag tag;

    protected RepoTag() {
    }

    public RepoTag(Repo repo, Tag tag) {
        this.repo = repo;
        this.tag = tag;
    }

    public RepoTagPK getRepoTagPK() {
        return new RepoTagPK(this.repo, this.tag);
    }

    public void setRepoTagPK(RepoTagPK pk) {
        this.repo = pk.getRepo();
        this.tag = pk.getTag();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("RepoTag: ");
        str.append(", rp=[").append(this.repo).append("]");
        str.append(", tg=[").append(this.tag).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.repo == null ? 0 : this.repo.hashCode());
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RepoTag)) {
            return false;
        }
        RepoTag other = (RepoTag)obj;
        if (this.repo == null ? this.repo != null : !this.repo.equals(other.repo)) {
            return false;
        }
        return !(this.tag == null ? this.tag != null : !this.tag.equals(other.tag));
    }
}

