/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.ResourceRepoPK;
import org.rhq.core.domain.resource.Resource;

@Entity
@IdClass(value=ResourceRepoPK.class)
@NamedQueries(value={@NamedQuery(name="ResourceRepo.deleteByResources", query="DELETE ResourceRepo rc WHERE rc.resource.id IN ( :resourceIds )"), @NamedQuery(name="ResourceRepo.deleteByResourceId", query="DELETE ResourceRepo rc WHERE rc.resource.id = :resourceId"), @NamedQuery(name="ResourceRepo.deleteByRepoId", query="DELETE ResourceRepo rc WHERE rc.repo.id = :repoId")})
@Table(name="RHQ_REPO_RESOURCE_MAP")
public class ResourceRepo
implements Serializable {
    public static final String DELETE_BY_RESOURCES = "ResourceRepo.deleteByResources";
    public static final String DELETE_BY_RESOURCE_ID = "ResourceRepo.deleteByResourceId";
    public static final String DELETE_BY_REPO_ID = "ResourceRepo.deleteByRepoId";
    private static final long serialVersionUID = 1L;
    @Id
    private Resource resource;
    @Id
    private Repo repo;
    @Column(name="CTIME", nullable=false)
    private long createdTime;

    protected ResourceRepo() {
    }

    public ResourceRepo(Resource resource, Repo repo) {
        this.resource = resource;
        this.repo = repo;
    }

    public ResourceRepoPK getResourceRepoPK() {
        return new ResourceRepoPK(this.resource, this.repo);
    }

    public void setResourceRepoPK(ResourceRepoPK pk) {
        this.resource = pk.getResource();
        this.repo = pk.getRepo();
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    @PrePersist
    void onPersist() {
        this.createdTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("ResourceRepo: ");
        str.append("ctime=[").append(new Date(this.createdTime)).append("]");
        str.append(", re=[").append(this.resource).append("]");
        str.append(", ch=[").append(this.repo).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.repo == null ? 0 : this.repo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ResourceRepo)) {
            return false;
        }
        ResourceRepo other = (ResourceRepo)obj;
        if (this.resource == null ? this.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        return !(this.repo == null ? this.repo != null : !this.repo.equals(other.repo));
    }
}

