/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content.composite;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.rhq.core.domain.content.Advisory;
import org.rhq.core.domain.content.AdvisoryBuglist;
import org.rhq.core.domain.content.AdvisoryPackage;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvisoryDetailsComposite
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Advisory advisory;
    private final String advisoryType;
    private final String advisoryName;
    private final String topic;
    private final String synopsis;
    private final String description;
    private final String solution;
    private final String severity;
    private final Date updateDate;
    private final Date issueDate;
    private final List<PackageVersion> pkgs;
    private String bugid;

    public AdvisoryDetailsComposite(Advisory advisory, String advisoryName, String advisoryType, String topic, String synopsis, String description, String solution, String severity, Long updateDate, Long issueDate) {
        this.advisory = advisory;
        this.advisoryName = advisoryName;
        this.advisoryType = advisoryType;
        this.topic = topic;
        this.synopsis = synopsis;
        this.description = description;
        this.solution = solution;
        this.severity = severity;
        this.updateDate = new Date(updateDate * 1000L);
        this.issueDate = new Date(issueDate * 1000L);
        this.pkgs = this.getAdvisoryPackages();
        this.bugid = this.getBugid();
    }

    private List<PackageVersion> getAdvisoryPackages() {
        ArrayList<PackageVersion> pkges = new ArrayList<PackageVersion>();
        Set<AdvisoryPackage> apkgs = this.advisory.getAdvisorypkgs();
        for (AdvisoryPackage apkg : apkgs) {
            pkges.add(apkg.getPkg());
        }
        return pkges;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public Advisory getAdvisory() {
        return this.advisory;
    }

    public String getAdvisoryType() {
        return this.advisoryType;
    }

    public String getAdvisoryName() {
        return this.advisoryName;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSynopsis() {
        return this.synopsis;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSolution() {
        return this.solution;
    }

    public String getSeverity() {
        return this.severity;
    }

    public List<PackageVersion> getPkgs() {
        return this.pkgs;
    }

    public String getBugid() {
        ArrayList<String> bugs = new ArrayList<String>();
        Set<AdvisoryBuglist> abugs = this.advisory.getAdvisorybugs();
        for (AdvisoryBuglist abug : abugs) {
            bugs.add(abug.getBugid());
        }
        return StringUtils.getListAsString(bugs, " ");
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }
}

