/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.criteria;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageOrdering;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class Criteria
implements Serializable {
    private static final Log LOG = LogFactory.getLog(Criteria.class);
    private static final long serialVersionUID = 1L;
    private Integer pageNumber;
    private Integer pageSize;
    private boolean filtersOptional;
    private boolean caseSensitive;
    private List<Permission> requiredPermissions;
    private boolean strict;
    protected Map<String, String> filterOverrides;
    protected Map<String, String> sortOverrides;
    protected PageControl pageControlOverrides;
    private List<String> orderingFieldNames;
    private Class<?> persistentClass;
    private String searchExpression;

    private Criteria() {
    }

    public Criteria(Class<?> persistentClass) {
        this.persistentClass = persistentClass;
        this.filterOverrides = new HashMap<String, String>();
        this.sortOverrides = new HashMap<String, String>();
        this.orderingFieldNames = new ArrayList<String>();
        this.setPaging(0, 200);
    }

    public Class<?> getPersistentClass() {
        return this.persistentClass;
    }

    private List<Field> getFields(Type fieldType) {
        String prefix = fieldType.name().toLowerCase();
        ArrayList<Field> results = new ArrayList<Field>();
        Class<?> currentLevelClass = this.getClass();
        while (!currentLevelClass.equals(Criteria.class)) {
            for (Field field : currentLevelClass.getDeclaredFields()) {
                field.setAccessible(true);
                if (!field.getName().startsWith(prefix)) continue;
                results.add(field);
            }
            currentLevelClass = currentLevelClass.getSuperclass();
        }
        return results;
    }

    public Map<String, Object> getFilterFields() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Field field : this.getFields(Type.FILTER)) {
            Object filterFieldValue = null;
            try {
                filterFieldValue = field.get(this);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            if (filterFieldValue == null) continue;
            results.put(this.getCleansedFieldName(field, 6), filterFieldValue);
        }
        if (LOG.isDebugEnabled()) {
            for (Map.Entry entry : results.entrySet()) {
                LOG.debug((Object)("Filter: (" + (String)entry.getKey() + ", " + entry.getValue() + ")"));
            }
        }
        return results;
    }

    public String getJPQLFilterOverride(String fieldName) {
        return this.filterOverrides.get(fieldName);
    }

    public String getJPQLSortOverride(String fieldName) {
        return this.sortOverrides.get(fieldName);
    }

    public PageControl getPageControlOverrides() {
        return this.pageControlOverrides;
    }

    public List<String> getFetchFields() {
        ArrayList<String> results = new ArrayList<String>();
        for (Field fetchField : this.getFields(Type.FETCH)) {
            boolean shouldFetch;
            Object fetchFieldValue = null;
            try {
                fetchField.setAccessible(true);
                fetchFieldValue = fetchField.get(this);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            if (fetchFieldValue == null || !(shouldFetch = ((Boolean)fetchFieldValue).booleanValue())) continue;
            results.add(this.getCleansedFieldName(fetchField, 5));
        }
        if (LOG.isDebugEnabled()) {
            for (String entry : results) {
                LOG.debug((Object)("Fetch: (" + entry + ")"));
            }
        }
        return results;
    }

    protected void addSortField(String fieldName) {
        this.orderingFieldNames.add("sort" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1));
    }

    public void setPaging(int pageNumber, int pageSize) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }

    public void setPageControl(PageControl pageControl) {
        this.pageControlOverrides = pageControl;
    }

    public void clearPaging() {
        PageControl unlimited = PageControl.getUnlimitedInstance();
        this.pageNumber = unlimited.getPageNumber();
        this.pageSize = unlimited.getPageSize();
        this.pageControlOverrides = null;
    }

    public void setFiltersOptional(boolean filtersOptional) {
        this.filtersOptional = filtersOptional;
    }

    public boolean isFiltersOptional() {
        return this.filtersOptional;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setSearchExpression(String searchExpression) {
        this.searchExpression = searchExpression;
    }

    public String getSearchExpression() {
        return this.searchExpression;
    }

    public boolean isInventoryManagerRequired() {
        return false;
    }

    public boolean isSecurityManagerRequired() {
        return false;
    }

    public List<Permission> getRequiredPermissions() {
        return this.requiredPermissions;
    }

    public void addRequiredPermissions(Permission ... requiredPermissions) {
        this.requiredPermissions = Arrays.asList(requiredPermissions);
    }

    public PageControl getPageControl() {
        PageControl pc = null;
        if (this.pageControlOverrides != null) {
            pc = this.pageControlOverrides;
        } else {
            pc = this.pageNumber == null || this.pageSize == null ? PageControl.getUnlimitedInstance() : new PageControl(this.pageNumber, this.pageSize);
            for (String fieldName : this.orderingFieldNames) {
                for (Field sortField : this.getFields(Type.SORT)) {
                    if (!sortField.getName().equals(fieldName)) continue;
                    Object sortFieldValue = null;
                    try {
                        sortFieldValue = sortField.get(this);
                    }
                    catch (IllegalAccessException iae) {
                        throw new RuntimeException(iae);
                    }
                    if (sortFieldValue == null) continue;
                    PageOrdering pageOrdering = (PageOrdering)((Object)sortFieldValue);
                    pc.addDefaultOrderingField(this.getCleansedFieldName(sortField, 4), pageOrdering);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Page Control: " + pc));
        }
        return pc;
    }

    private String getCleansedFieldName(Field field, int leadingCharsToStrip) {
        String fieldNameFragment = field.getName().substring(leadingCharsToStrip);
        String fieldName = Character.toLowerCase(fieldNameFragment.charAt(0)) + fieldNameFragment.substring(1);
        return fieldName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        FILTER,
        FETCH,
        SORT;

    }
}

