/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

@NamedQueries(value={@NamedQuery(name="GetSchedulesWithOObAggregate", query="   SELECT new org.rhq.core.domain.measurement.composite.MeasurementOOBComposite        ( res.name, res.id, def.displayName, sched.id, o.timestamp, def.id, o.oobFactor,           bal.baselineMin, bal.baselineMax, def.units, parent.name, parent.id)      FROM MeasurementOOB o, MeasurementSchedule sched LEFT JOIN sched.definition def LEFT JOIN sched.resource res LEFT JOIN sched.baseline bal LEFT JOIN res.parentResource parent     WHERE o.id = sched.id       AND sched.definition = def       AND sched.resource = res       AND bal.schedule = sched       AND res.id IN ( SELECT rr.id FROM Resource rr                         JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s                        WHERE s.id = :subjectId )       AND (UPPER(def.displayName ) LIKE :metricName ESCAPE :escapeChar OR :metricName is null )       AND (UPPER(res.name) LIKE :resourceName ESCAPE :escapeChar OR :resourceName is null )       AND (UPPER(parent.name) LIKE :parentName ESCAPE :escapeChar OR :parentName is null ) "), @NamedQuery(name="GetSchedulesWithOObAggregate_admin", query="   SELECT new org.rhq.core.domain.measurement.composite.MeasurementOOBComposite        ( res.name, res.id, def.displayName, sched.id, o.timestamp, def.id, o.oobFactor,           bal.baselineMin, bal.baselineMax, def.units, parent.name, parent.id)      FROM MeasurementOOB o, MeasurementSchedule sched LEFT JOIN sched.definition def LEFT JOIN sched.resource res LEFT JOIN sched.baseline bal LEFT JOIN res.parentResource parent     WHERE o.id = sched.id       AND sched.definition = def       AND sched.resource = res       AND bal.schedule = sched       AND (UPPER(def.displayName ) LIKE :metricName ESCAPE :escapeChar OR :metricName is null )       AND (UPPER(res.name) LIKE :resourceName ESCAPE :escapeChar OR :resourceName is null )       AND (UPPER(parent.name) LIKE :parentName ESCAPE :escapeChar OR :parentName is null ) "), @NamedQuery(name="GetSchedulesWithOObAggregateCount", query="   SELECT COUNT(sched.id)      FROM MeasurementOOB o, MeasurementSchedule sched LEFT JOIN sched.definition def LEFT JOIN sched.resource res LEFT JOIN res.parentResource parent     WHERE o.id = sched.id       AND sched.definition = def       AND sched.resource = res       AND (UPPER(def.displayName ) LIKE :metricName OR :metricName is null )       AND (UPPER(res.name) LIKE :resourceName OR :resourceName is null )       AND (UPPER(parent.name) LIKE :parentName OR :parentName is null ) "), @NamedQuery(name="DeleteOutdatedOOBs", query="DELETE FROM MeasurementOOB o       WHERE o.id IN ( SELECT b.schedule.id                         FROM MeasurementBaseline b                        WHERE b.computeTime > :cutOff )"), @NamedQuery(name="CountOOBForDate", query="SELECT COUNT(o.timestamp)   FROM MeasurementOOB o  WHERE o.timestamp = :timestamp"), @NamedQuery(name="DeleteOOBForSchedule", query="DELETE FROM MeasurementOOB o       WHERE o.id = :id"), @NamedQuery(name="DeleteOOBForGroupAndDefinition", query="DELETE FROM MeasurementOOB o       WHERE o.id IN ( SELECT ms.id                         FROM MeasurementSchedule ms                         JOIN ms.resource res                         JOIN res.implicitGroups rg                        WHERE rg.id = :groupId                          AND ms.definition.id = :definitionId )"), @NamedQuery(name="DeleteOOBForResurces", query="DELETE FROM MeasurementOOB o       WHERE o.id IN ( SELECT ms.id                         FROM MeasurementSchedule ms                        WHERE ms.resource.id IN ( :resourceIds ) )"), @NamedQuery(name="GetHighestOOBFactorForResource", query="   SELECT new org.rhq.core.domain.measurement.composite.MeasurementOOBComposite        ( res.name, res.id, def.displayName, sched.id, o.timestamp, def.id, o.oobFactor,           bal.baselineMin , bal.baselineMax, def.units )      FROM MeasurementOOB o, MeasurementSchedule sched LEFT JOIN sched.definition def LEFT JOIN sched.resource res LEFT JOIN sched.baseline bal     WHERE o.id = sched.id       AND sched.definition = def       AND sched.resource = res       AND bal.schedule = sched       AND :resourceId = res.id ")})
@Entity
@Table(name="RHQ_MEASUREMENT_OOB")
public class MeasurementOOB {
    public static final String GET_SCHEDULES_WITH_OOB_AGGREGATE = "GetSchedulesWithOObAggregate";
    public static final String GET_SCHEDULES_WITH_OOB_AGGREGATE_ADMIN = "GetSchedulesWithOObAggregate_admin";
    public static final String GET_SCHEDULES_WITH_OOB_AGGREGATE_COUNT = "GetSchedulesWithOObAggregateCount";
    public static final String DELETE_OUTDATED = "DeleteOutdatedOOBs";
    public static final String COUNT_FOR_DATE = "CountOOBForDate";
    public static final String GET_HIGHEST_FACTORS_FOR_RESOURCE = "GetHighestOOBFactorForResource";
    public static final String DELETE_FOR_GROUP_AND_DEFINITION = "DeleteOOBForGroupAndDefinition";
    public static final String DELETE_FOR_SCHEDULE = "DeleteOOBForSchedule";
    public static final String DELETE_FOR_RESOURCES = "DeleteOOBForResurces";
    public static final String INSERT_QUERY = "INSERT INTO rhq_measurement_oob_tmp (oob_factor, schedule_id, time_stamp ) \n     ( SELECT max(mx*100) as mxdiff, id, ? \n         FROM ( SELECT max(((d.maxvalue - b.bl_max) / (b.bl_max - b.bl_min))) AS mx, d.schedule_id as id \n                  FROM rhq_measurement_bline b, rhq_measurement_data_num_1h d, rhq_measurement_sched sc, rhq_measurement_def def \n                 WHERE b.schedule_id = d.schedule_id \n                   AND sc.id = b.schedule_id \n                   AND d.value > b.bl_max \n                   AND d.time_stamp = ? \n                   AND (b.bl_max - b.bl_min) > 0.1 \n                   AND (d.maxvalue - b.bl_max) >0 \n                    AND sc.enabled = %TRUE% \n                   AND sc.definition = def.id \n                   AND def.numeric_type = 0 \n              GROUP BY d.schedule_id \nUNION ALL \n      SELECT max(((b.bl_min - d.minvalue) / (b.bl_max - b.bl_min))) AS mx, d.schedule_id as id \n        FROM rhq_measurement_bline b, rhq_measurement_data_num_1h d, rhq_measurement_sched sc, rhq_measurement_def def \n       WHERE b.schedule_id = d.schedule_id \n         AND sc.id = b.schedule_id \n         AND d.value < b.bl_max  \n         AND d.time_stamp = ? \n         AND (b.bl_max - b.bl_min) > 0.1 \n         AND (b.bl_min - d.minvalue) >0 \n         AND sc.enabled = %TRUE% \n         AND sc.definition = def.id \n         AND def.numeric_type = 0 \n    GROUP BY d.schedule_id \n   ) data \nGROUP BY id, mx \n  HAVING mx > 0.05 )";
    public static final String UPDATE_MASTER_POSTGRES = "UPDATE rhq_measurement_oob \n   SET oob_factor = rhq_measurement_oob_tmp.oob_factor,time_stamp=rhq_measurement_oob_tmp.time_stamp \n  FROM rhq_measurement_oob_tmp \n WHERE rhq_measurement_oob_tmp.oob_factor > rhq_measurement_oob.oob_factor \n   AND rhq_measurement_oob_tmp.schedule_id = rhq_measurement_oob.schedule_id ";
    public static final String MERGE_TABLES_ORACLE = "MERGE INTO rhq_measurement_oob oob_ \n     USING rhq_measurement_oob_tmp tmp_ \n        ON ( tmp_.schedule_id = oob_.schedule_id ) \n      WHEN MATCHED THEN UPDATE SET oob_factor = tmp_.oob_factor, time_stamp = tmp_.time_stamp \n      WHEN NOT MATCHED THEN INSERT ( oob_.schedule_id, oob_.time_stamp, oob_.oob_factor ) \n                            VALUES ( tmp_.schedule_id, tmp_.time_stamp, tmp_.oob_factor )";
    public static final String UPDATE_MASTER_GENERIC = "DELETE FROM rhq_measurement_oob \n      WHERE EXISTS ( SELECT oob_tmp.schedule_id \n                       FROM rhq_measurement_oob_tmp oob_tmp \n                      WHERE oob_tmp.oob_factor > rhq_measurement_oob.oob_factor \n                        AND oob_tmp.schedule_id = rhq_measurement_oob.schedule_id ) ";
    public static final String INSERT_NEW_ONES = "INSERT INTO rhq_measurement_oob (oob_factor, schedule_id, time_stamp) \n     ( SELECT oob_factor, schedule_id,  time_stamp \n         FROM rhq_measurement_oob_tmp \n        WHERE NOT EXISTS ( SELECT rhq_measurement_oob.schedule_id \n                              FROM rhq_measurement_oob \n                             WHERE rhq_measurement_oob.schedule_id = rhq_measurement_oob_tmp.schedule_id ) )";
    public static final String TRUNCATE_TMP_TABLE = "TRUNCATE TABLE rhq_measurement_oob_tmp";
    public static final String SECURITY_ADDITION = " AND ( res.id IN ( SELECT rr.id  FROM Resource rr                      JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s                     WHERE s.id = :subjectId ) ) ";
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="SCHEDULE_ID")
    int id;
    @Column(name="TIME_STAMP")
    long timestamp;
    @Column(name="OOB_FACTOR")
    private int oobFactor;

    protected MeasurementOOB() {
    }

    public int getScheduleId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getOobFactor() {
        return this.oobFactor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MeasurementOOB");
        sb.append("{id=").append(this.id);
        sb.append(", timestamp=").append(this.timestamp);
        sb.append(", oobFactor=").append(this.oobFactor);
        sb.append('}');
        return sb.toString();
    }
}

