/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.operation;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@MappedSuperclass
public class JobId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String JOB_ID_SEPARATOR = "_=_";
    @Column(name="JOB_NAME", nullable=false)
    private String jobName;
    @Column(name="JOB_GROUP", nullable=false)
    private String jobGroup;

    public JobId(String jobName, String jobGroup) {
        this.jobName = jobName;
        this.jobGroup = jobGroup;
    }

    public JobId(String jobIdString) {
        this(JobId.splitJobIdStringIntoParts(jobIdString));
    }

    protected JobId(String[] jobIdParts) {
        this(jobIdParts[0], jobIdParts[1]);
    }

    private JobId() {
    }

    public String getJobName() {
        return this.jobName;
    }

    protected void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobGroup() {
        return this.jobGroup;
    }

    protected void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    public String toString() {
        return JobId.joinPartsIntoJobIdString(this.jobName, this.jobGroup);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof JobId)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    protected static String[] splitJobIdStringIntoParts(String jobId) {
        return jobId.split(JOB_ID_SEPARATOR);
    }

    protected static String joinPartsIntoJobIdString(String ... parts) {
        String jobIdString = parts[0];
        for (int i = 1; i < parts.length; ++i) {
            jobIdString = jobIdString + JOB_ID_SEPARATOR + parts[i];
        }
        return jobIdString;
    }
}

