/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.plugin;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.plugin.PluginDeploymentType;
import org.rhq.core.domain.plugin.PluginStatusType;
import org.rhq.core.util.MessageDigestGenerator;

@DiscriminatorColumn(name="DEPLOYMENT")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@Entity
@SequenceGenerator(name="SEQ", sequenceName="RHQ_PLUGIN_ID_SEQ")
@Table(name="RHQ_PLUGIN")
public class AbstractPlugin
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TABLE_NAME = "RHQ_PLUGIN";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @Column(name="DEPLOYMENT", nullable=false, insertable=false, updatable=false)
    @Enumerated(value=EnumType.STRING)
    private PluginDeploymentType deployment;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="DISPLAY_NAME", nullable=false)
    private String displayName;
    @Column(name="DESCRIPTION", nullable=true)
    private String description;
    @Column(name="ENABLED", nullable=false)
    private boolean enabled = true;
    @Column(name="STATUS", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private PluginStatusType status = PluginStatusType.INSTALLED;
    @Column(name="HELP", nullable=true)
    private String help;
    @Column(name="VERSION", nullable=true)
    private String version;
    @Column(name="AMPS_VERSION", nullable=true)
    private String ampsVersion;
    @Column(name="PATH", nullable=false)
    private String path;
    @Column(name="MD5", nullable=false)
    private String md5;
    @Column(name="CTIME", nullable=false)
    private long ctime;
    @Column(name="MTIME", nullable=false)
    private long mtime;
    @Column(name="CONTENT", nullable=true)
    private byte[] content;

    public AbstractPlugin() {
    }

    public AbstractPlugin(String name, String path) {
        this.name = name;
        this.path = path;
    }

    public AbstractPlugin(String name, String path, String md5) {
        this.name = name;
        this.path = path;
        this.md5 = md5;
    }

    public AbstractPlugin(String name, String path, byte[] content) {
        this.name = name;
        this.path = path;
        this.content = content;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(content);
            this.md5 = MessageDigestGenerator.getDigestString((InputStream)stream);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot determine plugin's MD5!", e);
        }
    }

    public AbstractPlugin(int id, String name, String path, String displayName, boolean enabled, PluginStatusType status, String description, String help, String md5, String version, String ampsVersion, PluginDeploymentType deployment, long ctime, long mtime) {
        this.id = id;
        this.name = name;
        this.path = path;
        this.displayName = displayName;
        this.enabled = enabled;
        this.status = status;
        this.description = description;
        this.help = help;
        this.md5 = md5;
        this.version = version;
        this.ampsVersion = ampsVersion;
        this.deployment = deployment;
        this.ctime = ctime;
        this.mtime = mtime;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getCtime() {
        return this.ctime;
    }

    public void setCtime(long ctime) {
        this.ctime = ctime;
    }

    public long getMtime() {
        return this.mtime;
    }

    public void setMtime(long mtime) {
        this.mtime = mtime;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public PluginStatusType getStatus() {
        return this.status;
    }

    public void setStatus(PluginStatusType status) {
        this.status = status;
        if (this.status == PluginStatusType.DELETED) {
            this.enabled = false;
        }
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAmpsVersion() {
        return this.ampsVersion;
    }

    public void setAmpsVersion(String ampsVersion) {
        this.ampsVersion = ampsVersion;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getMD5() {
        return this.getMd5();
    }

    public void setMD5(String md5) {
        this.setMd5(md5);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public PluginDeploymentType getDeployment() {
        return this.deployment;
    }

    public void setDeployment(PluginDeploymentType deployment) {
        this.deployment = deployment;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    @PrePersist
    void onPersist() {
        this.ctime = System.currentTimeMillis();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AbstractPlugin)) {
            return false;
        }
        AbstractPlugin that = (AbstractPlugin)obj;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "[id=" + this.id + ", name=" + this.name + ", md5=" + this.md5 + "]";
    }
}

