/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.jboss.osgi.jmx.BundleStateMBeanExt;
import org.jboss.osgi.jmx.ObjectNameFactory;
import org.jboss.osgi.jmx.internal.AbstractState;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.JmxConstants;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.service.packageadmin.PackageAdmin;

public class BundleStateExt
extends AbstractState
implements BundleStateMBeanExt {
    public BundleStateExt(BundleContext context, MBeanServer mbeanServer) {
        super(context, mbeanServer);
    }

    ObjectName getObjectName() {
        return ObjectNameFactory.create("jboss.osgi:service=jmx,type=BundleState");
    }

    StandardMBean getStandardMBean() throws NotCompliantMBeanException {
        return new StandardMBean(this, BundleStateMBeanExt.class);
    }

    public CompositeData getBundle(long bundleId) throws IOException {
        TabularData bundleList = this.listBundles();
        CompositeData bundleData = bundleList.get(new Object[]{bundleId});
        if (bundleData == null) {
            throw new IllegalArgumentException("No such bundle: " + bundleId);
        }
        return bundleData;
    }

    public String getDataFile(long bundleId, String filename) throws IOException {
        BundleContext context = this.assertBundleContext(bundleId);
        File dataFile = context.getDataFile(filename);
        return dataFile != null ? dataFile.getCanonicalPath() : null;
    }

    public String getEntry(long bundleId, String path) throws IOException {
        Bundle bundle = this.assertBundle(bundleId);
        URL entry = bundle.getEntry(path);
        return entry != null ? entry.toExternalForm() : null;
    }

    public String getResource(long bundleId, String name) throws IOException {
        Bundle bundle = this.assertBundle(bundleId);
        URL resource = bundle.getResource(name);
        return resource != null ? resource.toExternalForm() : null;
    }

    public TabularData getHeaders(long bundleId, String locale) throws IOException {
        Bundle bundle = this.assertBundle(bundleId);
        ArrayList<Header> headers = new ArrayList<Header>();
        Dictionary bundleHeaders = bundle.getHeaders(locale);
        Enumeration keys = bundleHeaders.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            headers.add(new Header(key, (String)bundleHeaders.get(key)));
        }
        TabularDataSupport headerTable = new TabularDataSupport(HEADERS_TYPE);
        for (Header header : headers) {
            headerTable.put(header.toCompositeData());
        }
        return headerTable;
    }

    public CompositeData getProperty(long bundleId, String key) throws IOException {
        BundleContext bundleContext = this.assertBundleContext(bundleId);
        String value = bundleContext.getProperty(key);
        if (value == null) {
            return null;
        }
        String type = value.getClass().getSimpleName();
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("Key", key);
        items.put("Value", value);
        items.put("Type", type);
        try {
            return new CompositeDataSupport(JmxConstants.PROPERTY_TYPE, items);
        }
        catch (OpenDataException ex) {
            throw new JMRuntimeException("Failed to create CompositeData for property [" + key + ":" + value + "] - " + ex.getMessage());
        }
    }

    public long loadClass(long bundleId, String name) throws ClassNotFoundException, IOException {
        Bundle bundle = this.assertBundle(bundleId);
        Class clazz = bundle.loadClass(name);
        ServiceReference sref = this.context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin service = (PackageAdmin)this.context.getService(sref);
        Bundle exporter = service.getBundle(clazz);
        return exporter != null ? exporter.getBundleId() : 0L;
    }

    public String[] getExportedPackages(long arg0) throws IOException {
        return this.getBundleStateMBean().getExportedPackages(arg0);
    }

    public long[] getFragments(long arg0) throws IOException {
        return this.getBundleStateMBean().getFragments(arg0);
    }

    public TabularData getHeaders(long arg0) throws IOException {
        return this.getBundleStateMBean().getHeaders(arg0);
    }

    public long[] getHosts(long arg0) throws IOException {
        return this.getBundleStateMBean().getHosts(arg0);
    }

    public String[] getImportedPackages(long arg0) throws IOException {
        return this.getBundleStateMBean().getImportedPackages(arg0);
    }

    public long getLastModified(long arg0) throws IOException {
        return this.getBundleStateMBean().getLastModified(arg0);
    }

    public String getLocation(long arg0) throws IOException {
        return this.getBundleStateMBean().getLocation(arg0);
    }

    public long[] getRegisteredServices(long arg0) throws IOException {
        return this.getBundleStateMBean().getRegisteredServices(arg0);
    }

    public long[] getRequiredBundles(long arg0) throws IOException {
        return this.getBundleStateMBean().getRequiredBundles(arg0);
    }

    public long[] getRequiringBundles(long arg0) throws IOException {
        return this.getBundleStateMBean().getRequiringBundles(arg0);
    }

    public long[] getServicesInUse(long arg0) throws IOException {
        return this.getBundleStateMBean().getServicesInUse(arg0);
    }

    public int getStartLevel(long arg0) throws IOException {
        return this.getBundleStateMBean().getStartLevel(arg0);
    }

    public String getState(long arg0) throws IOException {
        return this.getBundleStateMBean().getState(arg0);
    }

    public String getSymbolicName(long arg0) throws IOException {
        return this.getBundleStateMBean().getSymbolicName(arg0);
    }

    public String getVersion(long arg0) throws IOException {
        return this.getBundleStateMBean().getVersion(arg0);
    }

    public boolean isFragment(long arg0) throws IOException {
        return this.getBundleStateMBean().isFragment(arg0);
    }

    public boolean isPersistentlyStarted(long arg0) throws IOException {
        return this.getBundleStateMBean().isPersistentlyStarted(arg0);
    }

    public boolean isRemovalPending(long arg0) throws IOException {
        return this.getBundleStateMBean().isRemovalPending(arg0);
    }

    public boolean isRequired(long arg0) throws IOException {
        return this.getBundleStateMBean().isRequired(arg0);
    }

    public TabularData listBundles() throws IOException {
        return this.getBundleStateMBean().listBundles();
    }

    private Bundle assertBundle(long bundleId) {
        Bundle bundle = this.context.getBundle(bundleId);
        if (bundle == null) {
            throw new IllegalArgumentException("No such bundle: " + bundleId);
        }
        return bundle;
    }

    private BundleContext assertBundleContext(long bundleId) {
        Bundle bundle = this.assertBundle(bundleId);
        BundleContext bundleContext = bundle.getBundleContext();
        return bundleContext;
    }

    static class Header {
        private String key;
        private String value;

        String getKey() {
            return this.key;
        }

        String getValue() {
            return this.value;
        }

        private Header() {
        }

        Header(String key, String value) {
            this.key = key;
            this.value = value;
        }

        CompositeData toCompositeData() throws JMRuntimeException {
            CompositeDataSupport result = null;
            HashMap<String, String> items = new HashMap<String, String>();
            items.put("Key", this.key);
            items.put("Value", this.value);
            try {
                result = new CompositeDataSupport(BundleStateMBean.HEADER_TYPE, items);
            }
            catch (OpenDataException e) {
                throw new JMRuntimeException("Failed to create CompositeData for header [" + this.key + ":" + this.value + "] - " + e.getMessage());
            }
            return result;
        }

        static Header from(CompositeData compositeData) {
            if (compositeData == null) {
                throw new IllegalArgumentException("Argument compositeData cannot be null");
            }
            if (!compositeData.getCompositeType().equals(BundleStateMBean.HEADER_TYPE)) {
                throw new IllegalArgumentException("Invalid CompositeType [" + compositeData.getCompositeType() + "]");
            }
            Header header = new Header();
            header.key = (String)compositeData.get("Key");
            header.value = (String)compositeData.get("Value");
            return header;
        }
    }
}

