/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.jboss.osgi.jmx.ObjectNameFactory;
import org.jboss.osgi.jmx.ServiceStateMBeanExt;
import org.jboss.osgi.jmx.internal.AbstractState;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServiceStateExt
extends AbstractState
implements ServiceStateMBeanExt {
    public ServiceStateExt(BundleContext context, MBeanServer mbeanServer) {
        super(context, mbeanServer);
    }

    ObjectName getObjectName() {
        return ObjectNameFactory.create("jboss.osgi:service=jmx,type=ServiceState");
    }

    StandardMBean getStandardMBean() throws NotCompliantMBeanException {
        return new StandardMBean(this, ServiceStateMBeanExt.class);
    }

    public CompositeData getService(String clazz) throws IOException {
        ServiceReference sref = this.context.getServiceReference(clazz);
        if (sref == null) {
            return null;
        }
        return this.getCompositeData(sref);
    }

    public TabularData getServices(String clazz, String filter) throws IOException {
        ServiceReference[] srefs;
        try {
            srefs = this.context.getServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter syntax: " + filter);
        }
        if (srefs == null) {
            return null;
        }
        TabularDataSupport tabularData = new TabularDataSupport(SERVICES_TYPE);
        for (ServiceReference sref : srefs) {
            CompositeDataSupport compData = this.getCompositeData(sref);
            tabularData.put(compData.get("Identifier"), compData);
        }
        return tabularData;
    }

    private CompositeDataSupport getCompositeData(ServiceReference sref) throws IOException {
        CompositeDataSupport compData;
        Long serviceId = (Long)sref.getProperty("service.id");
        ArrayList<Long> usingIdentifiers = new ArrayList<Long>();
        Bundle[] usingBundles = sref.getUsingBundles();
        if (usingBundles != null) {
            for (Bundle aux : usingBundles) {
                usingIdentifiers.add(aux.getBundleId());
            }
        }
        Long[] usingArr = usingIdentifiers.toArray(new Long[usingIdentifiers.size()]);
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("BundleIdentifier", sref.getBundle().getBundleId());
        items.put("Identifier", serviceId);
        items.put("objectClass", sref.getProperty("objectClass"));
        items.put("UsingBundles", usingArr);
        try {
            compData = new CompositeDataSupport(SERVICE_TYPE, items);
        }
        catch (OpenDataException ex) {
            throw new IllegalStateException(ex);
        }
        return compData;
    }

    public long getBundleIdentifier(long arg0) throws IOException {
        return this.getServiceStateMBean().getBundleIdentifier(arg0);
    }

    public String[] getObjectClass(long arg0) throws IOException {
        return this.getServiceStateMBean().getObjectClass(arg0);
    }

    public TabularData getProperties(long arg0) throws IOException {
        return this.getServiceStateMBean().getProperties(arg0);
    }

    public long[] getUsingBundles(long arg0) throws IOException {
        return this.getServiceStateMBean().getUsingBundles(arg0);
    }

    public TabularData listServices() throws IOException {
        return this.getServiceStateMBean().listServices();
    }
}

